function histostab(j, m, nombre_dynamique, nomparam,AC,type, hp2 )
%histostab Tracé des histogrammes quand étude de stabilité
% INPUT
% j: indice du paramètre courant
% m: nbre total de subplots
% nombre_dynamique: nbre de dynamiques demandées
% nomparam: noms des paramètres
% hp2: figure parente des subplots
%% ======================================================
              
            if isempty(nomparam)
                descript=num2str(j);
            else
	      descript=traduc_nom(nomparam{j}, type);
            end

              subplot(m,2,j,'parent',hp2)
                hist(AC)
                
                titre = ['PARAMETER ', descript ];
                title(titre);

% Argu pour dessin_hist: clic sur le graphe pour le dessiner dans
% une fenetre Matlab
structarg = {titre, AC};
set(gca,'buttondownfcn',{@dessin_hist, structarg});

end % fin histostab
%% ======================================================

function dessin_hist(obj, evt, structarg )
%dessin_hist Trace graphique de l'histo courant dans une figure matlab
titre= structarg{1};
AC= structarg{2};
hfig=figure('Name', 'Histogram');
hist(AC)
title(titre);
end % fin dessin_hist
%% ======================================================
