function reinit_mod(obj,event)
% reinit_mod Réinitialiser les parametres du modele
global input_error;

data=guidata(1);
if ~isfield(data, 'modelepop')
    return
end
if isempty(data.modelepop)
    return
end
% les bornes a partir desquelles on écrit en notation exponentielle
valinf=-1000;
valsup=+1000;

nomparam=data.nomparam;
s=find(strcmpi(data.Basemodeles.nom,data.modelepop));
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret
Basemodeles=data.Basemodeles;
%OTER?
if isfield(data, 'uniteT_pourcalcul')
    uniteT = data.uniteT_pourcalcul;
else
    uniteT= get(data.uniteT_tag, 'value');
end

% Les paramètres à estimer
for i=1:length(nomparam)
    if ~isempty(nomparam{i})
        if isempty(strfind(nomparam{i},'CV'))
            % le parametre est pas un CV
            init=Basemodeles.init.(lemodele);
        else
            init=Basemodeles.init;
        end
        % la val min
        var=[nomparam{i},'min'];
        tag=[var,'_tag'];
        
        valeur=init.(nomparam{i}){1};
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
%OTER?            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparam{i}),...
                uniteT, ...
                Basemodeles.type.(nomparam{i}));
            valeur=str2double(valeur)*fact;
        else
            valeur=str2double(valeur);
        end
        if valeur < valinf || valeur  > valsup
            valstr = num2str(valeur, '%10.2e');
        else
            valstr=num2str(valeur);
        end
        set(data.(tag),'string', valstr,'backgroundcolor','w');
        
        % oter l'indication d'eventuelles erreurs précédentes sur le champ
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        
        % la val max
        var=[nomparam{i},'max'];
        tag=[var,'_tag'];
        valeur=init.(nomparam{i}){2};
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            valeur=str2double(valeur)*fact;
        else
            valeur=str2double(valeur);
        end
        
        if valeur < valinf || valeur  > valsup
            valstr = num2str(valeur, '%10.2e');
        else
            valstr=num2str(valeur);
        end
        set(data.(tag),'string', valstr,'backgroundcolor','w');
        
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        var=[nomparam{i},'_bruit'];
        tag=[var,'_tag'];
        set(data.(tag),'value',Basemodeles.initbruit.(nomparam{i}));
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        if  get(data.cvinparam_tag, 'value')==1 && ...
                any(strcmpi(nomparam{i}, data.CVs.nomparamS))
            % les CVs sont à estimer et le parametre est un CV:
            % Oter sa valeur dans le panel du haut
            set(data.([nomparam{i},'_tag']), 'string', '-');
        end
        
    end
end


nomparamS=Basemodeles.nomparamS{s};

for j=1:length(nomparamS)
    if ~isempty(nomparamS{j})
        if  any(strcmpi(nomparamS{j}, data.CVs.nomparamS))
            % le parametre est un CV
            
            k=find(strcmp(data.CVs.nomparamS, nomparamS{j}),1);
            tag=[nomparamS{j} '_tag'];
            set(data.(tag), 'string', data.CVs.valparamS{k});
            if ~isempty(input_error) && isfield(input_error, tag)
                input_error= rmfield(input_error, tag);
            end
            tag= [nomparamS{j} '_fixtag'];
            set(data.(tag), 'string', data.CVs.valparamS{k});
            
        else
            tag=[nomparamS{j},'_tag'];
            valeur=Basemodeles.valparamS.(lemodele).(nomparamS{j});
            if  isfield(Basemodeles.type, nomparamS{j})
                if isfield(data, 'tobs') 
                    % des donnees ont été lues: convertir la val def du param selon leur unite de temps
%OTER?                    uniteT= get(data.uniteT_tag, 'value');
                    fact=timemod2data(Basemodeles.unite.(nomparamS{j}),...
                        uniteT, ...
                        Basemodeles.type.(nomparamS{j}));
                    val=Basemodeles.valparamS.(lemodele).(nomparamS{j});
                    valeur=val*fact;
                end
            end
            if valeur < valinf || valeur  > valsup
                valstr = num2str(valeur, '%10.2e');
            else
                valstr=num2str(valeur);
            end
            set(data.(tag),'string', valstr,'backgroundcolor','w');
            
        end
        
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
    end
end


handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1,ndata)

end % fin reinit_mod
