function  restore_dynamique(data, datalu, opt)
%restore_dynamique Restauration du panel d'affichage du modèle :
% Trace le 'panel' d'affichage des paramètres du modèle
% avec leurs valeurs min et max, ou bien celles fixées, et leurs bruits.
% Les valeurs affichées sont celles par défaut.
% Construit aussi le menu qui permet de (dé)fixer des paramètres.
% INPUT
% data: le handle courant
% datalu: la structure qui contient les valeurs préalablement
% sauvegardées  sur un fichier
% opt: optional.
%   - If set and equal to 1, the function is called to simulate
% data, and trace_modele must be called with argument opt=1
% APPELÉ PAR
%  la fonction  restore
%% ======================================================
% *** Restauration des valeurs par défaut ***
% Basemodeles.init.<nomparam>{1 et 2} contient les val par
% défaut des bornes des parametres a estimer
% Basemodeles.valparamS.<nomparam> contient les val par
% défaut des param fixés et les bruits par défaut sont
% dans Basemodeles.initbruit.<nomparam>

data.Basemodeles=datalu.Basemodeles;
s=find(strcmpi(datalu.Basemodeles.nom,datalu.modelepop));

% *** Le menu qui permet de fixer/défixer des parametres
% On détruit le menu précédent
delete(get(data.dynamique_tag,'children'));
% *** Le menu qui permet de défixer des parametres fixes: ***
nomparamfixes=datalu.Basemodeles.nomparamS{s};
nomparamH = datalu.Basemodeles.nomparamH{s}; %parametres scotchés
for i=1:length(nomparamfixes)
    if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
        % parametre fixe qu'on peut defixer
        uimenu(data.dynamique_tag, ...
            'Label',traduc_nom(nomparamfixes{i}),...
            'userdata', {nomparamfixes{i}},...
            'callback',@gestion_parametres,...
            'checked','off');
    end
end

% *** Le menu qui permet de fixer des parametres actifs:***
nomparamactifs=datalu.Basemodeles.nomparamP{s};
for i=1:length(nomparamactifs)
    uimenu(data.dynamique_tag,...
        'Label',traduc_nom(nomparamactifs{i}),...
        'userdata',{nomparamactifs{i}},...
        'callback',@gestion_parametres,...
        'checked','on');
end
set(data.dynamique_tag,'visible','on');
 
% En simulation de données, il n'y pas de palges de valeurs
if ~isempty(nomparamactifs{1})
  set(data.plagesmax_tag,'visible','on');
  set(data.resetmod_tag,'visible','on');
  set(data.resetdparam_tag,'visible','on');
end

% L'affichage des paramètres du modele avec leurs valeurs par défaut:
data.modelepop=datalu.modelepop;
guidata(1,data);
if (nargin >2)
    trace_modele(s, 1); %trace avec les valeurs par défaut
% le 2ieme argument de trace_modele indique que on est dans le cas de la simulation de données
else
   trace_modele(s); %trace avec les valeurs par défaut
end

end % fin restore_dynamique
