
function ajouter_comparaison_tab(obj,event)
% ajouter_comparaison_tab
% Gère le passage à un panel suivant (quand l'utilisateur clique sur un '+'
% en bas de panel)
% INPUT
% La propriété userdata de obj identifie le type de panel:
% '_control' (panel des entrées) ou '' (panel des résultats)
% INPUT/OUTPUT
% data.num_tab_tag[_control] contient le no du panel courant

%% =================================================================
data=guidata(gcf);
suffixe= get(obj, 'userdata');

% suffixe identifie le panel parent: '_control' (panel des entrées) ou ''
% si panel des résultats

num_tab_tag=['num_tab_tag' suffixe];
% num_tab_tag= le no du panel courant, celui affiché
% Ses fils sont aussi affichés
indice_panel=['indice_panel' suffixe];
if str2double(get(data.(num_tab_tag),'string'))<data.(indice_panel)
    if strcmp(suffixe, '_control')
        tag=['panel'  suffixe get(data.(num_tab_tag),'string') '_tag'];
    else
        tag=['panel' suffixe get(data.(num_tab_tag),'string') '_mod1_tag'];
        if  ~isfield(data, tag)|| ~ishandle(data.(tag))
            tag=['panel' suffixe get(data.(num_tab_tag),'string') '_mod2_tag'];
            if  ~isfield(data, tag)|| ~ishandle(data.(tag))
                tag=['panel' suffixe get(data.(num_tab_tag),'string') '_mod12_tag'];
            end
        end
        
    end
    fils=allchild(data.(tag));
    for i=1:length(fils)
        set(fils(i), 'visible','off');
    end
    set(data.(tag), 'visible','off');
    
    set(data.(num_tab_tag),'string',num2str(str2double(get(data.(num_tab_tag),'string'))+1))
    if strcmp(suffixe, '_control')
        newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_tag'];
    else
        % déterminer le panel suivant
        strnmod='1';
        autremod={'2', '12'};
        newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_mod1_tag'];
        if ~isfield(data, newpanel)|| ~ishandle(data.(newpanel))
            strnmod='2';
            autremod={'1', '12'};
            newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_mod2_tag'];
            if ~isfield(data, newpanel)|| ~ishandle(data.(newpanel))
                strnmod='12';
                autremod={'1', '2'};
                newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_mod12_tag'];
            end
            
            
        end
        
    end
    
    
    fils=allchild(data.(newpanel));
    for i=1:length(fils)
        % on n'écrit pas le type de bruit
        filstag= get(fils(i), 'tag');
        if isempty(strfind(filstag, 'bruit'))
            set(fils(i), 'visible','on');
        end
    end
    set(data.(newpanel), 'visible','on');
    
    tab_precedent_tag=['tab_precedent_tag' suffixe];
    if ~isempty(suffixe)
        % cas des entrees
        numpage=get(data.(num_tab_tag), 'String');
        tab_precedent_tag=[tab_precedent_tag num2str(numpage)];
    end
    set(data.(tab_precedent_tag),'visible','on')
    set(data.(num_tab_tag),'visible','on')
    tab_suivant_tag=['tab_suivant_tag' suffixe];
    % tester si il y a un panel suivant pour mettre le +
    if strcmp(suffixe, '_control')
        % il s'agit des panels des entrees
        if get(data.cvinparam_tag, 'value')==1
            pmax=3; % nbre de panels au total
        else
            pmax=2;
        end
    else
        % il s'agit des panels des sorties
        pmax=data.indice_panel;
    end
    num_suiv=str2double(get(data.(num_tab_tag),'string'))+1;
    
    if num_suiv <= pmax
        set(data.(tab_suivant_tag),'visible','on')
    else
        set(data.(tab_suivant_tag),'visible','off')
    end
else return
end
end % fin ajouter_comparaison_tab

