function [data indice_panel]=ecrire_fbayes(tag, indice_panel,data, tobs)
% ecrire_fbayes
% Ecrire les facteurs de Bayes pour chaque temps d'observations 
% dans un ou pls panels
% INPUT
% tag: le tag du panel à écrire
% indice_panel: indice du dernier panel écrit.
% data: la structure qui contient les résultats et le panel hpanel_work
%  (panel maitre des résultats)
% tobs: les temps d'observations
% INPUT/OUTPUT
% data: structure qui contient les résultats et les panels
% indice_panel: indice du dernier panel écrit.

%% ===============================================================
%% Ecrire les facteurs de Bayes
% On ecrit no_par_p observations par panel
no_par_p =10;
nb_items = length(data.FBevolutif);
pasecr = min(no_par_p, nb_items);
nb_p = idivide(nb_items,int32(no_par_p),'floor'); % nombre de panels nécessaires
if  mod(nb_items,no_par_p) >0
    nb_p=nb_p+1;
end
i_p=0; % indice du panel courant parmi les nb_p
pasy=0.94/pasecr; % decalage entre chaque ligne


for jdeb=1:pasecr:nb_items
    %Effacer les sorties précédentes
    fils=allchild(data.hpanel_work);
    for i =1:length(fils)
        set(fils(i), 'visible','off')
    end
    jfin=min(jdeb+pasecr-1, nb_items); %indice du dernier elt a ecrire
    
    indice_panel=indice_panel+1;
    i_p=i_p+1;
    tag=['panel' num2str(indice_panel) '_mod12_tag'];
    
    data=ecr_fbayes(tag, data, tobs, data.VraisM, data.FBayes, data.FBevolutif,...
        jdeb, jfin, i_p, nb_p, pasy, pasecr);
    if jfin== nb_items
        break;
    end
end % fin jdeb
end % fin ecrire_fbayes
%% ================================================================
function  data=ecr_fbayes(tag, data, tobs, VraisM, FBayes, FBevolutif, jdeb, jfin, i_p, n_p, pasy, pasecr)
% ecr_fbayes
% Ecriture d'un panel, parmi les nobs, affichant les facteurs de Bayes
% INPUT
% jdeb= indice de la 1ière observation à écrire
% jfin = indice de la dernière observation à écrire
% i_p: indice du panel courant parmi ceux des résultats
% n_p: nbre de panels des résultats
%% ======================================================

hp2=uipanel('parent',data.hpanel_work,...
    'tag',tag,...
    'BackgroundColor',[1 1 1],...
    'BorderType', 'none', ...
    'Position',[0 .02 1 0.98]);
hp22=uicontrol('parent', hp2,...
    'BackgroundColor','white',...
    'fontsize',12,...
    'foregroundcolor',[0 0 0],...
    'units','normalized',...
    'Position',[0 0.9 1 0.08], ...
    'style','text');
titrehp22= 'EVOLUTION OF THE MARGINAL LIKELIHOODS AND EVOLUTION OF THE BF';
if n_p > 1
    titrehp22= [titrehp22 '(' num2str(i_p)  '/'  num2str(n_p) ')'];
end
set(hp22, 'string',  titrehp22);


nomfonction={['Time (' data.uniteT_pourcalcul_libelle ')'], 'Numerator marginal likelihood', ...
    'Denominator marginal likelihood', 'BF'};
pasx=0.9/length(nomfonction);
for i=1:length(nomfonction)
    var_tag=['valeur_buttongroup'   num2str(i)  num2str(jdeb) '_tag'];
    debutx=0.05+pasx*(i-1);
    data.(var_tag)=uibuttongroup('Parent',hp2,...
        'tag',var_tag,...
        'backgroundcolor',[1 1 1],...
        'Position',[debutx .1 pasx .8]);
end

data.(tag)=hp2;  % 29/1/2014, Matlab R2013a
handles=guihandles(gcf);
ndata=catstruct(data,handles);
guidata(gcf,ndata)
data=guidata(gcf);
for i=1:length(nomfonction)
    var_tag=eval(['data.valeur_buttongroup'   num2str(i)   num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag,...
        'units','normalized',...
        'fontsize',10,...
        'position',[0 .95 1 .04],...
        'backgroundcolor',[1 1 1],...
        'foregroundcolor','k',...
        'style','text',...
        'string',nomfonction{i});
end

ilig=1;

for j=jdeb:jfin
    
    debuty=0.94-ilig*pasy;
    vrais=tobs(j);
    var_tag=eval(['data.valeur_buttongroup1' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'', num2str(vrais)});
    vrais = VraisM{1}(j);
    var_tag=eval(['data.valeur_buttongroup2' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'', num2str(vrais)});
    vrais = VraisM{2}(j);
    var_tag=eval(['data.valeur_buttongroup3' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'', num2str(vrais)});
    var_tag=eval(['data.valeur_buttongroup4' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'', num2str(FBevolutif(j),4)});
    ilig=ilig+1;
end
%% compléter eventuellement le tableau avec du grisé
ideb=ilig;
for j=ideb:pasecr
    debuty=0.94-ilig*pasy;
     var_tag=eval(['data.valeur_buttongroup1' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text');
    
    var_tag=eval(['data.valeur_buttongroup2' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text');
    
    var_tag=eval(['data.valeur_buttongroup3' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text');
    var_tag=eval(['data.valeur_buttongroup4' num2str(jdeb) '_tag']);
    uicontrol('parent',var_tag, ...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text');
    ilig=ilig+1;
end


end % fin ecr_fbayes
