function  data=plot_dyn_obs_2mod(tag, data, ...
    temps, vobs_or, pop,...
    logNbestime,  Moyenne)
% plot_dyn_obs_2mod
% Trace graphique des données et de la dynamique estimée par
% les 2 modèles (cas de la comparaison de modèles)
% Fonction appelée quand pas d'étude de stabilité

%% ======================================================

if regexp(data.modelepop1, 'Ln') ==1
    % la valeur du modele est un log népérien: on la remet en log10
    pop1= pop{1}/log(10);
    moy1=Moyenne{1}(end,:)/log(10);
else
    if model_log10(data.modelepop1)==1
  % la valeur du modele est log10(Nt)
        pop1=pop{1};
        moy1=Moyenne{1}(end,:);
    else
        pop1=log10(pop{1});
        moy1=log10(Moyenne{1}(end,:));
       % Ramener a des valeurs valides
        pop1(pop1<0) =0;
        moy1(moy1<0)=0.0;
    end
end
if regexp(data.modelepop2, 'Ln') ==1
    % la valeur du modele est un log népérien: on la remet en log10
    pop2= pop{2}/log(10);
    moy2=Moyenne{2}(end,:)/log(10);
else
    if model_log10(data.modelepop2)==1
        pop2=pop{2};
        moy2=Moyenne{2}(end,:);
    else
        pop2=log10(pop{2});
        moy2=log10(Moyenne{2}(end,:));
       % Ramener a des valeurs valides
        pop2(pop2<0) =0;
        moy2(moy2<0)=0.0;
    end
end

% Mettre dans une structure 'filtrexplot' situé dans 'base'
% ce qui est nécessaire aux graphiques de façon à pouvoir
% les retracer si clic droit dessus
sauve_hp('filtrexplot',2,...
    'temps', temps, 'vobs_or', vobs_or, ...
    'pop1', pop{1}, 'pop2', pop{2}, ...
    'log10pop1', pop1, 'log10pop2', pop2, ...
    'moy1', moy1, 'moy2', moy2, ...
    'logNbestime', logNbestime, ...
'uniteT_pourcalcul_libelle', data.uniteT_libelle);

hp3=uipanel('parent',data.hpanel_work,...
    'tag',tag,...
    'BorderType', 'none', ...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);
hptitre= uipanel('parent',hp3,...
        'BackgroundColor',[1 1 1],...
        'BorderType', 'none', ...
        'Position', [0 0.965 1 0.035]);
    


subplot(2,2,1,'parent',hp3);

% Fixer les couleurs
couleur1='b'; % bleu pour le modèle 1
couleur2=[0 128 0]/255; %un vert pour le modèle 2


% Tracé graphique dans le panel
subplot( 2,2,1); % creer 2X2 plots, se positionner sur le 1ier
plot(temps,pop1, 'Color', couleur1);
hold on
plot(temps, pop2,'Color', couleur2);
hold on
plot(temps,logNbestime,'ok')
hold off
%title('DYNAMIQUE ESTIMÉE ET DONNÉES');
%ylegend='données';
title('FINAL FILTERING ESTIMATED DYNAMICS');
ylegend='data';

% legend('estimation par le filtre 1 (modèle au numérateur)', ...
%    'estimation par le filtre 2 (modèle au dénominateur)', ...
%    ylegend,0,'location',[.70 .85 .12 .05])
legend('numerator model', 'denominator model', ...
ylegend,0,'location',[.5 .85 .12 .05])
ylabel('log10 (cfu/ml)')
xlabel(['time (' data.uniteT_libelle ')'])
set(gca,'buttondownfcn',@dessin_hp3_1_2mod);  
subplot(2,2,3) % creer 2X2 plots, se positionner sur le 3ieme

plot(vobs_or, moy1, '-', 'Color', couleur1);
hold on
plot(vobs_or, moy2,'-', 'Color', couleur2);

hold on
plot(temps,logNbestime,'ok');
xlabel(['time (' data.uniteT_libelle ')'])
ylabel('log10 (cfu/ml)')
legend('numerator model','denominator model',ylegend,0,'location',[.5 0.35 .12 .05])
%title('EVOLUTION DES ESTIMATIONS DE L''ÉTAT AU COURS DE L''UTILISATION DU FILTRE');
title('STEPWISE ESTIMATION OF THE STATE VALUE');

hax= axes('Position', [0 0 1 1],'parent',hptitre, 'Visible', 'off');
titre= 'Both models: PLOTS OF FILTERING RESULTS';
text(0.5, 0.08, titre, 'FontSize',12,'HorizontalAlignment','center', 'Parent', hax)

set(gca,'buttondownfcn',@dessin_hp3_2_2mod);
data.(tag) = hp3; % 29/1/2014, Matlab R2013a

end % plot_dyn_obs_2mod
%% ======================================================
function  dessin_hp3_1_2mod(obj, evt)
% dessin_hp3_1_2mod
% Tracé graphique dans une fenêtre graphique Matlab du 1ier plot du panel hp3
% (cas de la comparaison de modèles)

%% ======================================================

donnees = evalin('base', 'filtrexplot');
% Fixer les couleurs
couleur1='b'; % bleu pour le modèle 1
couleur2=[0 128 0]/255; %un vert pour le modèle 2

hfig=figure('Name', 'Dynamique');
hax =   axes( 'parent', hfig);

plot(hax, donnees.temps,donnees.log10pop1, 'Color', couleur1);
hold on
plot(hax,donnees.temps, donnees.log10pop2, 'Color', couleur2);
hold on
plot(hax, donnees.temps,donnees.logNbestime,'ok');
title('FINAL FILTERING ESTIMATED DYNAMICS');
%title( 'DYNAMIQUE ESTIMÉE ET DONNÉES');

legend('numerator model', 'denominator model', 'data', 0);
%legend('estimation par le filtre 1 (modèle au numérateur)', ...
%    'estimation par le filtre 2 (modèle au dénominateur)', ...
%      ylegend,0);
ylabel('log10 (cfu/ml)')
xlabel(['time (' donnees.uniteT_libelle ')'])

end %  fin dessin_hp3_1_2mod
%% ======================================================

function  dessin_hp3_2_2mod(obj, evt)
% dessin_hp3_2_2mod
% Tracé graphique dans une fenêtre graphique Matlab du 2ieme plot du panel hp3
% (cas de la comparaison de modèles)

%% ======================================================%======================================================

donnees = evalin('base', 'filtrexplot');
% Fixer les couleurs
couleur1='b'; % bleu pour le modèle 1
couleur2=[0 128 0]/255; %un vert pour le modèle 2

% vobs_or: les temps de calcul dans l'unite de temps des données
  vobs_or = donnees.vobs_or; 
% temps: les temps d'observations  dans l'unite de temps des données
  temps = donnees.temps;

hfig=figure('Name', 'Dynamique');
hax =   axes(  'parent', hfig);
plot(hax, ...
    vobs_or,donnees.moy1,  'Color', couleur1);
hold on
plot(hax,...
    vobs_or,donnees.moy2, '-', 'Color', couleur2);
hold on
plot(temps, donnees.logNbestime,'ok')
xlabel(['time (' donnees.uniteT_libelle ')'])
ylabel('log10 (cfu/ml)')
ylegend='data';


legend('numerator model','denominator model',ylegend,0)
title('STEPWISE ESTIMATION OF THE STATE VALUE');

%legend('Moyenne 1 (modèle au numérateur)','Moyenne 2 (modèle au dénominateur)',ylegend,0)
%title('EVOLUTION DES ESTIMATIONS DE L''ÉTAT AU COURS DE L''UTILISATION DU FILTRE');

end % fin dessin_hp3_2_2mod
