
function retrancher_comparaison_tab(obj,event)
% retrancher_comparaison_tab
% Gère le passage au panel précédent (quand l'utilisateur clique sur un '-'
% en bas de panel)
% INPUT
% La propriété userdata de obj identifie le type de panel:
% '_control' (panel des entrées) ou '' (panel des résultats)
% INPUT/OUTPUT
% data.num_tab_tag[_control] contient le no du panel courant

%% =================================================================


data=guidata(gcf);
suffixe= get(obj, 'userdata');

% suffixe identifie le panel parent: '_control' (panel des entrées) ou ''
% si panel des résultats
num_tab_tag=['num_tab_tag' suffixe];

num_pred=str2double(get(data.(num_tab_tag),'string'))-1;
% num_tab_tag= le no du panel courant, celui affiché
% Ses fils sont aussi affichés
if str2double(get(data.(num_tab_tag),'string'))>1
    if strcmp(suffixe, '_control')
        tag=['panel' suffixe get(data.(num_tab_tag),'string') '_tag'];
    else
        tag=['panel' suffixe get(data.(num_tab_tag),'string') '_mod1_tag'];
        if  ~isfield(data, tag) || ~ishandle(data.(tag))
            tag=['panel' suffixe get(data.(num_tab_tag),'string') '_mod2_tag'];
            if  ~isfield(data, tag) || ~ishandle(data.(tag))
                tag=['panel' suffixe get(data.(num_tab_tag),'string') '_mod12_tag'];
            end
        end
    end
    
    fils=allchild(data.(tag));
    for i=1:length(fils)
        set(fils(i), 'visible','off');
    end
    set(data.(tag), 'visible','off');
    
    set(data.(num_tab_tag),'string',num2str(str2double(get(data.(num_tab_tag),'string'))-1))
    if strcmp(suffixe, '_control')
        newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_tag'];
    else
        % déterminer le panel précédent
        strnmod='1';
        autremod= {'2', '12'};
        newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_mod1_tag'];
        if ~isfield(data, newpanel) || ~ishandle(data.(newpanel))
            % le précédent panel n'est pas relatif au modèle 1
            strnmod='2';
            autremod={'1', '12'};
            newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_mod2_tag'];
            
            if ~isfield(data, newpanel) || ~ishandle(data.(newpanel))
                % le précédent panel n'est pas relatif au modèle 2
                % le précédent panel est relatif aux 2 modèles
                strnmod='12';
                autremod={'1', '2'};
                newpanel=['panel' suffixe get(data.(num_tab_tag),'string') '_mod12_tag'];
            end
        end
    end
    
    fils=allchild(data.(newpanel));
    for i=1:length(fils)
        % on n'écrit pas le type de bruit
        filstag= get(fils(i), 'tag');
        if isempty(strfind(filstag, 'bruit'))
            set(fils(i), 'visible','on');
        end
    end
    
    set(data.(newpanel), 'visible','on');
    % si panel de résultats, mettre le titre correspondant au modèle
    if strcmp(suffixe, '')
        % Effacer les titres précédents s'ils existent
        for i=1:length(autremod)
            try
                tag= ['titre_mod' autremod{i} '_tag'];
                set(data.(tag), 'visible','off');
            end
        end
        
    end
    
    
    tab_precedent_tag=['tab_precedent_tag' suffixe];
    if ~isempty(suffixe)
        tab_precedent_tag=[tab_precedent_tag num2str(num_pred)];
    end           
        
 
 if num_pred>1
     set(data.(tab_precedent_tag),'visible','on')
 end
 if ~isempty(suffixe)
     tab_precedent_tag=['tab_precedent_tag' suffixe num2str(num_pred+1)];
     set(data.(tab_precedent_tag),'visible','off')
 else
     if num_pred==1
         set(data.(tab_precedent_tag),'visible','off')
     end
 end
    
    set(data.(num_tab_tag),'visible','on')
    tab_suivant_tag=['tab_suivant_tag' suffixe];
    set(data.(tab_suivant_tag),'visible','on')
else
        
    return
end
end  % fin retrancher_comparaison_tab

