

function [data]=trace_modele_comparaison(data, s, hd30, hd31, hd32, hd33, nmod )
% trace_modele_comparaison
% Tracé des entrées du modele choisi, lors de la comparaison
% de modèles
% Les valeurs affichées sont celles par défaut du modèle
% INPUT
% s: indice du modèle parmi la liste de tous les modèles
% nmod: no du modèle  (1 ou 2)
% NOTE dans cette version, le bruit est non visible: il est fixé a la valeur par défaut.
% pour réautoriser le choix du bruit par l'utilisateur, décommenter
% les phrases commençant par % visible noise
%% ======================================================
% les bornes a partir desquelles on écrit en notation exponentielle
valinf=-1000;
valsup=+1000;

Basemodeles=data.Basemodeles;
CVs=data.CVs;
modelepop=Basemodeles.nom{s};
lemodele=strrep(modelepop, '-',''); %le nom du modele sans tiret
strnmod = num2str(nmod); %no du modele en string
tag= ['modele', strnmod , '_tag'];

switch nmod
    case 1
        data.modelepop1=modelepop;
        %nomcourt est introduit en oct 2014 (nom abrégé du modèle)
        if isfield(Basemodeles, 'nomcourt')
            data.shortmodel1=Basemodeles.nomcourt{s};
        else
            data.shortmodel1=Basemodeles.nom{s};
        end
        
        typemod = ' Numerator';
        set(data.min_tag,'visible','on')
        set(data.max_tag,'visible','on')
        % visible noise:         set(data.bruit_tag,'visible','on')
    case 2
        
        data.modelepop2=modelepop;
        %nomcourt est introduit en oct 2014 (nom abrégé du modèle)
        if isfield(Basemodeles, 'nomcourt')
            data.shortmodel2=Basemodeles.nomcourt{s};
        else
            data.shortmodel2=Basemodeles.nom{s};
        end
        
        typemod = ' Denominator';
        set(data.minb_tag,'visible','on')
        set(data.maxb_tag,'visible','on')
        % visible noise:         set(data.bruitb_tag,'visible','on')
        
end
set(data.(tag), 'string',[typemod , ' model: ',modelepop]);
set(data.(tag), 'visible', 'on');


nomparamP=Basemodeles.nomparamP{s};
nomparamS=Basemodeles.nomparamS{s};
init=Basemodeles.init;



pasy=1/8;
if length(nomparamS)+length(nomparamP)>7
    pasy=0.98/(length(nomparamS)+length(nomparamP));
end

%% Effacer l'éventuel choix précédent
delete(get(hd30, 'children'));
delete(get(hd31, 'children'));
delete(get(hd32, 'children'));
delete(get(hd33, 'children'));
set(hd30, 'visible', 'on');
set(hd31, 'visible', 'on');
set(hd32, 'visible', 'on');
set(hd33, 'visible', 'on');




%% Affichage des valeurs min et max  par défaut des paramètres actifs
% sans afficher les Cvs qui seront affichés dans un écran distinct
% car ils doivent avoir la même valeur dans les 2 modèles

iver=0; %initialiser le déplacement vertical pour le cas où il n'y aurait pas de paramètres actifs


for i=1:length(nomparamP)
    
    if ~isempty(nomparamP{i})
        if any(strcmpi(nomparamP{i}, CVs.nomparamS))
            continue
        end
        iver=iver+1; % déplacement vertical
        % Ecrire le nom du paramètre
        lastring=traduc_nom(nomparamP{i}, Basemodeles.type);
        letag=[nomparamP{i} ,'_mod', strnmod, '_txttag'];
        hd=uicontrol('parent',hd30,...
            'units','normalized',...
            'position',[0 .96-pasy*iver 1 pasy],...
            'style','text',...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
            'tag', letag, ...
            'string', lastring);
        data.(letag)=hd;
        
        minmaxdef= init.(lemodele).(nomparamP{i});
        valbornes=Basemodeles.DF.(lemodele).(nomparamP{i});
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparamP{i})
            % des donnees ont été lues: convertir les bornes du param selon leur unite de temps
            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparamP{i}),...
                uniteT, ...
                Basemodeles.type.(nomparamP{i}));
            a=str2double(minmaxdef{1})*fact;
            minmaxdef{1}=num2str(a);
            a=str2double(minmaxdef{2})*fact;
            minmaxdef{2}=num2str(a);
            a=str2double(valbornes{1})*fact;
            valbornes{1}=num2str(a);
            a=str2double(valbornes{2})*fact;
            valbornes{2}=num2str(a);
        end
        
        % ecrire le min
        nomvar=[nomparamP{i},'min_mod', strnmod];
        tag=[nomvar,'_tag'];
        hd=uicontrol('parent',hd31,...
            'units','normalized',...
            'position',[0 1-pasy*iver 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
            'userdata', {valbornes,traduc_nom(nomparamP{i})}, ...
            'style','edit');
        data.(tag)= hd; % Matlab13a 29/1/14
        
        valstr=minmaxdef{1}; % valeur en caracteres
        val=eval(valstr );   % valeur en num       
        if val < valinf || val > valsup
            valstr=num2str(val, '%10.2e');
        end        
        set(hd,'string',valstr)
        data.([nomparamP{i},'min'])=val;
        
        % Mettre les valeurs dans data, sous ce nom, car des valeurs min et max initiales
        % de certains parametres dépendent des précédentes
        
        
        % Ecrire le max
        nomvar=[nomparamP{i},'max_mod', strnmod];
        tag=[nomvar,'_tag'];
        hd=uicontrol('parent',hd32,...
            'units','normalized',...
            'position',[0 1-pasy*iver 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
            'userdata', {valbornes,traduc_nom(nomparamP{i})}, ...
            'style','edit');
        data.(tag)= hd; % Matlab13a 29/1/14
        
        valstr=minmaxdef{2};
         val=eval(valstr );   % valeur en num       
        if val < valinf || val > valsup
            valstr=num2str(val, '%10.2e');
        end        
        set(hd,'string',valstr)
 
        %le bruit
        % dans cette version, il est non visible: il est fixé a la valeur par défaut
        % visible noise: 'Visible', 'on', ...
        
        decal=0.02;
        nomvar=[nomparamP{i},'_bruit_mod', strnmod];
        tag=[nomvar,'_tag'];
        br=uicontrol('parent',hd33,...
            'Visible', 'off', ...
            'units','normalized',...
            'position',[0 1-decal-pasy*iver 1 pasy-decal],...
            'backgroundcolor','w',...
            'tag',tag,...
            'style','popupmenu',...
            'string','   Poisson|   Gaussian');
        %            'string','   Poisson|   Gaussian|Binomial');
        
        set(br,'value',data.Basemodeles.initbruit.(nomparamP{i}))
        data.(tag)= br; % Matlab13a 29/1/14
        
    end % fin ~isempty
    
    
end % fin i


%% Affichage des valeurs par défaut des paramètres fixes
for j=1:length(nomparamS)
    if ~isempty(nomparamS{j})
        
        if any(strcmpi(nomparamS{j}, CVs.nomparamS))
            continue
        end
        iver=iver+1; % incrémenter le déplacemant vertical
        % Ecrire le nom du paramètre
        lastring=traduc_nom(nomparamS{j}, Basemodeles.type);
        letag=[nomparamS{j},'_mod', strnmod, '_txttag'];
        
        hd=uicontrol('parent',hd30,...
            'units','normalized',...
            'position',[0 1-pasy*iver 1 pasy],...
            'style','text',...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
            'tag', letag, ...
            'string', lastring);
        data.(letag)=hd;
        
        % Ecrire la valeur fixe
        valfix=Basemodeles.valparamS.(lemodele).(nomparamS{j});
        valbornes=Basemodeles.DF.(lemodele).(nomparamS{j});
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparamS{j})
            % des donnees ont été lues: convertir les bornes du param selon leur unite de temps
            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparamS{j}),...
                uniteT, ...
                Basemodeles.type.(nomparamS{j}));
            a=str2double(valbornes{1})*fact;
            valbornes{1}=num2str(a);
            a=str2double(valbornes{2})*fact;
            valbornes{2}=num2str(a);
            valfix=valfix*fact;
        end
        
        tag=[nomparamS{j},'_mod', strnmod, '_tag'];
        hd=uicontrol('parent',hd31,...
            'units','normalized',...
            'position',[0 1-pasy*iver 2.02 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'userdata', {valbornes,traduc_nom(nomparamS{j})}, ...
            'callback',@control_saisie,...
            'style','edit');
        data.(tag)= hd; % Matlab13a 29/1/14
        
        val= valfix;
        
        
        if val < valinf || val > valsup
            
            valstr=num2str(val, '%10.2e');
            set(hd,'string', valstr)
        else
            set(hd,'string',num2str(val))
        end
        
        
    end
end


data.(['nomparam', strnmod])=nomparamP;
data.(['nomparamS', strnmod])=nomparamS;
data.(['nomparamH', strnmod])=data.Basemodeles.nomparamH{s};%%30/12

handles=guihandles;
ndata=catstruct(data,handles);
guidata(1,ndata)
end %fin trace_modele_comparaison
