function [ VraisM ] = calcul_vraisemblance( Ytheorique, diffM, n)
%calcul_vraisemblance Compute likelihood of a model
%
%% =====================================================
%% Calcul des p^n(y(t+1)|y1:t) (element pour vraisemblance)
% intervalle interquartile des estimations (Ytheorique) (qx1)
tempiqrM=iqr(Ytheorique,2)./1.34;
tempiqrM(tempiqrM==0)=Inf; %aux premieres iterations iqr est nul ...?
% Parametre de la fenetre du noyau (qx1), formule de Silverman
deltaMSilver=1.06.*min(std(Ytheorique,0,2),tempiqrM)./(n^(1/(4+length(tempiqrM))));
% Calcul des noyaux
diffSilverM=diag(1./deltaMSilver)*diffM; % (qxn)
KDeltaM=exp(-0.5*sum(diffSilverM.^2,1))./prod(deltaMSilver);  % = produit des noyaux gaussiens (1xn)
VraisM=sum(KDeltaM);%*cteHuge;
end

