
function gestion_parametres(obj,~)
%gestion_parametres What is done when a model parameter is fixed or unfixed
% INPUT
% The parameter name is in the property 'userdata{1}' of obj
% Second argument ignored
%% ======================================================

data=guidata(1);

s=find(strcmpi(data.Basemodeles.nom,data.modelepop));
userdata=get(obj,'userdata');
lab=userdata{1}; % le nom du paramètre à fixer/défixer

if length(userdata)>1
    meth=userdata{2};
% dans le cas de la simulation de strategie, userdata{2}=1,2 ou 3 selon la methode
    programme= ['trace_modele_simulation(s,', num2str(meth), ');'];
else
    programme= 'trace_modele(s);';
% OTER?    programme= 'trace_modele(s, 2);';
% le 2ieme argument de trace_modele signifie que on est pas dans le cas
% de la simulation de donnees
end


nomparamP=data.Basemodeles.nomparamP{s}; %active parameters
nomparamS=data.Basemodeles.nomparamS{s}; % fixed  parameters
nomparam={};
vect={};

%% On garde les valeurs courantes des param pour pouvoir
%% rétablir celles qui n'ont pas été fixées/défixées
datalu=data;
% Parametres actifs
for i=1:length(nomparamP)
    var=[nomparamP{i},'max'];
    tag=[var,'_tag'];
    lin=[var,'_in'];
    vv=get(data.(tag),'string');
    if iscell(vv)
        vv=vv{1};
    end
    datalu.(lin) = vv;
    
    var=[nomparamP{i},'min'];
    tag=[var,'_tag'];
    lin=[var,'_in'];
    vv=get(data.(tag),'string');
    if iscell(vv)
        vv=vv{1};
    end
    datalu.(lin) = vv;

    
    var=[nomparamP{i},'_bruit'];
    tag=[var,'_tag'];
    lin=[var,'_in'];
    try % prevoir le cas ou il n'y a pas de bruit
        vv=get(data.(tag),'value');
        if iscell(vv)
            vv=vv{1};
        end
        datalu.(lin) = vv;

    end
end
% Parametres fixes
for i=1:length(nomparamS)
    var=nomparamS{i};
    tag=[var,'_tag'];
    lin=[var,'_in'];
    vv=get(data.(tag),'string');
    if iscell(vv)
        vv=vv{1};
    end
    datalu.(lin) = vv;

    % garder les parametres cts de Tornsey
    tag=[var,'_fix_tornsey'];
    lin=[tag,'_in'];
    datalu.(lin)=get(data.(tag),'visible');
end
%% fin sauvegarde
lesctes={}; % Parametres fixes constants (cf ci-apres)

if strcmpi(get(obj,'checked'),'on')
    % on fixe le parametre 'lab'
    if length(nomparamP)==1
        errordlg('At least one parameter should be to estimated','Fixation limit','modal')
        return
    end
    vp=find(strcmpi(nomparamP,lab));
    j=1;
    for i=1:length(nomparamP)
        if i==vp
            continue
        end
        nomparam{j}=nomparamP{i};
        j=j+1;
    end
    set(obj,'checked','off')
    data.Basemodeles.nomparamP{s}=nomparam;
    % Si le paramètre est déjà fixé, c'est qu'on est dans le
    % cas de la simulation de strategie opt, methode Tornsey, où tous les paramètres
    % sont supposés fixés a priori, et qu'on veut le considérer constant
    % On le garde pour pouvoir rajouter une marque dans l'affichage et le
    % retrouver
    if any(strcmpi(nomparamS, lab))
       lesctes{end+1}=lab;
      else
       % mettre le parametre fixé en fin de liste
       nomparamS{end+1}=lab;
    end
    data.Basemodeles.nomparamS{s}=nomparamS;
else
    % on défixe le parametre lab
    set(obj,'checked','on')
    % oter la marque dans le cas de la simulation de strategie opt, methode Tornsey
    tag=[lab,'_fix_tornsey'];
    if strcmp(get(data.(tag),  'visible'), 'on')
        set(data.(tag),  'visible', 'off')
        lin=[tag '_in'];
        datalu.(lin)='off';
        
    else
        vp=find(strcmpi(nomparamS,lab));
        j=1;
        for i=1:length(nomparamS)
            if i==vp
                continue
            end
            nomparam{j}=nomparamS{i};
            j=j+1;
        end
        
        data.Basemodeles.nomparamS{s}=nomparam;
        k=1;
        trouve=1;
        for i=1:length(nomparamP)
            if find(strcmpi(nomparamP{i},'CVpesee'))
                vect{k}=lab;
                k=k+1;
                trouve=0;
            end
            vect{k}=nomparamP{i};
            k=k+1;
        end
        if trouve
            vect{end+1}=lab;
        end
        data.Basemodeles.nomparamP{s}=vect;
    end
end
guidata(1,data);

eval(programme);
data=guidata(gcf);


%% Restauration de la valeur des paramètres
%% qui n'ont pas été modifiés
nomparamP=data.Basemodeles.nomparamP{s};
nomparamS=data.Basemodeles.nomparamS{s};

%% On remet les valeurs des parametres qui n'ont pas été fixés
for i=1:length(nomparamP)
    var=[nomparamP{i},'min'];
    tag=[var,'_tag'];
    lin=[var,'_in'] ;
    
    %On teste que la valeur min du parametre, car s'il s'agit
    % d'un parametre précédemment fixé, celle-ci n'existe pas.
    % Dans ce cas, c'est le min par défaut qui s'affichera
    try
        set(data.(tag),'string', eval(['datalu.',lin]), 'backgroundcolor','w')
    end
    
    
    var=[nomparamP{i},'max'];
    tag=[var,'_tag'];
    lin=[var,'_in'] ;
    try
        set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w')
    end
    
    var=[nomparamP{i},'_bruit'];
    tag=[var,'_tag'] ;
    lin=[var,'_in'] ;
    try
        set(data.(tag),'value',eval(['datalu.',lin]),'backgroundcolor','w');
    end
    
end


%% On remet les valeurs des parametres qui n'ont pas été défixés
for i=1:length(nomparamS)
    var=nomparamS{i};
    tag=[var,'_tag'];
    lin=[var,'_in'] ;
    
    %On teste que la valeur min du parametre, car s'il s'agit
    % d'un parametre précédemment a estimer, celle-ci n'existe pas.
    % Dans ce cas, c'est la val min par défaut qui s'affichera
    try
        set(data.(tag),'string', eval(['datalu.',lin]), 'backgroundcolor','w')
    end
    % remettre ou pas le symbole devant les parametres qui sont constants
%  dans le cas de la simulation de strategie opt, methode Tornsey
   try
    tag=[var,'_fix_tornsey'];
      lin=[tag,'_in'] ;
      set(data.(tag),'visible', datalu.(lin));
   end
end

%% On met un symbole devant les parametres qui sont constants
%  dans le cas de la simulation de strategie opt, methode Tornsey
for i=1:length(lesctes)
    letag=[lesctes{i} '_fix_tornsey'];
    set(data.(letag),'visible', 'on');
end


    
%% Affichage
guidata(1,data);

end % fin gestion_parametres
