function[data]= init_estimation(groupebutton21,	groupebutton22, ...
    groupebutton23,	groupebutton24, groupebuttontime, bgcolor)
%init_estimation Add the structures Basemodeles, CVs and Filtre into data

%% ======================================================
CVs=init_CVs();
data.Basemodeles=init_Basemodeles();
data.CVs=init_CVs();
Filtre=init_Filtre();
data.Filtre=init_Filtre();
% variables de modele
data.nomparam={};
data.fctprior={};
data.ajoutbruit=[];
% fichier d'observation
data.releveobs={};


% pas de temps
data.deltaT='-';
% sauvegarde de Temp pour calculer Tempmax
data.Temp=8;
data.tracehistogramme=0;



%Pour la mise en cadre des cadres
hautcase = 1/4;  % hauteur d'une case

% construction de parametre de modele d'observation
for i=1:length(CVs.nomparamS)
    var=CVs.nomparamS{i};
    data.(var)=eval(CVs.valparamS{i});
     uicontrol('parent',groupebutton21,...
         'units','normalized',...
         'fontsize',9,...
         'foregroundcolor',[.3 .1 .5],...
         'backgroundcolor',bgcolor,...
         'position',[0 1-hautcase*i 1 hautcase],...
         'style','text',...
         'string', {'',traduc_nom(CVs.nomparamS{i}, data.Basemodeles.type)});
    tag=[var,'_tag'];
     hd=uicontrol('parent',groupebutton22,...
         'units','normalized',...
         'position',[0 1-hautcase*i 1 hautcase],...
         'backgroundcolor','w',...
         'tag',tag,...
         'userdata',{CVs.DF{i},traduc_nom(CVs.nomparamS{i})}, ...
         'interruptible','off',...
         'callback',@control_saisie,...
         'style','edit');
     set(hd,'string',eval(['data.',var]))
end

nbcases=6;
lgcase=1/nbcases;


hd=uicontrol('parent',groupebuttontime,...
    'units','normalized',...
    'position',[lgcase 0 0.15 1],...
    'backgroundcolor','w',...
    'tag','uniteT_tag',...
    'Min', 1,...
    'Max', 1,...
    'String', '       DAY|       HOUR|       MINUTE',...
    'interruptible','off',...
    'enable', 'off', ...
'Visible', 'off', ...
    'style','popupmenu');

uicontrol('parent',groupebuttontime,...
    'units','normalized',...
    'fontsize', 8, ...
    'foregroundcolor',[.3 .1 .5],...
    'backgroundcolor', bgcolor,...
    'position',[0.12 0.06 0.13 0.6],...
    'style','text',...
    'tag', 'saisie_tps_tag',...
    'string','TIME STEP');

hd=uicontrol('parent',groupebuttontime,...
    'units','normalized',...
    'position',[0.25 0.18 0.15 0.6],...
    'backgroundcolor','w',...
    'tag','deltaT_tag',...
    'interruptible','off',...
    'callback',@control_pas_calculs,...
    'style','edit');
set(hd,'string',data.deltaT)

uicontrol('parent',groupebuttontime,...
    'units','normalized',...
    'fontsize', 8, ...
    'foregroundcolor',[.3 .1 .5],...
    'backgroundcolor', bgcolor,...
    'position',[2*lgcase+0.33 0.06 0.15 0.6],...
    'style','text',...
    'tag', 'proposition_tag',...
    'string','PROPOSITION');
hd=uicontrol('parent',groupebuttontime,...
    'units','normalized',...
    'position',[0.825 0.18 0.15 0.6],...
    'tag','pas_tag',...
    'interruptible','off',...
    'style','edit',...
    'fontAngle', 'italic', ...
    'enable','off');
set(hd,'string',data.deltaT)



% construction de parametre de filtre
% Bouton help pour les windows
help_icon = imread('SRC/IMG/help.jpg', 'jpg');

hautcase=1/length(Filtre.nomparamS);

% ordre de presentation
ipres=Filtre.ipres;

for i=1:length(Filtre.nomparamS)
    ii=find(ipres==i);
    var=Filtre.nomparamS{ii};
    if i==1
        data.(var)=eval(Filtre.valparamS{ii});
    else
        data.(var)=Filtre.valparamS{ii};
    end
    
    tag=[var,'_chaine'];
    hd=uicontrol('parent',groupebutton23,...
        'units','normalized',...
        'fontsize',8,...
        'foregroundcolor',[.4 0 .2],...
        'backgroundcolor',bgcolor,...
        'position',[0 1-hautcase*i 1 hautcase],...
        'style','text',...
        'tag', tag, ...
        'string',Filtre.chaine{ii});
    
    
    tag=[var,'_tag'];
    switch Filtre.chaine{ii}{2}
        case 'SEED'
            % valeur alpha-numerique a controler
            hd=uicontrol('parent',groupebutton24,...
                'units','normalized',...
                'position',[0 1-hautcase*i 1 hautcase],...
                'backgroundcolor','w',...
                'tag',tag,...
                'callback',@control_saisie_an,...
                'interruptible','off',...
                'userdata',{Filtre.DF{ii},Filtre.chaine{ii}}, ...
                'style','edit', ...
                'String', eval(['data.',var]));
        case 'PARTICLE CI LEVEL'
            % type listbox
            hd=uicontrol('parent',groupebutton24,...
                'units','normalized',...
                'position',[0 1-hautcase*i 1 hautcase],...
                'backgroundcolor','w',...
                'tag', tag, ...
                'Min', 1,  'Max', 1,...
			 'String', {...
'                       90%', ...
'                       95% ', ...
'                       99% '},...
                'Value', 2 , ...
                'style','listbox');
        otherwise
            hd=uicontrol('parent',groupebutton24,...
                'units','normalized',...
                'position',[0 1-hautcase*i 1 hautcase],...
                'backgroundcolor','w',...
                'tag',tag,...
                'callback',@control_saisie,...
                'interruptible','off',...
                'userdata',{Filtre.DF{ii},Filtre.chaine{ii}}, ...
                'style','edit', ...
                'String', eval(['data.',var]));
    end
    
end



        % rajouter l'icone d'aide
        uicontrol('parent',groupebutton23,...
            'units', 'normalized', ...
            'style', 'pushbutton', ...
            'position',[0.85 0.5+0.02 0.05 0.1],...
            'backgroundcolor',bgcolor,...
            'cdata', help_icon, ...
            'enable', 'inactive', ...
            'ButtonDownFcn', @help_filterparameters);
        

    
return
end % fonction init_estimation
%% =========================================================

function control_pas_calculs(obj, event)
% control_pas_calculs
% Controler le pas de temps de calcul  introduit par l'utilisateur

%% ======================================================

user_entry = str2num(get(obj,'string'));
if isnan(user_entry)
    try user_entry = eval(get(obj,'string'));
    catch
        errordlg(' TIME STEP is not a numerical value','Bad Input','modal')
        set(obj,'backgroundcolor',[1 1 1])
        uicontrol(obj)
        return
    end
end

if  isempty(user_entry)
    try user_entry = eval(get(obj,'string'));
    catch
        errordlg(' TIME STEP is not a numerical value','Bad Input','modal')
        set(obj,'backgroundcolor',[1 1 1])
        uicontrol(obj)
        return
    end
end

if isempty(user_entry)
    errordlg(' TIME STEP is not a numerical value','Bad Input','modal')
    set(obj,'backgroundcolor',[1 1 1])
    uicontrol(obj)
    return
end
data=guidata(1);

%% AU CAS OU...
 % Afficher l'unité de temps si on la connait
 % try
 %    data=afficher_uniteT(data);
 %



%Vérifier que le  pas de calcul est un diviseur de la proposition
% Mettre dans un try car la proposition n'existe pas, quand on a
% restauré des données

try
    proposition=eval(get(data.pas_tag,'string'));
    %  Reautoriser le changement de pas de temps
    if (proposition~=1)
        set(data.deltaT_tag, 'enable', 'on');
    else
        set(data.deltaT_tag, 'string', '1', 'enable', 'off');
        
    end
    if proposition && mod(proposition, user_entry)
        errordlg([' TIME STEP ',get(obj,'string'),...
            ' should divide: ' get(data.pas_tag,'string')] ,'Bad Input','modal')
        set(obj,'backgroundcolor',[1 1 1])
        uicontrol(obj)
    end
end
% Oter l'affichage du nombre de temps de calcul
% car celui-ci change si on change le time step
descrfile=get(data.fichier_descr_tag, 'String');
if ~isempty(strfind(descrfile, 'Number of computational times'))
   descrfile= regexprep(descrfile, '; Number of computational times:.*', '');
   set(data.fichier_descr_tag, 'String', descrfile);
end


end % fin control_pas_calculs

