function [Xt,Xmin,Xmax]=initialisation_particules(n, nmod)
%initialisation_particules Initialization of the state vector (vecteur d'etat)
% by random numbers generated from a continuous uniform distribution
% INPUT
% nmod=0 when there is one model, only (parametric identification) and is the
% number of the current model when there are 2 (models comparison)
% OUTPUT
% Xt=[parametres;eventuels coefficients de variation;effectif]

%% =====================================================================
data=guidata(gcf);
strnmod = num2str(nmod);
if nmod >0
    var=['nomparam' strnmod];
    varS=['nomparamS' strnmod];
    suffixe=['_mod'  strnmod];
else
    var='nomparam';
    varS='nomparamS';
    suffixe='';
end

nomparam=data.(var);
nomparamS=data.(varS);
len=length(nomparam);
Xt=zeros(len,n);
Xmin=Xt;
Xmax=Xmin;
for i=1:len
    var1=[nomparam{i},'max' suffixe];
    Xmax(i,:)=eval(['data.',var1]);
    var2=[nomparam{i},'min' suffixe];
    Xmin(i,:)=eval(['data.',var2]);
    Xt(i,:)=unifrnd(Xmin(i,1),Xmax(i,1),1,n);
end

%% Search for the bounds of the init particles
N0min='';
for i=1:len
    if ~isempty(strfind(nomparam{i}, 'N0'))
        % le nom du parametre contient 'N0'
        N0min = [nomparam{i} 'min' suffixe];
        N0max = [nomparam{i} 'max'  suffixe];
        break;
    end
end

if isempty(N0min)
    for i=1:length(nomparamS)
        if ~isempty(strfind(nomparamS{i}, 'N0'))
            % le nom du parametre contient 'N0'
            N0min = [nomparamS{i} 'min' suffixe];
            N0max = [nomparamS{i} 'max'  suffixe];
            break;
        end
    end
end

%% Exception pour Leguerinel
if isempty(N0min)
    if any(strcmpi(nomparamS, 'K'))
        Basemodeles= init_Basemodeles();
        leN0min = eval(Basemodeles.DF.Leguerinel.K{1});
        leN0max= eval(Basemodeles.DF.Leguerinel.K{2});
    else
        errordlg('Internal error: initialisation_particules');
        return;
    end
    
end
    

if ~isempty(N0min)
    leN0min = data.(N0min);
    leN0max = data.(N0max);
end

Xt(end+1,:)=unifrnd(leN0min, leN0max,1,n);
end %fin initialisation_particules
% ================================================
