
function openfichier(obj,event)
%openfichier Read the observations dataset file

%% ======================================================
data=guidata(1);

[fileName, pathName] = uigetfile( ...
	  [getenv('DATADIR') '/*.*'],  ...
    'Select a filename');
if isequal(fileName,0) || isequal(pathName,0)
    return;
end
chemin=fullfile(pathName, fileName);
drawnow

try
    [releveobs, txt]=xlsread(chemin);
catch
    fid=fopen(chemin);
    % lecture de tout le fichier
    txt= textscan(fid, '%s', 'Delimiter', '\n');
    lu=txt{1};
    txt{1}=txt{1}{1}; % la 1iere ligne= les labels de colonnes
    [nobs,  ~]= size(lu);%nobs = nbre de lignes  du fichier
    % allocation du tableau des valeurs:
    % nbre d'obs = nbre de lignes  du fichier - la ligne de labels
    % nbre de variables=9
    nvar=9;
    releveobs= zeros(nobs-1, nvar);

    for i=2:nobs
                
        if isempty(lu{i}) 
            % fin de fichier
            releveobs=releveobs(i-1, :);
            break;
        else
            
            b=regexp(lu{i}, ',','split'); %valeurs séparées par des virgules
                       
            for j=1:nvar
                releveobs(i-1, j)= str2num(b{1,j});
            end
        end
    end
        

    fclose(fid);
    
    
end

%% determiner l'unite de temps d'après le label de la 1iere colonne
valeur=timelabel(txt{1});

 set(data.uniteT_tag, 'Value', valeur);
data = initdata(data, releveobs,  fileName);

end % fin openfichier

%% ======================================================
