function plagesmax_mod(obj,event)
% plagesmax_mod Mettre les plages maximales aux parametres actifs du modele
global input_error;

data=guidata(1);
if ~isfield(data, 'modelepop')
    return
end
if isempty(data.modelepop)
    return
end
% les bornes a partir desquelles on écrit en notation exponentielle
valinf=-1000;
valsup=+1000;

nomparam=data.nomparam;
s=find(strcmpi(data.Basemodeles.nom,data.modelepop));
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret
Basemodeles=data.Basemodeles;
%OTER?
if isfield(data, 'uniteT_pourcalcul')
    uniteT = data.uniteT_pourcalcul;
else
    uniteT= get(data.uniteT_tag, 'value');
end

% Les paramètres à estimer
for i=1:length(nomparam)
    if ~isempty(nomparam{i})
        if isempty(strfind(nomparam{i},'CV'))
            % le parametre est pas un CV
            init=Basemodeles.DF.(lemodele);
        else
            init=Basemodeles.DF;
        end
        % la val min
        var=[nomparam{i},'min'];
        tag=[var,'_tag'];
        
        valeur=init.(nomparam{i}){1};
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
 %OTER?           uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparam{i}),...
                uniteT, ...
                Basemodeles.type.(nomparam{i}));
            valeur=str2double(valeur)*fact;
        else
            valeur=str2double(valeur);
        end
        if valeur < valinf || valeur  > valsup
            valstr = num2str(valeur, '%10.2e');
        else
            valstr=num2str(valeur);
        end
        set(data.(tag),'string', valstr,'backgroundcolor','w');
        
        % oter l'indication d'eventuelles erreurs précédentes sur le champ
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        
        % la val max
        var=[nomparam{i},'max'];
        tag=[var,'_tag'];
        valeur=init.(nomparam{i}){2};
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            valeur=str2double(valeur)*fact;
        else
            valeur=str2double(valeur);
        end
        
        if valeur < valinf || valeur  > valsup
            valstr = num2str(valeur, '%10.2e');
        else
            valstr=num2str(valeur);
        end
        set(data.(tag),'string', valstr,'backgroundcolor','w');
        
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end

    end
end




handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1,ndata)

end % fin plagesmax_mod
