
function [data, tobs, deltaT, bruitetat,Fnoyau,Fpert, iclevel, ...
    tracehistogramme, nbparticules,...
    graineAlea] = recup_interface( data, event, nmod)
% recup_interface Get input from the user-input panel
% INPUT
% If event length is positive, user dialogue is  suppressed
%  (case of a non-interactive execution of a series of tests) 
% (In fact, it is ignored: dialogue always suppressed)
% nmod: number of models (=2 if models comparison)

%% =========================================================

%% recupération des observations
if isempty(data.releveobs)
    errordlg('Please, enter a data (or simulated data) filename', 'NO DATA');
    return
end

for i=1:nmod
    if nmod >1
        strnmod = num2str(i);
    else
        strnmod = '';
    end
    lemodele=['modelepop' strnmod];
    if ~isfield(data, lemodele)
        errordlg(['Please, select the dynamics equation model', strnmod], 'NO MODELE');
        return
    end
    
    
end % fin i

%% recuperation des valeurs des parametres principaux et secondaires
err=0;
if nmod >1
    for i=1:nmod
        [data, err] =recup_param(data,i);
        if err>0
            return
        end
    end
else
    [data, err] =recup_param(data,0);
    if err>0
        return
    end
end


%%
%% recuperation des valeurs des coefficients de variation s'ils ne figurent
%% pas dans l'ensemble des parametre a estimer
if ~get(data.cvinparam_tag,'value')
    data.cvinparam_in=0;
    lestags= data.CVs.nomparamS;
lesvar = lestags;
    DF=data.CVs.DF;
    
    for i=1:length(lestags)
        letag=[lestags{i} '_tag'];
        vv=get(data.(letag), 'String');
        if iscell(vv)
            vv=vv{1};
        end
        eval([lesvar{i} ' = str2num(vv);']);
        
        if isempty(eval(lesvar{i}))
            errordlg([traduc_nom(lestags{i}) ' is not a numeric value'],'Bad Input','modal');
            return
        end
        if ~isempty(DF{i}) && ...
                (eval(lesvar{i}) < str2num(DF{i}{1}) || eval(lesvar{i}) >str2num(DF{i}{2}))
	errordlg([traduc_nom(lestags{i}) ' is not between ',DF{i}{1},' and ',DF{i}{2}] ,'Bad Input','modal')
            return
        end
    end
    
else
    data.cvinparam_in=1;
end
%% Autres récupérations
lestags= data.Filtre.nomparamS;
lesvar =  { 'nbparticules', 'graineAlea', 'Fnoyau', 'Fpert', 'bruitetat', 'iclevel'};
DF=data.Filtre.DF;

for i=1:length(lestags)
    if i==2
        continue; % la graine est un cas particulier car peut etre String
    end
    letag=[lestags{i} '_tag'];
    style=get(data.(letag), 'style');
    if iscell(style)
        style=style{1};
    end
    if strcmpi(style, 'listbox')
        vv=get(data.(letag), 'value');
        if iscell(vv)
            vv=vv{1};
        end
        eval([lesvar{i} ' =vv;']);
    else
        vv=get(data.(letag), 'String');
        if iscell(vv)
            vv=vv{1};
        end

        eval([lesvar{i} ' = str2num(vv);']);
        
    end
    if isempty(eval(lesvar{i}))
        errordlg([data.Filtre.chaine{i} ' is not a numeric value'],'Bad Input','modal');
        return
    end
    if ~isempty(DF{i}) && ...
            (eval(lesvar{i}) < str2num(DF{i}{1}) || eval(lesvar{i}) >str2num(DF{i}{2}))
        errordlg([data.Filtre.chaine{i} ' is not between ',DF{i}{1},' and ',DF{i}{2}] ,'Bad Input','modal')
        return
    end
end



try
    tracehistogramme=get(data.hist_tag,'value');
catch
    tracehistogramme=0;
end



% recuperation de l'unité de temps des données:
uniteT=get(data.uniteT_tag,'value');
if iscell(uniteT)
    uniteT=uniteT{1};
end
%% Conversion des temps d'observations en heures ou minutes

[tobs, data.tobsfactT, data.uniteT_libelle, ...
    data.uniteT_pourcalcul, ...
    data.uniteT_pourcalcul_libelle]  = convert_tps_decimaux( data.tobs, uniteT);



%% calcul du pas de temps des calculs
if strcmp(get(data.deltaT_tag,'visible'), 'on')==1
    try
        % recuperation de l'eventuelle valeur introduite par l'utilisateur
        vv=get(data.deltaT_tag,'string');
        if iscell(vv)
            vv=vv{1};
        end
        deltaT=eval(vv);
        
    catch
        % si aucune valeur n'est introduite on releve une exception
        errordlg(' TIME STEP is not a numeric value','Bad value');
        return
    end
    % Vérifier que le pas de calcul est un diviseur de la proposition
    try
        vv=get(data.pas_tag,'string');
        if iscell(vv)
            vv=vv{1};
        end
        proposition=eval(vv);
    catch
        proposition=round(reg_deltaT(tobs));
        set(data.pas_tag,'string',proposition);
    end
else
% quand deltaT_tag n'est pas visible, c'est qu'on est dans le cas d'une
% estimation via methode SIVIP: il faut qu'a chaque temps de calcul,
% il y ait une donnée, et celles-ci sont supposées equidistantes

    proposition=round(reg_deltaT(tobs));
    set(data.pas_tag,'string',proposition);
    set(data.deltaT_tag,'string',proposition);
    deltaT=proposition;
end


if proposition && mod(proposition, deltaT)
    errordlg(['The value of the time step, ', ...
        num2str(deltaT), ...
        ' should divide ',...
        num2str(proposition)] ,'Bad Input','modal')
    return
end


%  Bloquer le choix si la proposition est 1
if (proposition ==1)
    set(data.deltaT_tag, 'string','1', 'enable', 'off');
else
    set(data.deltaT_tag,'enable', 'on');
end

%Calcul du nombre de temps de calcul afin de l'afficher à l'utilisateur:
% on fait un calcul tous les temps entre tobs(end) et 0
% ceux-ci compris
%NOTE: le 1ier temps de calcul est tjrs 0.
% nbtps sert uniquement pour information de l'utilisateur
nbtps = idivide(int32(tobs(end)), int32(deltaT))+1;

%Prevenir l'utilisateur de l'unité de temps des calculs
% et du nbre de temps ou il y aura un calcul
descrfile=get(data.fichier_descr_tag, 'String');
if isempty(strfind(descrfile, 'Number of computational times'))
   descrfile= [descrfile, '; Number of computational times:', ...
       num2str(nbtps)];
   set(data.fichier_descr_tag, 'String', descrfile);
end


% 4/7/2013: On ôte car ne marche pas sous Windows et le nbre de temps sera affiché par ailleurs
% if length(event)==0
%     hm=questdlg(['The computing time step is '...
% 	int2str(deltaT), ' ', data.uniteT_pourcalcul_libelle, ...
%         ' => there will be ', int2str(nbtps), ' computing steps. Are you OK?'], ...
%         'Accepte-nb-temps', 'Yes', 'No', 'Yes');
%     switch hm
%         case 'No'
%
%             return;
%     end
% end



%% recuperation de la valeur de la graine aleatoire
vv=get(data.graineAlea_tag,'string');
if iscell(vv)
    vv=vv{1};
end
try
    graineAlea=eval(vv);
catch
    graineAlea=sum(100*clock);
end



end % fin recup_interface
%======================================================
function [data, err] =recup_param(data, nmod)
% recup_param
% Recuperer du panel d'interface les parametres du modele nmod
% INPUT
%  nmod=0, quand il n'y a qu'un seul modèle possible,
% nmod=1 ou =2 dans la comparaison de modèles

%% =========================================================
% Si nmod=0, il n'y a pas de suffixe indiquant le no du modèle
% (cas où il n'y a qu'un seul modèle possible)
err=0;
if nmod>0
    strnmod = num2str(nmod);
    suffixemod= ['_mod', strnmod];
else
    strnmod='';
    suffixemod='';
end

CVs=data.CVs;

% Les parametres a estimer
nomparam = data.(['nomparam' strnmod]);
ajoutbruit=[];
for i=1:length(nomparam)
    var1=[nomparam{i}, 'max', suffixemod];
    if any(strcmpi(nomparam{i}, CVs.nomparamS))
        tag= [nomparam{i}, 'max'];
    else
        tag=var1;
    end
    
    % les tags sont de type cell quand des panels d'entrees successifs se sont empilés
    vv=get(data.([tag '_tag']),'String');
    if iscell(vv)
        vv=vv{1};
    end
    % eval(['data.',var1,'=eval(get(data.([tag ''_tag'']),''string''));']);
    data.(var1) = str2double(vv);
    var2=[nomparam{i}, 'min', suffixemod];
    if any(strcmpi(nomparam{i}, CVs.nomparamS))
        tag= [nomparam{i}, 'min'];
    else
        tag=var2;
    end
    vv=get(data.([tag '_tag']),'String');
    if iscell(vv)
        vv=vv{1};
    end
    % eval(['data.',var2,'=eval(get(data.([tag ''_tag'']),''string''));']);
    data.(var2) = str2double(vv);
    
    if data.(var1)<data.(var2)
        errordlg([var1 ' should be greater than ' var2],'Bad value');
        err=1;
        return
    end
    
    if any(strcmpi(nomparam{i}, CVs.nomparamS))
        tagbruit=[nomparam{i},'_bruit_tag'];
    else
        tagbruit=[nomparam{i},'_bruit', suffixemod, '_tag'];
    end
    vv= get(data.(tagbruit),'value');
    if iscell(vv)
        vv=vv{1};
    end
    ajoutbruit=[ajoutbruit,vv];
end
data.(['ajoutbruit' strnmod])= ajoutbruit;

% les paramètres fixes
nomparamS=data.(['nomparamS' strnmod]);
for i=1:length(nomparamS)
    if any(strcmpi(nomparamS{i}, CVs.nomparamS))
        tag=nomparamS{i};
    else
        tag=[nomparamS{i},  suffixemod];
    end
    var=[nomparamS{i},  suffixemod];
    try
        % Quand le param fixé est un CV, il apparait 2 fois dans les
        % panels,
        % d'où l'indiçage
        vv=get(data.([tag  '_tag']), 'string');
        if iscell(vv)
            vv=vv{1};
        end
        
        eval(['data.',var,'=eval(vv);']);
        
        
    catch
        errordlg(['You should set the value of ' var],'Bad value');
        err=1;
        return
    end
end
end %fin recup_param



