function [data, nomparamactifs]=sauver_mod(data, strnmod)
% sauver_mod
% Sauvegarde du modele strnmod
%% =============================================
% strnmod='' si un seul modèle, '1' ou '2' s'il y en a 2



lemodele = ['modelepop' strnmod];
s=find(strcmpi(data.Basemodeles.nom,data.(lemodele)));
% si les CV sont a estimer
data.cvinparam_in = get(data.cvinparam_tag, 'value');
nomCVs=data.CVs.nomparamS;

% Sauvegarde des parametres du modele à estimer
% dans data.<nomparam>max_1(ou _mod2)_in
% idem les min
% Sauvegarde du bruit des parametres dans <nomparam>bruit1(ou 2)_in
nomparamactifs=data.Basemodeles.nomparamP{s};

for i=1:length(nomparamactifs)
    if isempty(nomparamactifs{i})
        break; %pas de parametres actifs (simulation de données)
    end
    
    if strcmp(strnmod, '')
        cv=1;
    else
        if any(strcmpi(nomparamactifs{i}, nomCVs))
            % le parametre est un CV a estimer
            cv=1;
        else
            cv=0;
        end
    end
    if  cv==1
        tagout=[nomparamactifs{i} 'max_in'] ;
        tagin=[nomparamactifs{i} 'max_tag'];
    else
        tagout=[nomparamactifs{i} 'max' strnmod '_in'] ;
        tagin=[nomparamactifs{i} 'max_mod' strnmod '_tag'];
    end
    % Pour tenir compte des empilements des interfaces d'entree
    vv=get(data.(tagin),'string');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
    
    if cv==1
        tagout=[nomparamactifs{i} 'min_in'] ;
        tagin=[nomparamactifs{i} 'min_tag'];
    else
        tagout=[nomparamactifs{i} 'min' strnmod '_in'] ;
        tagin=[nomparamactifs{i} 'min_mod' strnmod '_tag'];
    end
    vv=get(data.(tagin),'string');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
    
    if cv==1
        tagout=[nomparamactifs{i} '_bruit_in'] ;
        tagin=[nomparamactifs{i} '_bruit_tag'];
    else
        tagout=[nomparamactifs{i} '_bruit' strnmod '_in'] ;
        tagin=[nomparamactifs{i} '_bruit_mod' strnmod '_tag'];
    end
    vv=get(data.(tagin),'value');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
end

% Sauvegarde des parametres du modele fixes dans <nomparam>(ou 2)_in
nomparamfixes=data.Basemodeles.nomparamS{s};
for i=1:length(nomparamfixes)
    
    if strcmp(strnmod, '')
        cv=1;
    else
        if any(strcmpi(nomparamfixes{i}, nomCVs))
            % le parametre est un CV fixe
            cv=1;
        else
            cv=0;
        end
    end
    
    
    
    if cv==1
        tagout=[nomparamfixes{i} '_in'];
        tagin=[nomparamfixes{i}  '_tag'];
    else
        tagout=[nomparamfixes{i} strnmod '_in'];
        tagin=[nomparamfixes{i}  '_mod' strnmod  '_tag'];
    end
    vv=get(data.(tagin),'string');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
end

%% stockage de l'indice du modèle
end % fin sauver_mod
%% ================================================================


