function Y=y_theorique(X,parametres, modelepop)
%y_theorique Calculate the theorical Y (or Nt).
%% ======================================================
data=guidata(1);

%% Rechercher les CVs
nomCVs = data.CVs.nomparamS;
k=1;
for j=1:length(nomCVs)
    i=length(nomCVs) -j+1;
    if get(data.cvinparam_tag,'value')
        % des CVs sont à estimer
        tag=[nomCVs{i} '_fixtag'];
        if isfield(data, tag)
            % le CV est fixé
            val=eval(get(data.(tag), 'string'));
        else
            val=X(end-k, end);
            k=k+1;
        end
    else
        % pas de CV à estimer
        val=data.(nomCVs{i});
    end
    eval([nomCVs{i} '=val;']);
end

n=length(X(end,:)); % nb de particules
nbRepet=size(parametres,1); % nb de repetitions
masseprelevee=parametres(:,1); % m masse prelevee
factDilInitial=parametres(:,2); % a facteur de dilution initial
mctea=masseprelevee.*(1-factDilInitial)./factDilInitial; % m*(1-a)/a
nbDilutions=parametres(:,3); % n nombre de dilutions en tube
factDilTotal=parametres(:,4); % F facteur de dilution total
cteF=(1-factDilTotal)./(10.*factDilTotal); % (1-F)/10F
Ve=parametres(:,5); % v volume ensemence
NbactPetri=zeros(nbRepet,n);
if (nbDilutions>0)
    for rep=1:nbRepet
        % on a X bacteries par gramme
        if regexp(modelepop, 'Ln') ==1
            % la valeur du modele est un log népérien
            NbactPetri(rep,:)=exp(X(end,:));
        else
            if model_log10(modelepop)==1
                % la valeur du modele est un log10
                NbactPetri(rep,:)=10.^X(end,:);
            else
                
                % le modele est calculé sous forme exponentielle
                NbactPetri(rep,:)=X(end,:);
            end
        end
        
        %% Etape 1 : Prelevement pour suspension mere
        % on prend m grammes; on les "dilue" avec un facteur a
        massev=normrnd(masseprelevee(rep),masseprelevee(rep).*CVpesee,1,n); % = m
        massetot=normrnd(mctea(rep),mctea(rep).*CVpesee,1,n); % = M = m*(1-a)/a
        massetot=massetot+massev; % = M+m = m/a
        % nb de bacteries transferees dans m grammes N1 = m * X
        NbactPetri(rep,:)=poissrnd(NbactPetri(rep,:).*massev);
        % dans le volume m+M on a toujours N1 bacteries
        clear massev
        %% Etape 2 : Dilutions en tube et en cascade
        % on dilue n fois pour un facteur de dilution total F
        % on a un volume pipete de equivalent a 10F/(1-F) = 1/cteF
        Vp=normrnd(1./cteF(rep),CVpipetee./cteF(rep),1,n);
        % pour un volume de diluant de 10ml
        Vdil=normrnd(10,10.*CVdiluant,1,n);
        % nb de bacteries transferees N2 = N1 * Vp/(m+M) = N1.a.10F/m(1-F)
        NbactPetri(rep,:)=poissrnd(NbactPetri(rep,:).*Vp./massetot);
        % petit ajustement
        NbactPetri(rep,NbactPetri(rep,:)==0)=1;
        %% Etape 3 : Volume preleve pour ensemencement boites Petri
        % on pipete Ve ml dans le volume Vp+Vdil
        Vev=normrnd(Ve(rep),Ve(rep).*CVpipetee,1,n);
        % nb de bacteries transferees N3 = N2 * Ve/(Vp+Vdil) = N2.Ve.(1-F)/10
        NbactPetri(rep,:)=poissrnd(NbactPetri(rep,:).*Vev./(Vp+Vdil));
        % petit ajustement
        NbactPetri(rep,NbactPetri(rep,:)==0)=1;
        clear Vp Vdil
        clear massetot Vev
        %% Etape 4 : Comptage
        % moyenne et ecart-type pour la log-normale :
        m2=NbactPetri(rep,:).^2;
        sigmaCompt=NbactPetri(rep,:)./50;
        v=sigmaCompt.^2;
        mu = log((m2)./sqrt(v+m2));
        sigma = sqrt(log(v./(m2)+1));
        % nb de bacteries comptees
        NbactPetri(rep,:)=round(lognrnd(mu,sigma));
        clear mu sigma m2 sigmaCompt v
        % petit ajustement
        NbactPetri(rep,isnan(NbactPetri(rep,:)))=1;
        NbactPetri(rep,NbactPetri(rep,:)==0)=1;
    end
else
    for rep=1:nbRepet
        % on a X bacteries par gramme
        if regexp(modelepop, 'Ln') ==1
            % la valeur du modele est un log népérien
            NbactPetri(rep,:)=exp(X(end,:));
        else
            if model_log10(modelepop)==1
                %le modele est calculé sous forme log10
                NbactPetri(rep,:)=10.^X(end,:);
            else
                % le modele est calculé sous forme exponentielle
                NbactPetri(rep,:)=X(end,:);
            end
        end
        
        
        %% Etape 1 : Prelevement pour suspension mere
        % on prend m grammes qu'on "dilue" avec un facteur a
        massev=normrnd(masseprelevee(rep),masseprelevee(rep).*CVpesee,1,n); % = m
        massetot=normrnd(mctea(rep),mctea(rep).*CVpesee,1,n); % = M = m*(1-a)/a
        massetot=massetot+massev; % = M+m = m/a
        % nb de bacteries transferees dans m grammes N1 = m * X
        NbactPetri(rep,:)=poissrnd(NbactPetri(rep,:).*massev);
        % dans le volume m+M on a toujours N1 bacteries
        clear massev
        %% Pas de dilution -> on saute l'etape 2
        %% Etape 3 : Volume preleve pour ensemencement boites Petri
        % on pipete Ve ml dans le volume (m+M)
        Vev=normrnd(Ve(rep),Ve(rep).*CVpipetee,1,n);
        % nb de bacteries transferees N3 = N1 * Ve/(m+M)
        NbactPetri(rep,:)=poissrnd(NbactPetri(rep,:).*Vev./massetot);
        % petit ajustement
        NbactPetri(rep,NbactPetri(rep,:)==0)=1;
        clear massetot Vev
        %% Etape 4 : Comptage
        m2=NbactPetri(rep,:).^2;
        sigmaCompt=NbactPetri(rep,:)./50;
        v=sigmaCompt.^2;
        mu = log((m2)./sqrt(v+m2));
        sigma = sqrt(log(v./(m2)+1));
        NbactPetri(rep,:)=round(lognrnd(mu,sigma));
        clear mu sigma m2 sigmaCompt v
        NbactPetri(rep,isnan(NbactPetri(rep,:)))=1;
        NbactPetri(rep,NbactPetri(rep,:)==0)=1;
    end
end
Y=NbactPetri;


