/*=================================================================
 * Modele Rosso en C et double precision, version log néperien
 * Pour la
 * Simulation de strategie optimale, version C
 * Voir BaranyiRoberts pour les E/S
 * COMPILATION sous matlab par: 
 * mex  /home/abouvier/MONFILTREX/v2013-1.0/SRC/SIMULATION_STRATEGIE/C/CLnRosso.c
 *============================================================*/
#include <math.h>
#include "mex.h"
double exp( double arg );


  /* ============================================================== */      

void  CLnRossoDP(double *param,  double * temps, 
        double *valmin, double *valmax, double *rep,
         int ntemps, int N, int Ncur)
{

double mumax=(double) param[Ncur];
double lambda=(double) param[N+Ncur];
double lnN0= (double) param[2*N+Ncur];
double lnNmax=(double) param[3*N+Ncur];
 double e1,A, den, ti;
 int i, ind;

 for ( i=0; i< ntemps; i++) {
   ti=temps[i];
   if (ti <= lambda) {
     rep[N*i+Ncur]=lnN0;

   } else {
   e1= -mumax *  (ti-lambda);
   if (e1 < -100) {
     e1= -100;
   }
   A= exp(lnNmax -lnN0)-1;
   den=A*exp(e1);
  ind=N*i+Ncur;
  rep[ind]=lnNmax - log(1+den);
 /* Ramener dans les bornes les réponses invalides */
 /* VOIR
   if (rep[ind] < (*valmin)) {
      rep[ind]=(double)(*valmin);
    }
    if (rep[ind] > (*valmax)) {
      rep[ind]=(double)(*valmax);
    }
*FIN VOIR */   
   }

     
 } /* fin i */


}
/* ============================================================== */
void CLnRosso(double *param,  double *temps,
 double *valmin, double *valmax,
 double *rep,
   int ntemps, int N)
{

    /* boucle sur l'appel à LnRossoDP */
    int u;
    for (u=0; u<N; u++) {
        CLnRossoDP( param, temps,valmin, valmax,  rep, ntemps, N, u);
    }

}

/* ================================================== */
/* The gateway function:
INPUT
nlhs: le nombre de sorties (la fonction a pls sorties quand
 l'utilisateur affecte une structure à pls composants
 à son appel a CLnRosso)
plhs: les sorties
nrhs: le nombre d'arguments d'entrée
prhs: les arguments d'entrée
 */
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double *rep, *param, *temps, *valmin, *valmax;
  int N, ntemps;

  

/* The first input argument param is Nx4 */
  N = (int) mxGetM(prhs[0]);
 
 /* Check: param must have 4 columns
if(mxGetN(prhs[0])!=4) {
    mexErrMsgIdAndTxt("LnRosso:notRowVector",
                      "Input param must have 4 columns.");
}
*/
  
/* create a pointer to the  input   */
param = mxGetPr(prhs[0]);

/* Second input argument: times is 1 x ntemps */
ntemps = (int) mxGetN(prhs[1]);

temps=mxGetPr(prhs[1]);


/* Third input argument:valmin */
    valmin=(double *)mxGetPr(prhs[2]);
/* Fourth input argument:valmax */
    valmax=(double *)mxGetPr(prhs[3]);

/* 5th input argument: result matrix */
    rep = (double *)mxGetPr(prhs[4]);


/* create the output matrix 
 plhs[0] = mxCreateDoubleMatrix((mwSize)N,(mwSize)ntemps,mxREAL);
rep = mxGetPr(plhs[0]);
*/
/* call the computational routine */
 CLnRosso( param, temps,valmin, valmax, rep,(int)ntemps, (int)N);

} 
