function dessin1_simul_tornsey(obj, evt)
%dessin1_simul_tornsey Tracé graphique du 1ier plot de D-optimal
% dans une fenêtre graphique Matlab ou en cas de restauration
% INPUT
% obj: ignore si le sp est appele via un clic sur le graphe,
% sinon, c'est que le sp est appele par restore-tornsey et
% obj est le uipanel ou il faut dessiner le graphe
% evt: ignore  si le sp est appele via un clic sur le graphe,
% sinon, c'est que le sp est appele par restore-tornsey et
% evt est la structure data
%% ======================================================
if ~isstruct(evt)
    % appele via un clic sur le graphe
    donnees = evalin('base', 'filtrexplot');
    hfig=figure('Name', 'SIMULATION OF AN OPTIMAL SAMPLING BY METHOD TORNSEY');
    hp2=subplot(1,1,1, 'parent',hfig);
else
    hfig=obj;
    donnees=evt;
    
    
    hp11=uipanel('parent',hfig,...
        'BackgroundColor',[1 1 1],...
		 'BorderType', 'none', ...
        'Position',[0 0.12 1 0.88]);
    hp2=subplot(2,1,1, 'parent',hp11);
end
titredeb = [ ' Model: ', donnees.modelepop '. ', ...
    ' D-optimal design method'];

subplot(2,1,1); % se positionner sur le panel du haut
plot(1:donnees.iter, donnees.evoldet)
title([' {\bf{Log determinant vs iterations}} - ', titredeb]);
xlabel('iterations')
ylabel('log(det)')
set(gca,'buttondownfcn',@dessin1_simul_tornsey);

subplot(2, 1,2); % se positionner sur le panel du bas
plot(donnees.reseau, donnees.proba)
xlim([min(donnees.reseau) max(donnees.reseau)])
title([ ' {\bf{D-optimal measure}} - ', titredeb])
xlabel('times')
set(gca,'buttondownfcn',@dessin1_simul_tornsey);



end % fin dessin1_simul_tornsey




