function dessin_simul_sobol(obj, evt, numfig)
%dessin_simul_sobol Tracé graphique dans une fenêtre graphique Matlab du dessin
%% ======================================================
donnees = evalin('base', 'filtrexplot');
hfig=figure('Name', 'SIMULATION OF AN OPTIMAL SAMPLING BY METHOD SOBOL-SALTELLI');
hp2=subplot(1,1,1, 'parent',hfig);
nf=size(donnees.IST,2);
for p=1:nf
    y=donnees.IST(:,p);
    optima=donnees.optimaP(:,p);
    couleur=donnees. couleur(p);
    plot(hp2, donnees.temps, y,  couleur{1})
    xlim([min(donnees.temps) max(donnees.temps)])
    hold on
    plot(hp2, optima ,y(optima+1) , ['s' couleur{1}]);
    
end
grid on
ylab='TSI (%)';
xlab=[ 'OPTIMA:  ' num2str(donnees.optima) ];
annotGraphe(donnees.optima, donnees.nomparam, donnees.titregraphe, ...
	    xlab, ylab, hp2);

end % fin dessin_simul_sobol
