function  [data,  indice_panel, erreur]=go_sivip(data, obj,evnt)
%SIVIP  Pilote les calculs
% INPUT
% La propriété userdata de obj est 1 s'il faut arrêter les calculs
%  0 s'il faut les lancer

%% ======================================================
erreur=0;
indice_panel=0;
data.indice_panel=indice_panel;

% On enleve la barre de progression si elle existe
try
    delete(data.hPb);
end

% Verifier que les entrees sont correctes
if verif_input(obj)==1
    erreur=1;
    return
end




% suppression des eventuels objets graphiques fils du panel d'affichage
delete(get(data.hpanel_work,'children'))

%% Recupération des entrées
if ~isfield(data, 'modelepop') || isempty(data.modelepop)
    errordlg('Please, select the dynamics equation model', 'NO MODELE');
    set(obj,'interruptible','on','userdata',0,'string','GO')
    Idle(1)
    erreur=1;
    return
end

%% recuperation des valeurs  des parametres du modele
try
    [data.binf, data.bsup, nf, nomparamP, nomparamS, nomorP, nomorS,  erreur] =recup_param_strat(data);
    if erreur>0
        set(obj,'interruptible','on','userdata',0,'string','GO')
        Idle(1)
        errordlg(['Error number ' num2str(erreur), ' while getting model parameters ']);
    erreur=1;
    return
    end
catch
    set(obj,'interruptible','on','userdata',0,'string','GO')
    Idle(1)
    errordlg('Error while getting model parameters ');
    erreur=1;
    return
end
data.nomparam=nomparamP;
data.nomparamS=nomparamS;

%% Recup des autres entrees
try
    [data, tobs, deltaT, bruitetat,Fnoyau,Fpert,iclevel, ...
        ~, nbparticules,...
        graineAlea] = recup_interface( data, evnt, 1);

    % tracehistogramme est ignoré
    % Indiquer l'unite de pas et pas de calcul si pas déjà fait
    ch=get(data.fichier_descr_tag, 'String');
    if isempty(strfind(ch, 'Time step'))
    pas=get(data.deltaT_tag(1), 'String');
        ch=[ch '; Time step: ' pas ' ' data.uniteT_pourcalcul_libelle];
        set(data.fichier_descr_tag, 'String', ch);
    end
    
catch
    % des entrées manquent ou sont mauvaises
    %    errordlg('Input are missing or incomplete');
    set(obj,'interruptible','on','userdata',0,'string','GO')
    Idle(1)
    erreur=1;
    return
end



%% Recup des entrees spécifiques a sivip
sivipargu=recup_sivipargu(data);


%% preparation de champ text pour la numerotation des panels
uicontrol('parent',data.hpanel_work,...
    'units','normalized',...
    'foregroundcolor','k',...
    'backgroundcolor',[1 1 1],...
    'position',[0 0  1 .02],...
    'tag','com_tab_tag',...
    'style','text');
%% modification de la couleur d'arriere-plan du panel d'affichage
set(data.hpanel_work,'backgroundcolor',[1 1 1])

data.vobs=0:deltaT:tobs(end); %temps de calcul
data.vobs_or=convert_obs(data.vobs, data); % convert in the genuine time unit

%% barre de progression
ssize=get(0,'screensize');
jPb = javax.swing.JProgressBar;
jPb.setIndeterminate(false);
hPb= javacomponent(jPb,[2*ssize(3)/4 4*ssize(4)/9 ssize(3)/3 ssize(4)/9],gcf);
data.hPb=hPb;
%  Maj et affichage barre de progression
set(data.hPb,'Value',(1/length(data.vobs))*100);
set(data.hPb,'Visible', 1);
refresh
drawnow

%% mise a jour de la structure data

handles=guihandles;
ndata=catstruct(data,handles);
guidata(gcf,ndata);

%% Preparation des arguments nécessaires au calcul des SIVIP
sivipargu.np=length(data.nomparam); % nbre de parametres du modele
% Calculer le nombre de monomes  par appel au C
sivipargu.nmono = calcTaille(sivipargu.np, sivipargu.degre);
% Verifier que le nombre de composantes demandes <= le nombre de monomes
if sivipargu.hmax> sivipargu.nmono
    errordlg(['The number of components, ', ...
num2str(sivipargu.hmax), ...
' should be less or equal to the number of monomes, ', ...
num2str(sivipargu.nmono), ...
'.'], ...
'Bad Input','modal');
    erreur=1;
    return
end

set(data.hPb,'Value',(2/length(data.vobs))*100);

%% Creer le tableau indic  par appel au C
indic=zeros(sivipargu.nmono, sivipargu.np);
sivipargu.indic = generIndic(sivipargu.nmono, sivipargu.np, sivipargu.degre, sivipargu.polytype, indic);

set(data.hPb,'Value',(3/length(data.vobs))*100);

%% Autres allocations de travail
sivipargu.Poly= zeros(nbparticules, sivipargu.nmono);
sivipargu.E= zeros(nbparticules, sivipargu.nmono);  sivipargu.F= zeros(nbparticules,1);
sivipargu.TT= zeros(nbparticules, sivipargu.hmax); sivipargu.WW= zeros(sivipargu.nmono, sivipargu.hmax);
sivipargu.uh= zeros(nbparticules,1); sivipargu.PP= zeros(sivipargu.nmono, sivipargu.hmax);
sivipargu.CC= zeros(sivipargu.hmax,1); sivipargu.wh= zeros(sivipargu.nmono,1);
sivipargu.sivip= zeros(sivipargu.nmono,1); sivipargu.tsivip= zeros(sivipargu.np,2);
sivipargu.vip= zeros(sivipargu.nmono,1); sivipargu.coryt= zeros(nbparticules,1);
sivipargu.redonk= zeros(sivipargu.hmax,1);

%% stockage de programme de calcul du modèle
% Oter les eventuels  blancs dans le nom du modele
lemodele = strrep(data.modelepop,' ', '');
% Oter les eventuels  tirets dans le nom du modele
lemodele = strrep(lemodele,'-', '');
modelepop= eval(['@' lemodele]);


nomparam=data.nomparam;
yobs=data.yobs;
paramobs=data.paramobs;
nmoda=NaN; % pour stocker eventuellement les mod des parametres



%% random seed
try
    RandStream.setGlobalStream(RandStream('mt19937ar','seed',graineAlea)); % version 2012a matlab
catch
    try
        RandStream.setDefaultStream(RandStream('mt19937ar','seed',graineAlea)); % version 2008b-2011b matlab
    catch
        rand(graineAlea);% versions anterieures
    end
end

%% Preparation des argu de filtre
%
%% le niveau des intervalles de confiance
switch iclevel
    case 1
        % 90%
        level=90;
    case 2
        level=95;
    case 3
        level=99;
end
icbinf=(1-level/100)/2; 
icbsup= 1-icbinf;

%% Pour le calcul des IST, il faudra calculer la reponse en tous les temps
sivipargu.Yrep=zeros(nbparticules, length(data.vobs));


%% estimation=>filtrage
Moyenne={};
while 1
    try
  
        [Moyenne,ET,ICInf,ICSup, nmoda,   indice_panel]=filtre_particulaire_sivip(modelepop,...
            @y_theorique,paramobs,yobs,nbparticules,tobs,...
										  data.vobs, data.vobs_or, ...
                        data.ajoutbruit,...
            bruitetat,Fnoyau,Fpert, icbinf, icbsup, ...
            indice_panel,  ...
            data.nomparam,data.nomparamS, data, lemodele, ...
            sivipargu, evnt);
        
       
        % On regarde si il y a un pbe dans le calcul du modele
	if isempty(Moyenne)
            break
        end;

        
        % On regarde si l'utilisateur a demandé d'interrompre filtre
        if  ~iscell(get(obj,'userdata'))
            if get(obj,'userdata')==0
                interrompu(obj);
                return
            end;
        end
        
        nbparammodel=size(Moyenne,1)-1;
        paramfin=[Moyenne(1:nbparammodel,end);0];
        break; % sortie du while
        
        
        
    catch err
        %DEBUG          err.identifier
        %DEBUG             err.message
        if ~ishandle(obj)% interruption via quitter
            return
        end
        if ~iscell(get(obj,'userdata'))
            if get(obj,'userdata')==0
                interrompu(obj);
                return
            end
        end;
        
        % changement de l'image de bouton en cas de debordement et
        % modification de la valeur de la graine
        set(obj,'backgroundcolor','r')
        drawnow
        
        graineAlea=graineAlea+1;
        try
            RandStream.setGlobalStream(RandStream('mt19937ar','seed',graineAlea));% version 2012a matlab
        catch
            try
                RandStream.setDefaultStream(RandStream('mt19937ar','seed',graineAlea));% version 2008b-2011b matlab
            catch
                rand('state', graineAlea);% versions anterieures
            end
        end
    end
end % fin while




%% affichage des resultats


% On enleve la barre de progression si elle existe
try
    delete(data.hPb);
end


data=guidata(gcf);

%% Continuer si on a reussit l'estimation
if ~isempty(Moyenne)
    %% Les optima
    % Rajouter le dernier point
    if data.optima(end)~= data.vobs_or(end)
        data.optima(end+1)=data.vobs_or(end);
    end
    
    for itag=1:indice_panel
        tag=['panel' num2str(itag) '_tag'];
        set(data.(tag), 'Visible', 'on');
        %Rendre visible les graphes des IST calculés au dernier coup
    end % fin itag
    
    
    
    %% Le panel des optima
    handles=guidata(1);
    data=catstruct(handles,data);
    data.soustitre=[' Model: ', data.modelepop, ...
      '. SIVIP method', ...
        '; Number of particles: ', num2str(nbparticules), ...
        '; Time unit: ', data.uniteT_libelle];
    
    % Garder le no de panel pour s'y positionner en fin d'execution
    indice_panel_tps=indice_panel;
    [indice_panel, data]=ecrire_optima(data,  indice_panel,  data.soustitre, data.hpanel_work);
    
    
    %% Le graphe des evolutions des parametres
        
    indice_panel= indice_panel+1;
    tag=['panel' num2str(indice_panel) '_tag'];
    data=plot_evolution_para(tag, data, ...
        nbparammodel, nomparam, ...
        data.vobs_or, Moyenne, ICInf,  ICSup, ...
        nbparticules);
       
    
    
    %% Sauvegarder les valeurs estimées des paramètres   et de leurs mod
    data.paramfin = paramfin;
    data.nmoda= nmoda;
    
end %fin  length(Moyenne)>0

%% La numérotation des panels
data=put_indices_panels(data, indice_panel, data.hpanel_work);


set(obj,'interruptible','on','userdata',0,'backgroundcolor','r','string','GO')
drawnow
Idle(1)

 handles=guihandles;
 ndata=catstruct(data,handles);
 guidata(1,ndata)

%% Se positionner sur le panel des optima
% si on passe des tests, evnt is non null
 if ~isempty(data.optima) && isempty(evnt)
     nbp=indice_panel - indice_panel_tps -1;
     for i=1:nbp
         retrancher_tab();
     end
 end


end % fin go_sivip
%% ======================================================


function sivipargu = recup_sivipargu(data)
% recup_sivipargu: Récupérer les entrées spécifiques à la méthode SIVIP
%% =========================================================
% degre du polynome
choix = get(data.degre_tag,'String');
str=choix(get(data.degre_tag,'value'));
sivipargu.degre= str2num(str);

% type  du polynome
sivipargu.polytype= get(data.polytype_tag,'value');


% diffmax: intervalle entre 2 temps optimaux
% hmax: Le nombre de composantes SIVIP
% seuil
Simul=data.Simul;

for i=3:length(Simul.nomparamD{3})
    lavar= Simul.nomparamD{3}{i};
    tag=[lavar '_tag'];
    sivipargu.(lavar) = str2num(get(data.(tag),'String'));
end
% le seuil est dans la variable seuilsivip depuis le 28/8/2013
% on la renomme
try
    sivipargu.seuil = sivipargu.seuilsivip;
end
end % fin recup_sivipargu
%% ======================================================
function reinit_tout(obj,evnt)
%reinit_tout Réinitialisation aux valeurs par défaut toutes les entrées
reinit_param_sivip(obj,evnt);
reinit_mod_sim(obj,evnt);
reinit_modobs(obj,evnt);
reinit_filtre(obj,evnt);
end % fin reinit_tout
%% ================================================================
%% ================================================================

function interrompu(obj)
%interrompu maj des boutons stop apres interromption ou en fin
data=guidata(gcf);
try
    delete(data.hPb);
end
set(obj,'interruptible','on','userdata',0,'backgroundcolor','r','string','GO')
drawnow
Idle(1)
'EXECUTION STOPPED ON USER REQUEST'
end
