

function[data]= init_estimation_sivip(data, bgcolor)
%init_estimation Ajout des structures Basemodeles, CVs et Filtre dans data

%% ======================================================
CVs=init_CVs();
data.Basemodeles=init_Basemodeles();
data.CVs=init_CVs();
Filtre=init_Filtre();
data.Filtre=init_Filtre();
% variables de modele
data.nomparam={};
data.fctprior={};
data.ajoutbruit=[];
% fichier d'observation
data.releveobs={};


% pas de temps
data.deltaT='-';
% sauvegarde de Temp pour calculer Tempmax
data.Temp=8;
data.tracehistogramme=0;



%Pour la mise en cadre des cadres
hautcase = 1/length(CVs.nomparamS);  %hauteur d'une case

% construction de parametre de modele d'observation

for i=1:length(CVs.nomparamS)
    var=CVs.nomparamS{i};
    data.(var)=eval(CVs.valparamS{i});
    nomCV=traduc_nom(CVs.nomparamS{i});
    uicontrol('parent', data.groupebutton21s_tag,...
        'units','normalized',...
        'fontsize',9,...
        'foregroundcolor',[.3 .1 .5],...
        'backgroundcolor',bgcolor,...
        'position',[0 1-hautcase*i 1 hautcase],...
        'style','text',...
        'string', {'',nomCV});
    tag=[var,'_tag'];
    hd=uicontrol('parent',data.groupebutton22s_tag,...
        'units','normalized',...
        'position',[0 1-hautcase*i 1 hautcase],...
        'backgroundcolor','w',...
        'tag',tag,...
        'userdata',{CVs.DF{i},nomCV}, ...
        'interruptible','off',...
        'callback',@control_saisie,...
        'style','edit');
    set(hd,'string',eval(['data.',var]))
end
%% On ne donne pas le choix du pas de temps: ce sera celui des donnees
% Pour stocker le pas de temps des calcul sans l'afficher
uicontrol('parent', data.groupebutton22s_tag,...
    'tag','deltaT_tag',...
    'Visible', 'off');
% Pour stocker l'unite  de temps  sans l'afficher
uicontrol('parent',data.groupebutton22s_tag,...
    'tag','uniteT_tag',...
		 'Visible', 'off');
uicontrol('parent',data.groupebutton22s_tag,...
    'tag','proposition_tag', ...
    'Visible', 'off');
uicontrol('parent',data.groupebutton22s_tag,...
    'tag','saisie_tps_tag', ...
    'Visible', 'off');
uicontrol('parent',data.groupebutton22s_tag,...
    'tag','pas_tag', ...
    'Visible', 'off');

% construction de parametres de filtre
% Bouton help pour les windows
help_icon = imread('SRC/IMG/help.jpg', 'jpg');
hautcase = 1/length(Filtre.nomparamS); % hauteur d'une case
% ordre de presentation
ipres=Filtre.ipres;

for i=1:length(Filtre.nomparamS)
    ii=find(ipres==i);
    var=Filtre.nomparamS{ii};
    if i==1
        data.(var)=eval(Filtre.valparamS{ii});
    else
        data.(var)=Filtre.valparamS{ii};
    end
    
    pos=[0 (1-hautcase*i) 0.83 hautcase];
    % remonter le dernier
    if i==length(Filtre.nomparamS)
       pos(2)=pos(2)+0.02;
    end
    
    uicontrol('parent',data.groupebutton23s_tag,...
        'units','normalized',...
        'fontsize',8,...
        'foregroundcolor',[.4 0 .2],...
        'backgroundcolor',bgcolor,...
        'position',pos,...
        'style','text',...
        'Visible', 'on', ...
        'string',Filtre.chaine{ii});
    
    %'HorizontalAlignment', 'right', ...
    
    % Bouton d'aide pour les fenetres
    if strfind(Filtre.chaine{ii}{2}, 'KERNEL WINDOW')
        % rajouter l'icone d'aide
        uicontrol('parent',data.groupebutton23s_tag,...
            'units', 'normalized', ...
            'style', 'pushbutton', ...
            'position',[0.86 0.5+0.02 0.06 0.1],...
            'enable', 'inactive', ...
            'backgroundcolor', 'w', ...
            'cdata', help_icon, ...
            'ButtonDownFcn', @help_filterparameters);
        
    end
    
    tag=[var,'_tag'];
    switch Filtre.chaine{ii}{2}
        case 'SEED'
            % valeur alpha-numerique a controler
            uicontrol('parent',data.groupebutton24s_tag,...
                'units','normalized',...
                'position',[0 1-hautcase*i 1 hautcase],...
                'backgroundcolor','w',...
                'tag',tag,...
                'callback',@control_saisie_an,...
                'interruptible','off',...
		      'userdata',{Filtre.DF{ii}, Filtre.chaine{ii}{2}}, ...
                'style','edit', ...
                'String', eval(['data.',var]));
        case 'PARTICLE CI LEVEL'
            % type listbox
           uicontrol('parent',data.groupebutton24s_tag,...
                'units','normalized',...
                'position',[0 1-hautcase*i 1 hautcase],...
                'backgroundcolor','w',...
                'tag', tag, ...
                'Min', 1,  'Max', 1,...
                'String', {...
                '                    90%', ...
                '                    95% ', ...
                '                    99% '},...
                'Value', 2 , ...
			 'Visible', 'on', ...
                'style','listbox');
        otherwise
           uicontrol('parent',data.groupebutton24s_tag,...
                'units','normalized',...
                'position',[0 1-hautcase*i 1 hautcase],...
                'backgroundcolor','w',...
                'tag',tag,...
                'callback',@control_saisie,...
                'interruptible','off',...
	     'userdata',{Filtre.DF{ii}, Filtre.chaine{ii}{2}},...
                'style','edit', ...
                'String', eval(['data.',var]));
    end
    
    
        
end
return
end % fonction init_estimation_sivip
%% =========================================================
