function [valmin, valmax]=init_modeles_repvalides(modelepop, nomparam, binf, bsup)
  %init_modeles_repvalides: Set valid bounds to the model output
%% ======================================================

% For the task Simulation of an optimal sequential sampling,
% the valid bounds of the response of some models
% are the valid bounds of parameters.

iN0=find(strcmpi(nomparam, 'N0'));
ilnN0=find(strcmpi(nomparam, 'lnN0'));
iNmax=find(strcmpi(nomparam, 'Nmax'));
ilnNmax=find(strcmpi(nomparam, 'lnNmax'));
iN0W=find(strcmpi(nomparam, 'N0W'));

switch modelepop
    case {'BaranyiRoberts',  'Rosso'}
        valmin = binf(iN0); %min de N0
        valmax = bsup(iNmax); % max de Nmax
    case {'Weibull'}
        valmin = 1;
        valmax= bsup(iN0); % max de NOW
    case {'LnBaranyiRoberts',  'LnRosso'}
        valmin = log(binf(ilnN0)); %min de N0
        valmax = log(bsup(ilnNmax)); % max de Nmax
    otherwise
	% ce qu'on a calculé, c'est log10(Nt):
        % Nt doit etre >0 => log10(Nt) >1
        valmin = 1;
        valmax =1.0e+37;
end
end % end init_modeles_repvalides
