
function opensimulated(obj,event)
%opensimulated Lecture du fichier d'observations simulées

%% ======================================================
data=guidata(1);
set(data.fichier_no_tag, 'Visible', 'off');
set(data.fichier_type_tag, 'Visible', 'off');
[fileName, pathName] = uigetfile( ...
     [getenv('DATADIR')  '/SIMULATED_DATA/*.*'],  ...
    'Select a simulated data filename');
if isequal(fileName,0) || isequal(pathName,0)
    return;
end
chemin=fullfile(pathName, fileName);
drawnow

try
    [releveobs, txt]=xlsread(chemin);
    % txt est le label des colonnes qui permet de savoir l'unité de temps

catch
    fid=fopen(chemin);
    % lecture de tout le fichier
    txt= textscan(fid, '%s', 'Delimiter', '\n');
    lu=txt{1};
    txt{1}=txt{1}{1}; % la 1ier ligne sont les labels de colonnes
    [nobs ign]= size(lu);%nobs = nbre de lignes  du fichier
    % allocation du tableau des valeurs: 
    % nbre d'obs = nbre de lignes  du fichier - la ligne de labels
    % nbre de variables=9
    nvar=9;
    releveobs= zeros(nobs-1, nvar);
    
    for i=2:nobs
        b=regexp(lu{i}, ',','split'); %valeurs séparées par des virgules
        for j=1:nvar
            releveobs(i-1, j)= str2num(b{1,j});
        end
    end      
        

    fclose(fid);
%    releveobs=csvread(chemin);
end
%% determiner l'unite de temps d'après le label de la 1iere colonne
valeur=timelabel(txt{1});

 set(data.uniteT_tag, 'Value', valeur);
data = initdata(data, releveobs,  fileName);
set(data.fichier_chemin_tag,'visible', 'on', ...
    'string', ['SIMULATED DATA FILENAME : ', fileName]);
end % fin opensimulated
