function [binf, bsup, nf, nomparamP, nomparamS, nomorP, nomorS, err] =recup_param_strat(data)
% recup_param_strat
% Recuperer les plages des parametres du panel d'interface
% OUTPUT
% nomparamP, nomparamS: ceux déduits de l'interface-utilisateur: pas dans
% le meme ordre qu'origine s'il y a des parametres fixes
% nomorP, nomorS: ceux décrits dans la base des modeles

%% =========================================================
%%Init des sorties
binf={}; bsup={};
err=0;
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)
data=guidata(1);


s=find(strcmpi(data.Basemodeles.nom,data.modelepop));
nomparamP=data.Basemodeles.nomparamP{s}; %actifs
nomparamS=data.Basemodeles.nomparamS{s} ; %fixes
lenP=length(nomparamP);
lenS = length(nomparamS);

nf=lenP+lenS;
bor=init_Basemodeles();
nomorP=bor.nomparamP{s};
nomorS=bor.nomparamS{s};
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret
DF= bor.DF.(lemodele); % bornes valides des parametres

binf= zeros(1, nf);
bsup=zeros(1, nf);


for i=1:lenP
    item_min_tag=eval(['data.', nomparamP{i} , 'min_tag']);
    item_min_tag=item_min_tag(1);
    bi=get(item_min_tag, 'string');
    item_max_tag=eval(['data.', nomparamP{i} , 'max_tag']);
    item_max_tag = item_max_tag(1);
    bs=get(item_max_tag, 'string');
    indice = find(strcmpi(nomorP, nomparamP{i}));
    binf(indice) = str2double(bi);
    bsup(indice) = str2double(bs);
   
end



for i=1:lenS
    indice = find(strcmpi(nomorP, nomparamS{i}));
    if isempty(indice)
        indice = find(strcmpi(nomorS, nomparamS{i})) + length(nomorP);
    end
    item_tag=eval(['data.', nomparamS{i} , '_tag']);
    item_tag=item_tag(1);
    bi=get(item_tag, 'string');
    binf(indice) = str2double(bi);
    bsup(indice) = binf(indice);
   
end


end %fin recup_param_strat



