
function reinit_mod_sim(obj,event)
% reinit_mod_sim
% Réinitialisation aux valeurs par défaut les plages de variation des parametres du modele

%% ======================================================
global input_error;

handles=guihandles;
data=guidata(1);
data=catstruct(data,handles);
Basemodeles=init_Basemodeles();

if ~isfield(data, 'modelepop')
    return
end

if isempty(data.modelepop)
    return
end
s=find(strcmpi(Basemodeles.nom,data.modelepop));
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret


%  pour tornsey: tous les parametres doivent etre fixes
if get(data.methode_tag, 'Value')==2
    nomparamS=[Basemodeles.nomparamP{s} Basemodeles.nomparamS{s}];
    nomparamP={};
else
    nomparamP= Basemodeles.nomparamP{s}; % Les paramètres à estimer
    nomparamS=Basemodeles.nomparamS{s};
end

for i=1:length(nomparamP)
    var=[nomparamP{i},'min'];
    tag=[var,'_tag'];
    if isfield(data, (tag))
        if isempty(strfind(nomparamP{i},'CV'))
            % le parametre est pas un CV
            init=Basemodeles.init.(lemodele);
        else
            init=Basemodeles.init;
        end
        
        valeur=init.(nomparamP{i}){1};
        if isfield(data, 'tobs')  && ...
                ~isempty(data.tobs) && ...
                isfield(Basemodeles.type, nomparamP{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparamP{i}),...
                uniteT, ...
                Basemodeles.type.(nomparamP{i}));
            valeur=str2double(valeur)*fact;
        end
        
        
        set(data.(tag),'string',num2str(valeur),'backgroundcolor','w');
        % oter l'indication d'eventuelles erreurs précédentes sur le champ
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        
        % la val max
        var=[nomparamP{i},'max'];
        tag=[var,'_tag'];
        valeur=init.(nomparamP{i}){2};
        if isfield(data, 'tobs') && ...
                ~isempty(data.tobs) && ...
                 isfield(Basemodeles.type, nomparamP{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            valeur=str2double(valeur)*fact;
        end
        set(data.(tag),'string',num2str(valeur),'backgroundcolor','w');
        
        
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        
    end
end



for j=1:length(nomparamS)
    if ~isempty(nomparamS{j})
        if isempty(strfind(nomparamS{j},'CV'))
            % le parametre est pas un CV
            valparamS = Basemodeles.valparamS.(lemodele);
        else
            valparamS =Basemodeles.valparamS;
        end
        
        tag=[nomparamS{j},'_tag'];
        valeur=Basemodeles.valparamS.(lemodele).(nomparamS{j});
        if isfield(data, 'tobs') &&  ...
                ~isempty(data.tobs) && ...
                isfield(Basemodeles.type, nomparamS{j})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparamS{j}),...
                uniteT, ...
                Basemodeles.type.(nomparamS{j}));
            val=Basemodeles.valparamS.(lemodele).(nomparamS{j});
            valeur=val*fact;
        end
        set(data.(tag),'string',num2str(valeur),'backgroundcolor','w')
        
        
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
    end
end



handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1,ndata)


end %fin reinit_mod_sim
