function FILTREX
% Task manager
%% ====================================
%

clc % First, clean
clear all
close all
startup
%% Main figure with the tasks choice menu
h1=figure('units','normalized',...
    'position',[0.1 .6 .3 .18],...
    'color',[0.95 0.913 0.97],...
    'numbertitle','off',...
    'menubar','none',...
    'resize','off');
set(h1, 'Name', sprintf('FILTREX 3.0 (R2015a)'));
uicontrol('Parent',h1,'Style','text', ...
 'units','normalized',...
	  'FontWeigh', 'bold', ...
	  'position', [0 .7 1 .3 ] , ...
'backgroundcolor',[0.95 0.913 0.97],...
	  'String', {' ', 'MAKE YOUR CHOICE',''});
%	  'FontAngle', 'italic', ...

%% The tasks choice menu
 uicontrol('Parent',h1,'Style','listbox',...
     'string',[ ...
 'PARAMETRIC IDENTIFICATION|' ...
 'DYNAMICS COMPARISON OF TWO MODELS WITH THE BAYES FACTOR|' ...
  'SIMULATION OF AN OPTIMAL SEQUENTIAL SAMPLING|' ...
  'SIMULATION OF AN OBSERVATION DATASET|', ...
 'QUIT FILTREX|QUIT MATLAB|What is FILTREX'],...
'units','normalized',...
     'Position',[0 0 1 .7],...
 'backgroundcolor', [0.95 0.95 0.95], ...
 'Min', 1,  'Max', 1,...
	   'value', 7, ...
	   'fontsize',12, ...
'callback',@go);
end % end FILTREX

