function  [fileSave]=exec1Test(fileName, choix)
% FUNCTION
% 1/  restore a result-file
% 2/ make it execute again
% CONTEXT
% Compare stored results to actual ones in noninteractive mode (test)
% INPUT
% fileName:  relative or absolute pathname of the result-file
% choix: index of the task to execute
%% =====================================================

if ~exist( fileName, 'file')
    errordlg(['File ', fileName, ' does not exist']);
    return
end

close all;
obj = uicontrol( 'value', choix);
disp(['EXECUTION OF: ' fileName])
tic %time measuring
fileSave=go(obj, fileName);
disp(['END EXECUTION OF: ' fileName])
toc

end % end exec1Test
