function filtrexStrategieopthelp(obj,event)
%filtrexStrategieopthelp
% Affiche une fenetre d'aide pour la tâche simulation d'une
% stratégie optimale
%% ======================================================

aprop=figure('units','normalized',...
    'numbertitle','off',...
    'menubar','none',...
    'resize','on');
set(aprop, 'Name', sprintf('FILTREX: user guide to simulate an optimal strategy'));
uic = uicontrol('parent',aprop,...
    'fontsize',11,...
    'BackgroundColor','white',...
    'units','normalized',...
    'position',[0 0 1 1],...
    'style','text',...
    'HorizontalAlignment', 'left', ...
    'string',{'',...
	      '- Click on ''Save results'', then ''the entire project'' save inputs and results in a file. This file can be restored by a click on ''Restore''.', ...
  '', ...
	      '- Click on ''Save results'', then ''Optimal times'' save the optimal times, either in a Matlab file, or an Excel file. This file can be loaded in the task ''Simulation of a dataset'' to generate data at the optimal times.', ...
  '', ...
 '- To avoid scrolling the menus, shortcuts are possible:', ...
    '     Ctrl+o: open a data file (SIVIP method)', ...
    '     Ctrl+d: choose the model dynamics', ...
    '     Ctrl+z: reset the input to the default values', ...
    '     Ctrl+r: restore a file', ...
    '     Ctrl+h: display this page', ...
    '     Ctrl+q: quit Matlab', ...
    '', ...
    '- A left click on the optima plot saves it in a Matlab graphical windows',...
          ''});

end % fin filtrexStrategieopthelp
