
function filtrexhelp(obj,event)
% filtrexhelp
% Affiche une fenetre d'aide pour la tâche estimation des paramètres

%% ======================================================


aprop=figure('units','normalized',...
  'menubar','none',...
  'numbertitle','off',...
  'resize','on');

set(aprop, 'Name', sprintf('FILTREX: user guide'));

uic = uicontrol('parent',aprop,...
    'fontsize',11,...
    'BackgroundColor','white',...
    'units','normalized',...
    'position',[0 0 1 1],...
    'style','text',...
    'HorizontalAlignment', 'left', ...
    'string',{'',...
    '- To avoid scrolling the menus, shortcuts are possible:', ...
    '     Ctrl+o: open a data file', ...
    '     Ctrl+d: choose the model dynamics (in the task MODEL COMPARISON, it is the numerator model)', ...
    '     Ctrl+e: in the task MODEL COMPARISON, choose the denominator model', ...
    '     Ctrl+z: reset the input to the default values', ...
    '     Ctrl+r: restore a file', ...
    '     Ctrl+h: display this page', ...
    '     Ctrl+q: quit Matlab', ...
    '', ...
    '- A left click on a plot saves it in a Matlab graphical windows (for the histograms, click on a blank part of the frame)',...
    '', ...
    '- In the task PARAMETER IDENTIFICATION, when confidence intervals are required,  histogramms are displayed if the number of dynamics >=10. 80% of them are then plotted in the beginning of the process, the others at its end',...
    '', ...
    ' To know:',...
    '- When the times read on the data file are not integer values, they are converted into the lower unit time for the calculations (into hours if they are days, into mns if they are hours), then they are rounded to the nearest integer',...
    '- The results of parameter identification are as much dependent of the seed as the number of particles is small (1000)',...
    ''});

end % fin filtrexhelp
