function help_dynamics(obj, ~)
% help_dynamics open PDF files to show dynamics Equation model
% La propriete userdata existe dans obj si le programme est appelé par
% la simulation de données, auquel cas, il ne faut faire apparaitre
% les modeles Ln et LogLinear
%% ======================================================
Basemodeles=init_Basemodeles();
userdata= get(obj, 'userdata');
if ~isempty(userdata)
    % oter les modeles Ln
    str={};
    for i=1:length(Basemodeles.nom)
        if isempty(strfind(Basemodeles.nom{i}, 'Ln')) && ...
                strcmpi(Basemodeles.nom{i}, 'LogLinear')==0
            str{end+1}= Basemodeles.nom{i};
        end
    end
    
    
    [p,v] = listdlg('PromptString','Select the model to be studied:',...
        'ListSize',[200 350],...
        'SelectionMode','multiple',...
        'ListString',str, ...
        'OKString', 'HELP');
    for i=1:length(p)
        pp=p(i);
        s(i)=find(strcmpi(Basemodeles.nom, str(pp)));
    end
    
else
    
    str=Basemodeles.nom;
    [s,v] = listdlg('PromptString','Select one or several models:',...
        'ListSize',[200 350],...
        'SelectionMode','multiple',...
        'ListString',str, ...
        'OKString', 'HELP');
end

if v
    % reponse OK
    %% Determiner la commande de visualisation de pdf
    if exist('winopen', 'builtin')
        cde='winopen';
    else
        [status, ~]= system('which acroread');
        if status == 0
            cde = 'acroread';
        else
            [status, ~]= system('which evince');
            if status == 0
                cde ='evince';
            else
                errordlg('No pdf reader found');
                return
            end
        end
    end
    
    %% Boucle sur l'ouverture des pdfs
    nommod = Basemodeles.nom(s);
   % Change to the pdf location
   oldfolder=cd('DOC');
% Process in two steps to avoid different ways to express hierarchy
% according to the platforms
   cd('DYNAMICS');
    for i=1:length(nommod)
        fichier=[ nommod{i}, '.pdf'];
        switch cde
            case 'winopen'
                winopen(fichier);
            case 'acroread'
%AU CAS OU                [~,  ~]=system(['acroread -geometry 800x750 ' fichier  ' &']);
                [~,  ~]=system(['acroread ' fichier  ' &']);
            case 'evince'
                [~,  ~]=system(['evince  ' fichier  ' &']);
        end
    end %fin for i
% Change the current folder to the previous location:
cd(oldfolder)

    
end %fin v


end % fin function

