function [ data ] = ecrire_les2mod( tag, data)
% ecrire_les2mod
% Ecrire les valeurs estimées des paramètres des 2 modèles sur le même panel
% INPUT
% tag: le tag du panel à écrire
% data: la structure qui contient les résultats et le panel hpanel_work
% INPUT/OUTPUT
% data: structure qui contient les résultats et les panels

%% ======================================================
%% Créer le panel
hp2=uipanel('parent',data.hpanel_work,...
    'tag',tag,...
    'BorderType', 'none', ...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);
data.(tag) = hp2;

hp22=uicontrol('parent', hp2,...
    'BackgroundColor','white',...
    'fontsize',12,...
    'foregroundcolor',[0 0 0],...
    'units','normalized',...
    'Position',[0 0.9 1 0.08], ...
    'style','text');
set(hp22, 'String', 'Both models: ESTIMATED RESULTS ');
%% Créer les colonnes
nomfonction={'Parameter','Estimated mean for the numerator model',...
    'Estimated mean for the denominator model'};
marge=0.07; %marge à droite et a gauche
pasnom=0.1; % largeur de la colonne du nom du parametre, plus étroite
pasx=(1-2*marge-pasnom)/(length(nomfonction)-1); %largeur des autres colonnes
% la colonne du nom du parametre, plus étroite
i=1;
var_tag=['colonne'  num2str(i) '_tag'];
debutx=marge + pasx*(i-1);
data.(var_tag) =uibuttongroup('Parent',hp2,...
    'tag',var_tag,...
    'backgroundcolor',[1 1 1],...
    'Position',[debutx .1 pasnom .8]);

for i=2:length(nomfonction)
    var_tag=['colonne'  num2str(i) '_tag'];
    debutx=marge + pasnom+ pasx*(i-2);
    data.(var_tag) = uibuttongroup('Parent',hp2,...
        'tag',var_tag,...
        'backgroundcolor',[1 1 1],...
        'Position',[debutx .1 pasx .8]);
    
    
end
handles=guihandles(gcf);
ndata=catstruct(data,handles);

guidata(gcf,ndata)
data=guidata(gcf);

%% Mettre les titres des colonnes
for i=1:length(nomfonction)
    var_tag=data.(['colonne'  num2str(i) '_tag']);
    uicontrol('parent',var_tag,...
        'units','normalized',...
        'fontsize',12,...
        'position',[0 .95 1 .04],...
        'backgroundcolor',[1 1 1],...
        'foregroundcolor','k',...
        'style','text',...
        'string',nomfonction{i});
end
nomparam1 = data.nomparam1;
nomparam2 = data.nomparam2;
nbparam1=length(nomparam1);

%% Compter le nbre de parametres a écrire:
% tous ceux du modèle 1 + ceux du modèle 2 qui ne sont pas dans le
% modèle 1
[~,ia] = setdiff(nomparam2, nomparam1);
nbparam= nbparam1+length(ia);

% Les paramètres fixes
nomparamS2= data.nomparamS2;
nomparamS1= data.nomparamS1;

pasy=0.94/(nbparam);
for i=1:nbparam1
    debuty=0.94-i*pasy;
    lastring=traduc_nom(nomparam1{i}, data.Basemodeles.type);
    
    uicontrol('parent',data.colonne1_tag,...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'', lastring});
    uicontrol('parent',data.colonne2_tag,...
        'units','normalized',...
        'fontsize',15,...
        'position',[0 debuty 1 pasy],...
        'style','text',...
        'string',{'',num2str(data.paramfin1(i),6)});
    col3=uicontrol('parent',data.colonne3_tag,...
        'units','normalized',...
        'fontsize',15,...
        'position',[0 debuty 1 pasy],...
        'style','text');
    j=find(strcmp(nomparam1{i}, nomparam2));
    if ~isempty(j)
        % nomparam1{i} est aussi un parametre actif du modele 2
        set(col3, 'string',{'',num2str(data.paramfin2(j),6)});
    else
        % nomparam1{i} est-il un parametre fixé du modele 2?
        j=find(strcmp(nomparam1{i}, nomparamS2));
        if ~isempty(j)
            % nomparam1{i} est un parametre fixé du modele 2
            valeur= data.([nomparam1{i} '_mod2']);
            set(col3, 'string',{'', num2str(valeur,6)}, 'FontAngle', 'italic');
        end
    end
    
    
    
end % fin param1

% Ecrire les paramètres du modèle 2 non dans le modèle 1

for i=1:length(ia)
    j=ia(i);
    debuty=0.94-(nbparam1+i)*pasy;
    lastring=traduc_nom(nomparam2{j}, data.Basemodeles.type);
    uicontrol('parent',data.colonne1_tag,...
        'units','normalized',...
        'position',[0 debuty 1 pasy],...
        'fontsize',13,...
        'style','text',...
        'string',{'', lastring});
    col2= uicontrol('parent',data.colonne2_tag,...
        'units','normalized',...
        'fontsize',15,...
        'position',[0 debuty 1 pasy],...
        'style','text');
    % nomparam2{j} est-il un paramètre fixé du modele 1?
    k=find(strcmp(nomparam2{j}, nomparamS1));
    if ~isempty(k)
        % nomparam2{j} est un parametre fixé du modele 1
        valeur= data.([nomparam2{j} '_mod1']);
        set(col2, 'string',{'', num2str(valeur,6)}, 'FontAngle', 'italic');
    end
    
    
    uicontrol('parent',data.colonne3_tag,...
        'units','normalized',...
        'fontsize',15,...
        'position',[0 debuty 1 pasy],...
        'style','text',...
        'string',{'',num2str(data.paramfin2(j),6)});
end %fin param2


end %fin ecrire_les2mod

