function plagesmax_mod_comp(obj,event)
%plagesmax_mod_comp  Mettre les plages maximales aux paramètres d'un modèle
% excepté les paramètres du modèle qui sont des CVs
% INPUT
% Le no du modèle est dans la propriété 'userdata' de obj
% event est ignoré
%% ======================================================
global input_error;
data=guidata(1);
nmod=get(obj, 'userdata'); % le no du modèle
strnmod=num2str(nmod);
lemodele = ['modelepop', strnmod];

if ~isfield(data, lemodele) || isempty(data.(lemodele))
    return
end
%% Se positionner sur le modèle dont on veut réinitialiser les paramètres
try
    if str2double(get(data.num_tab_tag_control,'string')) ~= nmod
        objet=uicontrol('visible', 'off', ...
            'userdata', '_control');
        while (str2double(get(data.num_tab_tag_control,'string')) > nmod)
            retrancher_comparaison_tab(objet);
        end
        while (str2double(get(data.num_tab_tag_control,'string')) < nmod)
            ajouter_comparaison_tab(objet);
        end
    end
end

%% Modifier les paramètres du modèle

if isempty(data.(lemodele))
    return
end
modelecour=data.(lemodele);
nomCVs=data.CVs.nomparamS;
nomparam=data.(['nomparam', strnmod]);
s=find(strcmpi(data.Basemodeles.nom,modelecour));
nommodele=strrep(modelecour, '-',''); %le nom du modele sans tiret
Basemodeles=data.Basemodeles;



for i=1:length(nomparam)
    if ~isempty(nomparam{i})
        if any(strcmpi(nomparam{i},  nomCVs))
            % le parametre est  un CV: on le reinitialise via le bouton
            % spécifique
            continue
        end
        init=Basemodeles.DF.(nommodele);
        % la val min
        valeur=init.(nomparam{i}){1};
        var=[nomparam{i},'min_mod', strnmod];
        tag=[var,'_tag'];
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            uniteT= get(data.uniteT_tag, 'value');
            fact=timemod2data(Basemodeles.unite.(nomparam{i}),...
                uniteT, ...
                Basemodeles.type.(nomparam{i}));
            valeur=str2double(valeur)*fact;
        end
        
        
        set(data.(tag),'string',num2str(valeur), 'backgroundcolor','w');
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        
        % la val max
        var=[nomparam{i},'max_mod', strnmod];
        tag=[var,'_tag'];
        valeur=init.(nomparam{i}){2};
        if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparam{i})
            % des donnees ont été lues: convertir la val def du param selon leur unite de temps
            valeur=str2double(valeur)*fact;
        end
        
        set(data.(tag),'string',num2str(valeur),'backgroundcolor','w');
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
        var=[nomparam{i},'_bruit_mod', strnmod];
        tag=[var,'_tag'];
        set(data.(tag),'value',data.Basemodeles.initbruit.(nomparam{i}));
        if ~isempty(input_error) && isfield(input_error, tag)
            input_error= rmfield(input_error, tag);
        end
    end
end

end % fin plagesmax_mod_comp
