function  data = put_indices_panels_comparaison (data, indice_panel, parent, suffixe)
% put_indices_panels_comparaison
% Afficher le no du panel indice_panel en bas de page, et le '-' et '+' qui
% permettent de passer au panel précédent et suivant
% INPUT
% indice_panel: indice du  panel 
% parent: le parent du panel courant (data.hpanel_control ou
% data.hpanel_work)
% suffixe='_control' si les panels sont dans l'écran de saisie des entrées
% et '' s'ils sont dans l'écran d'affichage des résultats

%% ======================================================
% Detruire le précédent affichage s'il existe
tag= ['num_tab_tag' suffixe];
try
    delete(data.(tag));
end


hnum=uicontrol('parent', parent,...
    'units','normalized',...
    'foregroundcolor',[.4 0 .2],...
    'position',[.49 0  .06 .02],...
    'tag', tag, ...
    'style','text');
set(hnum,'string',num2str(indice_panel))
data.(tag)=hnum; % 29/1/2014, Matlab R2013a

tab_precedent_tag= ['tab_precedent_tag'  suffixe];
try
    delete(data.(tag_precedent_tag));
    data=rmfield(data, tag_precedent_tag);
end

if ~isempty(suffixe)
    % cas des entrees: garder les uicontrol pour pouvoir les effacer
    tab_precedent_tag= [tab_precedent_tag num2str(indice_panel)];
end

if indice_panel >1
    data.(tab_precedent_tag)=uicontrol('parent', parent,...
        'units','normalized',...
        'position',[.43 0 .06 .02],...
        'string','-',...
        'tag', tab_precedent_tag,...
        'userdata', suffixe, ...
        'callback',@retrancher_comparaison_tab,...
        'style','pushbutton');
end

tab_suivant_tag= ['tab_suivant_tag'  suffixe];
try
    delete(data.(tag_suivant_tag));
end

data.(tab_suivant_tag)=uicontrol('parent', parent,...
    'units','normalized',...
    'position',[.55 0 .06 .02],...
    'string','+',...
    'userdata', suffixe, ...
    'callback',@ajouter_comparaison_tab,...
    'tag',tab_suivant_tag,...
    'Visible', 'off', ...
    'style','pushbutton');
end % fin put_indices_panels_comparaison

