function restore_2mod(obj,event)
%restore_2mod Restaure la structure qui avait été stockée via "Sauvegarder"
% lors d'une précédente exécution dans un fichier Matlab
% (cas de la comparaison de modèles)
% INPUT
% Si event est une chaine de caractères, celle-ci contient le nom du fichier
% à restaurer. C'est le cas en mode non-interactif, où on restaure
% une précédente exécution pour la relancer, (pour comparer les
% résultats à ceux du fichier d'entrée, pour tester des modifs)
% Sinon, on est en mode interactif (cas usuel), et le nom du fichier à restaurer
% sera demandé à l'utilisateur
% obj est ignoré

%% ======================================================
fileName = num2str(event);

% on sauve le nom du fichier test a cause du 'clear all' qui suit:
setenv('FILTREXTEST', fileName); 
clear all; % Vider le workspace



%% Lecture du fichier de sauvegarde
fileName = getenv('FILTREXTEST');

if isempty(fileName) 
    [fileName, pathName] = uigetfile( ...
	[getenv('PROJECTDIR') '/MODEL_COMPARISON/*.mat'],  'Select a Matlab file');
    if isequal(fileName,0) || isequal(pathName,0)
        return;
    end
else
    pathName= [pwd '/'];
    setenv('FILTREXTEST', ''); %raz de la va d'environnement
end

chemin=fullfile(pathName, fileName);
drawnow


load(chemin);
%% Maintenant, la structure 'data' est chargée:
% on la garde dans datalu, et on charge dans 'data' ce qui s'affiche
% i.e le cadre (handle) par défaut.
% On va le modifier en y mettant les valeurs lues
datalu=data;
data=guidata(1);
data.indice_panel_control= datalu.indice_panel_control;

%% Nettoyer les eventuels résultats précédents
delete(get(data.hpanel_work,'children'))
% Nettoyer le cadre qui précise les études voulues
set(data.cvinparam_tag,'value',0);



%% Restauration du cadre qui concerne les observations

% Restauration du  pas de temps des observations
set(data.uniteT_tag,'value', datalu.uniteT_in);

proposition = datalu.pas_tag_in;
set(data.pas_tag, 'string', proposition);
try
    if ( str2num(proposition) ~=1)
        set(data.deltaT_tag,'string',datalu.deltaT_in,  'enable', 'on');
    else
        set(data.deltaT_tag, 'string', '1', 'enable', 'off');
    end
end
try
    data.deltaT=eval(get(data.deltaT_tag,'string'));
end
%% Restauration du cadre qui concerne le filtre
for i=1:length(data.Filtre.nomparamS)
    var=data.Filtre.nomparamS{i};
    varin=[var, '_in'];
    if isfield(datalu, varin)
        data.(var)=datalu.(varin);
    else
        data.(var)=data.Filtre.valparamS{i};
  end
    tag=[var,'_tag'];
    style=get(data.(tag),'style');
    if strcmpi(style, 'listbox')
     set(data.(tag),'value', data.(var),'backgroundcolor','w');
   else
    set(data.(tag),'string',data.(var),'backgroundcolor','w');
  end
end

%% les CVs
nomCVs=datalu.CVs.nomparamS;

%% Restauration des modèles
for nmod=1:2
    strnmod=num2str(nmod);
    try
        % Restauration du cadre qui concerne le modèle nmod
        % D'abord, tracer le cadre avec les val par defaut:
        data=restore_dynamique_2mod(data,datalu, nmod);
        letag= ['plagesmax' strnmod '_tag'];
        set(data.(letag), 'Visible','on');
        
         
        %% Modification des val par defaut par celles lues sur le fichier:
        s=find(strcmpi(datalu.Basemodeles.nom,datalu.(['modelepop' strnmod])));
        %% Restauration de la valeur des paramètres fixes:
        nomparamfixes=datalu.Basemodeles.nomparamS{s};
        if ~isempty(nomparamfixes)
            for i=1:length(nomparamfixes)
                if any(strcmpi(nomparamfixes{i}, nomCVs))
                    % le parametre est  un CV
                    continue
                end
                tagin=[nomparamfixes{i},  strnmod '_in'];
                tagout=[nomparamfixes{i}, '_mod', strnmod,'_tag'];
                set(data.(tagout),'string',eval(['datalu.',tagin]),'backgroundcolor','w');
            end
        end % length(nomparamfixes)>0
        
        %% Restauration de la valeur des paramètres à estimer:
        nomparamactifs=datalu.Basemodeles.nomparamP{s};
        
        if ~isempty(nomparamactifs)
            for i=1:length(nomparamactifs)
                if any(strcmpi(nomparamactifs{i}, nomCVs))
                    % le parametre est un CV
                    continue
                end
                
                tagin=[nomparamactifs{i},'min', strnmod, '_in'];
                tagout=[nomparamactifs{i},'min_mod', strnmod, '_tag'];
                set(data.(tagout),'string',eval(['datalu.',tagin]),'backgroundcolor','w');
                
                tagin=[nomparamactifs{i},'max', strnmod, '_in'];
                tagout=[nomparamactifs{i},'max_mod', strnmod, '_tag'];
                set(data.(tagout),'string',eval(['datalu.',tagin]),'backgroundcolor','w');
                
                tagin=[nomparamactifs{i},'_bruit', strnmod, '_in'];
                tagout=[nomparamactifs{i},'_bruit_mod', strnmod, '_tag'] ;
                set(data.(tagout),'value',eval(['datalu.',tagin]),'backgroundcolor','w');
                
            end
            
        end %if paramactifs
        
        drawnow
        
    end % fin try
end % fin nmod

%% nettoyer les indices des panels des modeles
 if isfield(data, 'tab_precedent_tag_control3')
     set(data.tab_precedent_tag_control3, 'visible', 'off')
     data=rmfield(data, 'tab_precedent_tag_control3');
 end
 if isfield(data, 'tab_precedent_tag_control2')
     set(data.tab_precedent_tag_control2, 'visible', 'off')
     data=rmfield(data, 'tab_precedent_tag_control2');
 end


if isfield(data, 'tab_suivant_tag_control')
    set(data.tab_suivant_tag_control, 'visible', 'off')
    data=rmfield(data, 'tab_suivant_tag_control');
end
    
%% afficher les indices des panels des modeles   
data=put_indices_panels_comparaison ( data, data.indice_panel_control, data.hpanel_control, '_control');
 

%% Restaurer les CVs si a estimer
 if (datalu.cvinparam_in==1)
    data=restore_CVs(datalu, nomparamactifs);
 % afficher les indices des panels des modeles   
   data=put_indices_panels_comparaison ( data, data.indice_panel_control, data.hpanel_control, '_control');


else
    % les CVs ne sont pas à estimer
    set(data.groupebutton3c_tag,'visible', 'off')
    set(data.cv_tag, 'visible', 'off');
    set(data.cvinparam_tag, 'value',0);
    
    for i=1:length(data.CVs.nomparamS)
        var=data.CVs.nomparamS{i};
        tag=[var,'_tag'];
        set(data.(tag), 'string', eval(['datalu.',var, '_in']),'backgroundcolor','w');
    end
    
end % fin des CVs




%% Restauration des autres valeurs utiles:
data.releveobs=datalu.releveobs;
%Rque: datalu.tobs= donnees lues
%   datalu.filtrexplot.tobs= donnees dans l'unite de temps des calculs

data.tobs=datalu.tobs;

data.yobs=datalu.yobs;
data.nbrepet=datalu.nbrepet;
data.Nbestime=datalu.Nbestime;
data.logNbestime=datalu.logNbestime;
data.paramobs=datalu.paramobs;
%% La description des donnees
% fichier_nom a été intoduit en oct 2014: c'est le nom du fichier des data
if isfield(datalu, 'fichier_nom')
    set(data.fichier_chemin_tag, 'string', ...
        [  datalu.fichier_nom, '  RESTORED FILENAME : ',  fileName ], 'Visible', 'on');
else
    set(data.fichier_chemin_tag, 'string', ...
        ['  RESTORED FILENAME : ',  fileName ], 'Visible', 'on');
end


set(data.fichier_descr_tag, 'visible', 'on', ...
  'String', ...
	    [num2str(length(data.tobs)) ' observation times; ' ...
			       num2str(data.nbrepet) ' replications; ' , ...
    'Read time unit: ' datalu.uniteT_libelle, ...
    '; Computation time unit: ' datalu.uniteT_pourcalcul_libelle]);


%% rajouter la possibilite du plot des donnees
if isfield(data, 'plotdata_tag')
set(data.plotdata_tag, 'visible', 'on');
set(data.plotdata_tag, 'userdata', {data.tobs, data.logNbestime, fileName});
end

% Restauration de l'unite de temps
data.uniteT_pourcalcul=datalu.uniteT_pourcalcul_in;
data.uniteT_pourcalcul_libelle=datalu.uniteT_pourcalcul_libelle_in;
data.uniteT_libelle=datalu.uniteT_libelle;
data.tobsfactT = datalu.tobsfactT;
data=afficher_uniteT(data);

%%  Restauration du panel des plots et résultats

indice_panel=0;
%% Les résultats de l'estimation des modèles
for nmod=1:2
    strnmod=num2str(nmod);
    data.(['modelepop' strnmod]) = datalu.(['modelepop' strnmod]) ;
    if isfield(datalu, ['paramfin' strnmod])
        % le modèle a été estimé
        data.(['paramfin' strnmod])= datalu.(['paramfin' strnmod]);
        data.(['nomparam' strnmod])= datalu.(['nomparam' strnmod]);
        data.(['nomparamS' strnmod])= datalu.(['nomparamS' strnmod]);
        for i=1:length(datalu.(['nomparamS' strnmod]))
            nomp = datalu.(['nomparamS' strnmod]){i};
            data.([nomp '_mod' strnmod])=datalu.([nomp '_mod' strnmod]);
        end
    end
    
end % fin nmod


%% Le tableau des résultats finaux
if isfield(datalu.filtrexplot, 'Moyenne1') && ...
        isfield(datalu.filtrexplot, 'Moyenne2')
    %% les 2 modèles ont été estimés
    % Tracé sur le meme panel des estimations de leurs parametres
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_mod12_tag'];
    data=ecrire_les2mod( tag, data);
end

%% Ecrire les facteurs de Bayes
if isfield(datalu,  'FBayes')
    % il y a des résultats  finaux
    data.VraisM=datalu.VraisM;
    data.FBayes=datalu.FBayes;
    data.FBevolutif=datalu.FBevolutif;
    
    %Effacer les sorties précédentes
    fils=allchild(data.hpanel_work);
    for i =1:length(fils)
        set(fils(i), 'visible','off')
    end
    tag=['titre_mod12_tag'];
    titre=uicontrol('parent',data.hpanel_work,...
        'units','normalized',...
        'foregroundcolor','w',...
        'background',[.4 .2 .2],...
        'position',[0 .98  1 .02],...
        'tag',tag,...
        'style','text');
    set(titre, 'string', ...
        [ 'Comparison of model ' data.modelepop1 ' (numerator)' ...
        ' and model '  data.modelepop2 ' (denominator)']);
    
    %% Pour les plots
    Moyenne={datalu.filtrexplot.Moyenne1, datalu.filtrexplot.Moyenne2};
    
    %% plot de l'évolution des estimations de chaque parametre
    % qui sont les mêmes dans les 2 modèles
    % sinon le plot_evolution ne fait rien
    
    [indice_panel, data]=plot_evolution_para_2mod(indice_panel, data, ...
        data.nomparam1, data.nomparam2, ...
        datalu.filtrexplot.abscisses, ...
        Moyenne,  datalu.filtrexplot.nbparticules);
    
    
    %% plot  de l'évolution des dynamiques et de l'état
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_mod12_tag'];
    pop={datalu.filtrexplot.pop1, datalu.filtrexplot.pop2};
    data=plot_dyn_obs_2mod(tag, data, ...
        datalu.filtrexplot.temps, ...
        datalu.filtrexplot.vobs_or, pop, ...
         datalu.filtrexplot.logNbestime,  Moyenne);
    
    %% plot  de l'évolution du facteur de bayes
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_mod12_tag'];

    data= plot_fbayes(tag, data.hpanel_work, datalu.filtrexplot.tobs_or,data.FBevolutif, data.uniteT_libelle, data);
    
    %%  panel des résultats finaux
    [data, indice_panel]=ecrire_fbayes(tag, indice_panel, data, data.tobs);
end % fin     isfield(datalu,  'FBayes')



%% Fin des affichages: mettre la numérotation des panels
data.indice_panel=indice_panel;
data=put_indices_panels_comparaison(data, indice_panel, data.hpanel_work,'');


%% Affichage:
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(1, ndata)

end % fin restore_2mod
%% ======================================================

function  data=restore_dynamique_2mod(data, datalu, nmod)
%restore_dynamique_2mod Trace le 'panel' d'affichage des entrées du modèle nmod
% Les valeurs affichées sont celles par défaut.
% Construit aussi le menu qui permet de (dé)fixer des paramètres.
% INPUT
% data: le handle courant
% datalu: la structure qui contient les valeurs préalablement
% sauvegardées  sur un fichier
% nmod: le no du modèle
% APPELÉ PAR
%  la fonction  'restore_2mod'

%% ======================================================

% *** Restauration des valeurs par défaut ***
% Basemodeles contient les val par défaut des bornes des
%  parametres a estimer
% dans Basemodeles.init.<nomparam>{1 et 2} et les val  par défaut
% des param fixés dans Basemodeles.valparamS.<nomparam> et
% les bruits par défaut dans Basemodeles.initbruit.<nomparam>
strnmod= num2str(nmod);
data.Basemodeles=datalu.Basemodeles;
nomCVs=datalu.CVs.nomparamS;
s=find(strcmpi(datalu.Basemodeles.nom,datalu.(['modelepop' strnmod])));

% *** Le menu qui permet de fixer/défixer des parametres
% On détruit le menu précédent
delete(get(data.(['dynamique' strnmod '_tag']),'children'));
% *** Le menu qui permet de défixer des parametres fixes: ***
nomparamfixes=datalu.Basemodeles.nomparamS{s};
for i=1:length(nomparamfixes)
    if any(strcmpi(nomparamfixes{i}, nomCVs))
        % le parametre est  un CV
        continue
    end
    uimenu(data.(['dynamique' strnmod '_tag']),...
        'Label', traduc_nom(nomparamfixes{i}, data.Basemodeles.type),...
        'userdata', {nomparamfixes{i}, nmod}, ...
        'callback',@gestion_parametres_comparaison,...
        'checked','off');
end

% *** Le menu qui permet de fixer des parametres actifs:***
nomparamactifs=datalu.Basemodeles.nomparamP{s};
for i=1:length(nomparamactifs)
    if any(strcmpi(nomparamactifs{i}, nomCVs))
        % le parametre est un CV
        continue
    end
    uimenu(data.(['dynamique' strnmod '_tag']),...
        'Label',traduc_nom(nomparamactifs{i}, data.Basemodeles.type),...
        'userdata', {nomparamactifs{i}, nmod}, ...
        'callback',@gestion_parametres_comparaison,...
        'checked','on');
end
set(data.(['dynamique' strnmod '_tag']),'visible','on');
% L'affichage des paramètres du modele avec leurs valeurs par défaut:
data.(['modelepop' strnmod])=datalu.(['modelepop' strnmod]);
s=find(strcmpi(data.Basemodeles.nom,data.(['modelepop' strnmod])));
%s=indice  du modèle
guidata(1,data);



%% trace du modele
switch nmod
    case 1
        suffixe =''; % suffixe des groupebutton3 correspondant au modele
    case 2
        suffixe='b';
end


data.indice_panel_control=nmod;
tag=['panel_control' strnmod '_tag'];

bouton = ['groupebutton3' suffixe '_tag'];
set(data.(bouton),    'tag',tag);
set(data.(bouton),  'visible', 'on')

data=trace_modele_comparaison(data, s, ...
    data.(['groupebutton30' suffixe '_tag']), ...
    data.(['groupebutton31' suffixe '_tag']), ...
    data.(['groupebutton32' suffixe '_tag']), ...
    data.(['groupebutton33' suffixe '_tag']), ...
    nmod);


end % fin restore_dynamique_2mod

%% =================================================
function dataout=restore_CVs(datalu, nomparamactifs)
%restore_CVs Restaurer les CVs quand ils sont estimés
%% =================================================
data=guidata(1);

    %cocher si les CV sont estimés
    set(data.cvinparam_tag, 'value', 1);
    CVs=datalu.CVs;
    
    % Ajout de la possibilité de les fixer dans l'onglet du haut
    set(data.cv_tag, 'visible', 'on');
    % Maj de la liste des CVs dans l'onglet du haut
    leparent = ['dynamiquecv_tag'];
    delete(get(data.(leparent), 'children'));
    CVestimer=0; % indicateur s'il y a des CVs a estimer
    for i=1:length(CVs.nomparamS)
        if any(strcmpi(CVs.nomparamS{i}, nomparamactifs))
            % Le CV est a estimer
            uimenu(data.(leparent), ...
'Label', traduc_nom(CVs.nomparamS{i}),...
'userdata', CVs.nomparamS{i}, ...
                'callback',@gestion_CVs,...
                'checked','on');
	      CVestimer=1;
        else
            uimenu(data.(leparent), ...
'Label',traduc_nom(CVs.nomparamS{i}),...
'userdata', CVs.nomparamS{i}, ...
                'callback',@gestion_CVs,...
                'checked','off');
        end
        
        
    end
    if CVestimer==1
      set(data.plagesmax_CV_tag, 'Visible', 'on');
    else
      set(data.plagesmax_CV_tag, 'Visible', 'off');
    end

    
    % dans le cadre des paramètres des observations, on les rend non
    % modifiables
    for c=1:length(CVs.nomparamS)
        var=[CVs.nomparamS{c},'_tag'];
        set(data.(var),'string', '-');
        set(data.(var),'enable','off');
    end
    guidata(1,data)
    
    % Affichage des valeurs par défaut des CV
    indice_panel_control=3;
    data.indice_panel_control=indice_panel_control;
    tag=['panel_control' num2str(indice_panel_control) '_tag'];
    set(data.groupebutton3c_tag,    'tag',tag);
    set(data.groupebutton3c_tag,'visible', 'on');
    data=trace_CVs(data, ...
        data.modelepop1, data.modelepop2, ...
        data.groupebutton30c_tag, ...
        data.groupebutton31c_tag, data.groupebutton32c_tag, ...
        data.groupebutton33c_tag);
    
    data=guidata(1);
    
    % Modification par les valeurs lues
    nomCVs=CVs.nomparamS;
    for i=1:length(nomCVs)
        if any(strcmpi(nomCVs{i}, nomparamactifs))
            % le CV est a estimer
            tagin=[nomCVs{i},'min_in'];
            tagout=[nomCVs{i},'min_tag'];
            set(data.(tagout),'string',eval(['datalu.',tagin]),'backgroundcolor','w');
            tagin=[nomCVs{i},'max_in'];
            tagout=[nomCVs{i},'max_tag'];
            set(data.(tagout),'string',eval(['datalu.',tagin]),'backgroundcolor','w');
            
            tagin=[nomCVs{i},'_bruit_in'];
            tagout=[nomCVs{i},'_bruit_tag'] ;
            set(data.(tagout),'value',eval(['datalu.',tagin]),'backgroundcolor','w');
        else
            % CV fixé
            tagin=[nomCVs{i},'_in'];
            % mettre sa valeur dans le panel du modèle d'observations
            tagout=[nomCVs{i},'_tag'];
            set(data.(tagout),'string',eval(['datalu.',tagin]),'backgroundcolor','w');
            % mettre sa valeur dans le panel des CVs
            tagout=[nomCVs{i},'_fixtag'];
            set(data.(tagout),'string',eval(['datalu.',tagin]),'backgroundcolor','w');
            
        end % if CV a estimer
        
    end %fin i
    
dataout=data;
end % fin restore_CVs    
    
