
function [tobsmaj, tobsfactT, uniteT_libelle,uniteT_pourcalcul, ...
    uniteT_pourcalcul_libelle] = convert_tps_decimaux(tobs, uniteT)
%convert_tps_decimaux Convert the times according to the time unit
% The times are in "tobs".
% When they are not integers, they are converted by a call to convert_tps
% In this case, if they are expressed in days (uniteT=1), 
% they are converted in hours.
% if they are expressed in hours (uniteT=2),
% they are converted in mns.
% Then, we rounded to the next integer
%% ======================================================
% Garder l'unité des données lues
switch uniteT
    case 1
        uniteT_libelle = 'day';
    case 2
        uniteT_libelle = 'hour';
    case 3
        uniteT_libelle = 'mn';
end %fin switch

if any(mod(tobs,1) ~=0)
    % un temps n'est pas entier
    [tobsmaj, tobsfactT,uniteT_pourcalcul, uniteT_pourcalcul_libelle] = convert_tps(tobs, uniteT);
    %maj l'unite de temps des donnees
%  le 5/12/2014     data=guidata(1);
%  le 5/12/2014     set(data.uniteT_tag, 'value', uniteT_pourcalcul);
    
else
    %on laisse les temps tels quels car ils sont entiers
    tobsmaj= tobs;
    tobsfactT=0; %indique qu'on n'a pas fait de conversion des temps lus
    uniteT_pourcalcul_libelle=uniteT_libelle;
    uniteT_pourcalcul = uniteT;
end %fin else



end % fin convert_tps_decimaux
%% ======================================================
function [tobsmaj, tobsfactT,uniteT_pourcalcul, uniteT_pourcalcul_libelle] = convert_tps(tobs, uniteT)
%convert_tps Convertit le temps, tobs, selon son unite
%  (1=jour, 2=heure, 3=minute)
% Si jour, on convertit en heure, si heure,  on convertit en minutes
% puis on arrondit à l'entier
% OUTPUT
% tobsmaj: les données transformées
% tobsfactT: facteur par lequel on a multiplié les temps lus
% pour qu'ils soient entiers
% uniteT_pourcalcul: code correspondant à l'unité de temps de tobsmaj
% uniteT_pourcalcul_libelle: texte correspondant

%% ======================================================
switch uniteT
    case 1
        % on convertit en heure
        uniteT_pourcalcul_libelle = 'hour';
        uniteT_pourcalcul=2;
        tobsfactT =24;
    case 2
        % on convertit en mns
        uniteT_pourcalcul_libelle = 'mn';
        uniteT_pourcalcul=3;
        tobsfactT = 60;
    case 3
        % on laisse en mns
        uniteT_pourcalcul_libelle = 'mn';
        uniteT_pourcalcul=3;
        tobsfactT = 1;
end;
tobsmaj= tobs*tobsfactT ;
tobsmaj= round(tobsmaj);

end %%fin convert_tps


