function modifier_estimer_CVs(obj,~)
%modifier_estimer_CVs Manage the event:  "Estimate CVs"
% FUNCTION
% Modify the structure Basemodeles of the selected model by taking into account 
% the fact that CVs should be added/removed among/from the parameters to be
% estimated and among/from the fixed parameters.
% INPUT
% The property 'value' of 'obj' is null when estimation of the CVs is to be removed
% and 1 when it is to be added.
% Second argument ignored
% OUTPUT
% The property 'value' of 'obj' is  set to null if failure
%% ======================================================
data=guidata(1);
if ~isfield(data, 'modelepop')
    errordlg('Please, select first the dynamics equation model', 'NO MODELE');
    set(obj,'value',0)
    return
end
modelepop=data.modelepop;
Basemodeles=data.Basemodeles;
CVs=data.CVs;

if get(obj,'value')
    %% on veut estimer des CVs
    % dans le cadre des paramètres des observations, on les rend non
    % modifiables
    for c=1:length(CVs.nomparamS)
        var=[CVs.nomparamS{c},'_tag'];
        set(data.(var),'string', '-' ,'enable','off');
    end
    
    % On rajoute les CVs à la liste des parametres
    for i=1:length(Basemodeles.nomparamP)
        Basemodeles.nomparamP{i}=[Basemodeles.nomparamP{i},CVs.nomparamS];
    end
else
    %% On ote l'estimation des CVs
    % dans le cadre des paramètres des observations, on les reinitialise
    for c=1:length(CVs.nomparamS)
        var=[CVs.nomparamS{c},'_tag'];
        set(data.(var),'string', CVs.valparamS{c},'enable','on');
    end
    % Oter les CVs de la liste des parametres à estimer
    for i=1:length(Basemodeles.nomparamP)
        nomparam={};
        k=1;
        nomparamM=Basemodeles.nomparamP{i};
        for j=1:length(nomparamM)
            if find(strcmpi(nomparamM{j},CVs.nomparamS))
                continue
            end
            nomparam{k}=nomparamM{j};
            k=k+1;
        end
        Basemodeles.nomparamP{i}=nomparam;
    end
    % Oter les CVs des parametres fixés
    for i=1:length(Basemodeles.nomparamS)
        nomparam={};
        k=1;
        nomparamM=Basemodeles.nomparamS{i};
        for j=1:length(nomparamM)
            if find(strcmpi(nomparamM{j},CVs.nomparamS))
                % detruire le tag qui indique que le parametre est fixe
                % pour ytheorique
                data=rmfield(data, [nomparamM{j} '_fixtag']);
                continue
            end
            nomparam{k}=nomparamM{j};
            k=k+1;
        end
        Basemodeles.nomparamS{i}=nomparam;
    end
    
end
data.Basemodeles=Basemodeles;
guidata(1,data)
if ~isempty(modelepop)
    s=find(strcmpi(Basemodeles.nom,modelepop));
    
    %% Modifier la liste des parametres du modele dans l'onglet qui permet de les fixer
    
    % On détruit le menu précédent
    
    delete(get(data.dynamique_tag,'children'));
    % *** Le menu qui permet de défixer des parametres fixes: ***
    nomparamfixes=data.Basemodeles.nomparamS{s};
    nomparamH = data.Basemodeles.nomparamH{s}; %parametres scotchés
    for i=1:length(nomparamfixes)
        if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
            % parametre fixe qu'on peut defixer
            uimenu(data.dynamique_tag,'Label',traduc_nom(nomparamfixes{i}),...
                'userdata', {nomparamfixes{i}},...
                'callback',@gestion_parametres,...
                'checked','off');
        end
    end
    
    % *** Le menu qui permet de fixer des parametres actifs:***
    nomparamactifs=data.Basemodeles.nomparamP{s};
    for i=1:length(nomparamactifs)
        uimenu(data.dynamique_tag, ...
'Label',traduc_nom(nomparamactifs{i}),...
'userdata',{nomparamactifs{i}},...
            'callback',@gestion_parametres,...
            'checked','on');
    end
    set(data.dynamique_tag,'visible','on');
    trace_modele(s, 2);
    
end
end  % fin modifier_estimer_CVs
%% ======================================================
