function  data=plot_dyn_obs(tag, data, ...
			    temps, vobs_or, pop,...
    logNbestime, ...
    Moyenne, ICInf, ICSup, nmod)
%plot_dyn_obs Plot estimated dynamics and data
% Function called when there is not stability study (no CI required)
% INPUT
% temps: les temps d'observations  dans l'unite de temps des données
% vobs_or: les temps de calcul dans l'unite de temps des données

%% ======================================================
% Mettre dans une structure 'filtrexplot' situé dans 'base'
% ce qui est nécessaire aux graphiques de façon à pouvoir
% les retracer si clic droit dessus
sauve_hp('filtrexplot',2,...
    'temps', temps, 'vobs_or', vobs_or, 'pop', pop, ...
     'logNbestime', logNbestime, ...
    'uniteT_libelle', data.uniteT_libelle, ...
    'modelepop', data.modelepop);


hp3=uipanel('parent',data.hpanel_work,...
    'BorderType', 'none', ...
    'tag',tag,...
    'BackgroundColor',[1 1 1],...
    'Position',[0 .02 1 0.98]);
if nargin == 10
    % comparaison de modeles
    
    if nmod==1
        quel='Numerator';
    else
        quel='Denominator';
    end
    titre=[ quel ' model: PLOTS OF FILTERING RESULTS '];
    hptitre= uipanel('parent',hp3,...
        'BackgroundColor',[1 1 1],...
        'BorderType', 'none', ...
        'Position', [0 0.965 1 0.035]);
 
    strnmod=num2str(nmod);
    
else
    strnmod='';
end


% Fixer les couleurs
couleur1='b'; % bleu pour le modèle
couleur2=[0 128 0]/255; %un vert pour la binf

% Tracé graphique dans le panel
subplot( 2,2,1,'parent',hp3); % creer 2X2 plots, se positionner sur le 1ier
if regexp(data.modelepop, 'Ln') ==1
    % la valeur du modele est un log népérien: on la remet en log10
    lespop= pop/log(10);
    laMoyenne=Moyenne(end,:)/log(10);
    leICInf=ICInf(end,:)/log(10);
    leICSup=ICSup(end,:)/log(10);
else
    if model_log10(data.modelepop)==1
  % la valeur du modele est log10(Nt)
        lespop= pop;
        laMoyenne=Moyenne(end,:);
        leICInf=ICInf(end,:);
        leICSup=ICSup(end,:);
    else
        lespop= log10(pop);
        laMoyenne=log10(Moyenne(end,:));
        leICInf=log10(ICInf(end,:));
        leICSup=log10(ICSup(end,:));
      % Ramener a des valeurs valides
      lespop(lespop<0) =0;
      laMoyenne(laMoyenne<0) =0;
      leICInf(leICInf<0) =0;
      leICSup(leICSup<0) =0;

    end
end

sauve_hp('filtrexplot',2,...
    'temps', temps, 'vobs_or', vobs_or, ...
    ['lespop' strnmod], lespop, ...
    ['laMoyenne' strnmod], laMoyenne, ...
    ['leICInf' strnmod], leICInf, ...
    ['leICSup' strnmod], leICSup, ...
    ['logNbestime' strnmod], logNbestime);

labelord='log10 (cfu/ml)';
plot(temps,lespop, 'Color', couleur1);

hold on
plot(temps,logNbestime,'ok')
hold off
title('FINAL FILTERING ESTIMATED DYNAMICS');
ylegend='data';

legend('estimated curve', ylegend,0,'location',[.5 .85 .12 .05])
ylabel(labelord)
xlabel(['time (' data.uniteT_libelle ')'])
set(gca,'buttondownfcn',{@dessin_hp3_1, strnmod});
subplot(2,2,3) % creer 2X2 plots, se positionner sur le 3ieme


plot(vobs_or,laMoyenne,'-', 'Color', couleur1);
hold on
plot(vobs_or,leICInf(end,:),'--', 'Color', couleur2);
plot(vobs_or,leICSup(end,:),'-.r')

hold on
plot(temps,logNbestime,'ok');
xlabel(['time (' data.uniteT_libelle ')'])
ylabel(labelord)
icniveau=get(data.iclevel_tag, 'value');
strniveau=get(data.iclevel_tag, 'String');
niveau=strrep(strniveau{icniveau},' ',''); %enlever les blancs

legend('mean', ...
    ['lower bound of the particle confidence interval (', niveau, ')'],...
    ['upper bound of the particle confidence interval (', niveau, ')'],...
    ylegend,0,...
    'location',[.5 0.35 .25 .05])
title('STEPWISE ESTIMATION OF THE STATE VALUE');
if nargin == 10
    hax= axes('Position', [0 0 1 1],'parent',hptitre, 'Visible', 'off');
    text(0.5, 0.08, titre, 'FontSize',12,'HorizontalAlignment','center', 'Parent', hax)
end

set(gca,'buttondownfcn',{@dessin_hp3_2, strnmod});
data.(tag) = hp3; % 29/1/2014, Matlab R2013a


end % plot_dyn_obs
%% ============================================================
function  dessin_hp3_1(obj, evt, strnmod)
% dessin_hp3_1
% Tracé graphique dans une fenêtre graphique Matlab du 1ier plot du panel hp3

%% ======================================================
%%
donnees = evalin('base', 'filtrexplot');
% Fixer les couleurs
couleur='b'; % bleu pour le modèle

hfig=figure('Name', 'Dynamique');
hax =   axes( 'parent', hfig);


  lespop= eval(['donnees.lespop' strnmod]);
  logNbestime=eval(['donnees.logNbestime' strnmod]);


labelord='log10 (cfu/ml)';
plot(hax, donnees.temps, lespop, 'Color', couleur);
hold on
plot(hax, donnees.temps, logNbestime,'ok');
title('FINAL FILTERING ESTIMATED DYNAMICS');
ylegend='data';

legend('estimated curve', ylegend,0);
%legend('estimation par le filtre', ylegend,0);
ylabel(labelord)
xlabel(['time (' donnees.uniteT_libelle ')'])
%%
end %  dessin_hp3_1
%% ===========================================================


function  dessin_hp3_2(obj, evt, strnmod)
% dessin_hp3_2
% Tracé graphique dans une fenêtre graphique Matlab du 2ieme plot du panel hp3

%% ======================================================
donnees = evalin('base', 'filtrexplot');
% Fixer les couleurs
couleur1='b'; % bleu pour le modèle 
couleur2=[0 128 0]/255; %un vert pour la binf
        labelord='log10 (cfu/ml)';



  laMoyenne= eval(['donnees.laMoyenne' strnmod]);
  leICInf=eval(['donnees.leICInf' strnmod]);
  leICSup=eval(['donnees.leICSup' strnmod]);
  logNbestime=eval(['donnees.logNbestime' strnmod]);
% vobs_or: les temps de calcul dans l'unite de temps des données
  vobs_or = donnees.vobs_or; 
% temps: les temps d'observations  dans l'unite de temps des données
  temps = donnees.temps;

hfig=figure('Name', 'Dynamique');
hax =   axes(  'parent', hfig);
plot(hax, ...
    vobs_or, laMoyenne,'-',...
    'Color', couleur1);
hold on
plot(hax, ...
    vobs_or, leICInf,'--',...
    'Color', couleur2)
hold on
 plot(hax, ...
     vobs_or, leICSup,'-.r')
hold on
plot(temps, logNbestime,'ok')
xlabel(['time (' donnees.uniteT_libelle ')'])
ylabel(labelord)
ylegend='data';
data=guidata(1);
icniveau=get(data.iclevel_tag, 'value');
strniveau=get(data.iclevel_tag, 'String');
niveau=strrep(strniveau{icniveau},' ',''); %enlever les blancs

legend('mean', ...
['lower bound of the particle confidence interval (', niveau, ')'],...
['upper bound of the particle confidence interval (', niveau, ')'],...
    ylegend,0)
title('STEPWISE ESTIMATION OF THE STATE VALUE');


% legend('Moyenne','Borne inf IC à 95%','Borne sup IC à 95%',ylegend,0)
% title('EVOLUTION DES ESTIMATIONS DE L''ÉTAT AU COURS DE L''UTILISATION DU FILTRE');

end %  dessin_hp3_2
