function data =  put_indices_panels (data, indice_panel, parent)
%put_indices_panels Display the panel number, indice_panel, at the bottom of the page
% as well as the characters '-' and '+' which allow swifting to the preceding and following panel
% INPUT
% indice_panel:  panel number
% parent:  parent of the current panel 

%% ======================================================



hnum=uicontrol('parent', parent,...
    'units','normalized',...
    'foregroundcolor',[.4 0 .2],...
    'position',[.49 0  .06 .02],...
    'tag','num_tab_tag',...
    'style','text') ;
set(hnum,'string',num2str(indice_panel))
data.tab_precedent_tag=uicontrol('parent', parent,...
    'units','normalized',...
    'position',[.43 0 .06 .02],...
    'string','-',...
    'tag','tab_precedent_tag',...
    'callback',@retrancher_tab,...
    'style','pushbutton');
data.tab_suivant_tag= uicontrol('parent', parent,...
   'units','normalized',...
   'position',[.55 0 .06 .02],...
      'string','+',...
     'callback',@ajouter_tab,...
      'tag','tab_suivant_tag',...
      'Visible', 'off', ...
     'style','pushbutton');

 % 29/1/2014, Matlab R2013a
data.indice_panel=indice_panel;
data.num_tab_tag=hnum;

end % fin put_indices_panels

