function fact = timemod2data(unite_param, unite_donnees, type)
% timemod2data renvoie le facteur qui permet de passer
% de l'unite de temps d'un param du modele à celle des données
% type indique si le param est fonction du temps ou de son inverse
%% =============================================
fact=1; %initialisation

%Savoir si le parametre est '1/time' ou 'time'
if isempty(regexp(type, '/'))
    hasslash=0;
else
    hasslash=1;
end

if ~isempty(strfind(unite_param, 'day'))
    % unite_param: day
    switch unite_donnees
        case 1
            fact=1;
        case 2
            %unite_donnees: hour
            if hasslash==1
                fact=1/24;
            else
                fact=24;
            end
        case 3
            %unite_donnees: mns
            if hasslash==1
                fact=1/(24*60);
            else
                fact=24*60;
            end
    end
    return;
end

if ~isempty(strfind(unite_param, 'hour'))
    % unite_param: hour
    switch unite_donnees
        case 1
            %unite_donnees: day
            if hasslash==1
                fact=24;
            else
                fact=1/24;
            end
        case 2
            fact=1;
        case 3
            %unite_donnees: mns
            if hasslash==1
                fact=1/(60);
            else
                fact=60;
            end
    end
    return;
end



if ~isempty(strfind(unite_param,  'mn'))
    % unite_param: mn
    switch unite_donnees
        case 1
            %unite_donnees: day
            if hasslash==1
                fact=24*60;
            else
                fact=1/(24*60);
            end
        case 2
            %unite_donnees: hour
            if hasslash==1
                fact=60;
            else
                fact=1/60;
            end
        case 3
            fact=1;
    end
    
end % fin if
end % fin timemod2data
