        

function data=trace_modele(s, opt )
% trace_modele Display a model, with default values of its parameters
% INPUT
% s: number of the model among all the available ones
% opt: optional.
%   - If set and equal to 1, the function is called to simulate
% data, all the parameters are then fixed, and their bounds are not to be
% displayed.
%   -     If set and equal to 2,   the function is called when Estimate CVs
%   is added or removed. Then, if parameters values are already displayed
%   in the panel, these values are left unchanged instead of reset to their
%   default values..
% NOTE Here, the user has no possibility to choice the type of parameters noise.
%  It is no visible and fixed at its default value.
%   To authorize the noise type choice again, uncomment the sentences
%   beginning by: % visible noise
% 29/1/14: add the output: data
%% ======================================================%======================================================
% les bornes a partir desquelles on écrit en notation exponentielle
valinf=-1000;
valsup=+1000;

data=guidata(1);
Basemodeles= data.Basemodeles;
data.modelepop=Basemodeles.nom{s};
%nomcourt est introduit en oct 2014 (nom abrégé du modèle)
if isfield(Basemodeles, 'nomcourt')
    data.shortmodel=Basemodeles.nomcourt{s};
else
    data.shortmodel=Basemodeles.nom{s};
end
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret
nomparamP=Basemodeles.nomparamP{s};
nomparamS=Basemodeles.nomparamS{s};
init=Basemodeles.init;
set(data.modele_tag,'string',{'',[data.modelepop ' MODEL']});
if (nargin >1) && (opt==2)
    % conserver les valeurs des paramètres affichées, s'il y en a déjà
    lepanel=stocke_panel(data, nomparamP, nomparamS, init);
end


if (nargin >1) && (opt==1)
    % Tous les paramètres sont fixés
    set(data.val_tag, 'visible','on')
    set(data.min_tag,'visible','off')
    set(data.max_tag,'visible','off')
    % visible noise:     try
    % visible noise:         set(data.bruit_tag,'visible','off')
    % visible noise:     end
else
    set(data.min_tag,'visible','on')
    set(data.max_tag,'visible','on')
    % visible noise:     try
    % visible noise:         set(data.bruit_tag,'visible','on')
    % visible noise:     end
end
pasy=1/8;
decal=0.02;
if length(nomparamS)+length(nomparamP)>7
    pasy=0.96/(length(nomparamS)+length(nomparamP));
end
delete(get(data.groupebutton30_tag,'children'))
delete(get(data.groupebutton31_tag,'children'))
delete(get(data.groupebutton32_tag,'children'))
delete(get(data.groupebutton33_tag,'children'))

%% l'unite de temps s'il y a des donnees
if isfield(data, 'tobs')
    uniteT= data.uniteT_pourcalcul;
end


%% Traitement des paramètres actifs
for i=1:length(nomparamP)
    % Pour la simulation des données, tous les param sont fixés, il faut donc
    % envisager le cas ou il n'y a pas de paramètres actifs
    iscv=0;
    if ~isempty(nomparamP{i})
        if isfield(data, 'CVs') && ...
                any(strcmpi(nomparamP{i}, data.CVs.nomparamS))
            % le parametre est un CV
            iscv=1;
            if isfield(data, [nomparamP{i} '_fixtag'])
                % le CV avait été précdemment fixé:
                % détruire le tag nomparamS_fixtag
                % (nécessaire pour ytheorique), qui indique que le CV est fixé
                data=rmfield(data, [nomparamP{i} '_fixtag']);
            end
            % maj sa valeur dans le panel du haut
            set(data.([nomparamP{i} '_tag']), 'string', '-', 'enable','off');
        end
        % Ecrire le nom du paramètre
        lastring=traduc_nom(nomparamP{i}, Basemodeles.type);
        letag=[nomparamP{i} '_txttag'];
        hd=uicontrol('parent',data.groupebutton30_tag,...
            'units','normalized',...
            'position',[0 .96-pasy*i 1 pasy],...
            'style','text',...
            'tag', letag, ...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
            'string', lastring);
        data.(letag)=hd;
        
        if iscv==1
            %  un CV
            minmaxdef= init.(nomparamP{i});
            valbornes=Basemodeles.DF.(nomparamP{i});
        else
            minmaxdef= init.(lemodele).(nomparamP{i});
            valbornes=Basemodeles.DF.(lemodele).(nomparamP{i});
            if isfield(data, 'tobs') && isfield(Basemodeles.type, nomparamP{i})
                % des donnees ont été lues: convertir les bornes du param selon leur unite de temps
                               
                fact=timemod2data(Basemodeles.unite.(nomparamP{i}),...
                    uniteT, ...
                    Basemodeles.type.(nomparamP{i}));
                a=str2double(minmaxdef{1})*fact;
                minmaxdef{1}=num2str(a);
                a=str2double(minmaxdef{2})*fact;
                minmaxdef{2}=num2str(a);
                a=str2double(valbornes{1})*fact;
                valbornes{1}=num2str(a);
                a=str2double(valbornes{2})*fact;
                valbornes{2}=num2str(a);
            end
            
            
            
        end
        
        % Ecrire son min
        var=[nomparamP{i},'min'];
        if (nargin>1) && (opt==2)
            data.(var) = lepanel.(var);
        else
            data.(var)=eval(minmaxdef{1});
        end
        tag=[var,'_tag'];
        hd=uicontrol('parent',data.groupebutton31_tag,...
            'units','normalized',...
            'position',[0 1-pasy*i 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
	     'userdata',{valbornes,traduc_nom(nomparamP{i})}, ...
            'style','edit');
         
        data.(tag)=hd; % Matlab2013a 29/1/14
        
        % ecrire les grosses ou petites valeurs en notation E
        if ischar(data.(var) )
            val=eval(data.(var) );
        else
            val=data.(var);
        end
        if val < valinf || val > valsup
            
            valstr=num2str(val, '%10.2e');
            set(hd,'string', valstr)
        else
            set(hd,'string',eval(['data.',var]))
        end
        
        % Ecrire son max
        var=[nomparamP{i},'max'];
        if (nargin>1) && (opt==2)
            data.(var) = lepanel.(var);
        else
            data.(var)=eval(minmaxdef{2});
        end
        tag=[var,'_tag'];
        hd=uicontrol('parent',data.groupebutton32_tag,...
            'units','normalized',...
            'position',[0 1-pasy*i 1 pasy],...
            'backgroundcolor','w',...
            'tag',tag,...
            'callback',@control_saisie,...
	     'userdata',{valbornes,traduc_nom(nomparamP{i})}, ...
            'style','edit');
        
        % ecrire les grosses ou petites valeurs en notation E
        if ischar(data.(var) )
            val=eval(data.(var) );
        else
            val=data.(var);
        end
        if val < valinf || val > valsup
            
            valstr=num2str(val, '%10.2e');
            set(hd,'string', valstr)
        else
            set(hd,'string',eval(['data.',var]))
        end
        data.(tag)=hd; % Matlab13a 29/1/14
        
        % Affecter  son bruit: on ne le fait pas apparaitre
        % dans cette version, toujours le bruit par défaut
        % visible noise: 'Visible', 'on', ...
        
        if isfield(data, 'bruit_tag')
            var=[nomparamP{i},'_bruit'];
            tag=[var,'_tag'];
            br=uicontrol('parent',data.groupebutton33_tag,...
                'Visible', 'off', ...
                'units','normalized',...
                'position',[0 1-decal-pasy*i 1 pasy-decal],...
                'tag',tag,...
                'backgroundcolor','w',...
                'style','popupmenu',...
                'string', '   Poisson|   Gaussian');
            %                'string', '   Poisson|   Gaussian|Binomial');
            if (nargin>1) && (opt==2)
                set(br,'value', lepanel.(var));
            else
                if isfield(data.Basemodeles, 'initbruit')
                    set(br,'value',data.Basemodeles.initbruit.(nomparamP{i}))
                end
            end
            data.(tag)=br; % Matlab13a 29/1/14
        end % fin isfield
    end % fin ~isempty
end % fin i

if isempty(i) || isempty(nomparamP{1})
    % pas de parametres actifs
    i=0;
    set(data.min_tag, 'visible', 'off');
    set(data.max_tag, 'visible', 'off');
else
    set(data.min_tag, 'visible', 'on');
    set(data.max_tag, 'visible', 'on');
end
%% Traitement des paramètres fixés
decal=0.04;
for j=1:length(nomparamS)
    if ~isempty(nomparamS{j})
        i=i+1; % incrémenter le déplacement vertical
        
        % Dans le cas de la simulation de stragégie opt, méthode Tornsey,
        % mettre une marque devant les parametres constants
        %(dans  le cas de la simulation de stragégie opt, méthode Tornsey, tous les paramètres sont assimilés à des parametres fixés pour l'affichage)
        letag= [nomparamS{j} '_fix_tornsey'];
        hd=uicontrol('parent',data.groupebutton30_tag,...
            'units','normalized',...
            'position',[0 1-pasy*i 0.1 pasy],...
            'style','text',...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
            'visible', 'off', ...
            'String', '**',...
            'tag', letag);
        data.(letag)=hd; % Matlab2013a 29/1/14
        % Traduction eventuelle du nom des CV
        lastring=traduc_nom(nomparamS{j}, Basemodeles.type);
        letag=[nomparamS{j} '_txttag'];
        
        hd=uicontrol('parent',data.groupebutton30_tag,...
            'units','normalized',...
            'position',[0 1-decal-pasy*i 1 pasy],...
            'style','text',...
            'tag', letag, ...
            'backgroundcolor',[1 1 1],...
            'foregroundcolor','k',...
            'string',lastring);
      
        data.(letag)=hd;
        
        % Ecrire sa valeur fixée
        if  isfield(data, 'CVs') && ...
                any(strcmpi(nomparamS{j}, data.CVs.nomparamS))
            % le parametre est un CV
            k=find(strcmp(data.CVs.nomparamS, nomparamS{j}),1);
            % mettre sa valeur dans un tag nomparamS_fixtag
            % (nécessaire pour ytheorique),
            %  nomparamS_tag étant le tag dans le panel des paramètres du modèle d'observations
            tag=[nomparamS{j} '_fixtag'];
            hd=uicontrol('parent',data.groupebutton31_tag,...
                'units','normalized',...
                'position',[0 1-pasy*i 2.02 pasy],...
                'backgroundcolor','w',...
                'userdata', {Basemodeles.DF.(nomparamS{j}), ...
                nomparamS{j}, data.CVs.valparamS{k}}, ...
                'callback',@fix_CV,...
                'tag', tag, ...
                'style','edit');
            data.(tag)=hd; % Matlab2013a 29/1/14
            if (nargin>1) && (opt==2)
                valeur=lepanel.(nomparamS{j});
            else
                valeur = data.CVs.valparamS{k};
                
            end
            data.(nomparamS{j})=valeur;
            % Maj de la valeur du CV dans le panel des paramètres du modèle d'observations            
            set(data.([nomparamS{j},'_tag']), 'string', valeur, 'enable', 'off');          
     
        else
            % le parametre n'est pas un CV
            
            
            valfix=Basemodeles.valparamS.(lemodele).(nomparamS{j});
            valbornes=Basemodeles.DF.(lemodele).(nomparamS{j});
 
            if  isfield(Basemodeles.type, nomparamS{j})
                if isfield(data, 'tobs') && ~isempty(data.tobs)
                    % des donnees ont été lues: convertir les bornes du param selon leur unite de temps
                    
                    fact=timemod2data(Basemodeles.unite.(nomparamS{j}),...
                        uniteT, ...
                        Basemodeles.type.(nomparamS{j}));
                    
                    a=str2double(valbornes{1})*fact;
                    valbornes{1}=num2str(a);
                    a=str2double(valbornes{2})*fact;
                    valbornes{2}=num2str(a);
                    valfix=valfix*fact;
                end
                % cas de la simulation de données: si l'utilisateur n'a pas
                % encore choisi l''unité de temps des données, mettre celle-ci automatiquement
                % dans celle des parametres du modele
                if (nargin >1) && (opt==1)
                    choixtemps = { 'day', 'hour', 'mn'};
                    val=0;
                    for itps=1:length(choixtemps)
                        val = get(data.(choixtemps{itps}), 'value');
                        if (val==1)
                            break; % sortir du for
                        end
                    end % fin for
                    if (val==0)
                        unite = Basemodeles.unite.(nomparamS{j});
                        set(data.(unite), 'Value', 1);
                        % maj le libelle de Maximal Time
                        set(data.obSmaxtxt_tag, 'String', ...
                            ['MAXIMAL TIME (' unite ' )']);
                        data.uniteT_pourcalcul_libelle=unite;
                        data.uniteT_libelle=unite;
                        set(data.uniteT_tag, 'Value', timelabel(unite));
                    end
                end % fin if (opt==1)
                
                
            end
            
            tag=[nomparamS{j},'_tag'];
            hd=uicontrol('parent',data.groupebutton31_tag,...
                'units','normalized',...
                'position',[0 1-pasy*i 2.02 pasy],...
                'backgroundcolor','w',...
                'tag',tag,...
	     'userdata',{valbornes,traduc_nom(nomparamS{j})}, ...
                'callback',@control_saisie,...
                'style','edit');
            data.(tag)=hd; % Matlab2013a 29/1/14
            
            if (nargin>1) && (opt==2)
                valeur=lepanel.(nomparamS{j});
            else
                valeur=valfix;
            end
        end
        
        
        if ischar(valeur)
            val=eval(valeur );
        else
            val=valeur;
        end
        
        
        if val < valinf || val > valsup
            
            valstr=num2str(val, '%10.2e');
            set(hd,'string', valstr)
        else
            set(hd,'string',valeur)
        end
        
        
        
        
        
    end %fin ~isempty
end % fin j

data.nomparam=nomparamP;
data.nomparamS=nomparamS;
data.nomparamH=Basemodeles.nomparamH{s};%%30/12

handles=guihandles;
ndata=catstruct(data,handles);
guidata(1,ndata);

end %fin trace_modele
%% ========================================================================
function [retour]=stocke_panel(data, nomparamP, nomparamS, init)
% stocke_panel
% Renvoie dans une structure les valeurs courantes, si elles existent
% dans le panel data, des paramètres, et si elles n'existent pas
% les val par défaut

%% ======================================================
lemodele=strrep(data.modelepop, '-',''); %le nom du modele sans tiret
for i=1:length(nomparamP)
    varmin=[nomparamP{i},'min'];
    varretmin = [varmin, '_tag'];
    varmax=[nomparamP{i},'max'];
    varretmax = [varmax, '_tag'];
    varbruit = [nomparamP{i},'_bruit'];
    varretbruit = [varbruit, '_tag'];
    try
        retour.(varmin)= get(data.(varretmin), 'string');
        retour.(varmax)= get(data.(varretmax), 'string');
        retour.(varbruit) = get(data.(varretbruit), 'value');
    catch
        if isempty(strfind(nomparamP{i},'CV'))
            % le parametre n'est pas un CV
            retour.(varmin)=eval(init.(lemodele).(nomparamP{i}){1});
            retour.(varmax)=eval(init.(lemodele).(nomparamP{i}){2});
        else
            retour.(varmin)=eval(init.(nomparamP{i}){1});
            retour.(varmax)=eval(init.(nomparamP{i}){2});
        end
        retour.(varbruit) = data.Basemodeles.initbruit.(nomparamP{i});
    end
end

for i=1:length(nomparamS)
    try
        varret= [nomparamS{i}, '_tag'];
        retour.(nomparamS{i})= get(data.(varret), 'string');
    catch
        if isempty(strfind(nomparamS{i},'CV'))
            % le parametre n'est pas un CV
            retour.(nomparamS{i})= data.Basemodeles.valparamS.(lemodele).(nomparamS{i});
        else
            retour.(nomparamS{i})= data.Basemodeles.valparamS.(nomparamS{i});
        end
    end
end


end % fin stocke_panel
