function lastring=traduc_nom(nom, type)
% traduc_nom English translation of the parameter name,
% and other cosmetics for display
  % type (fac.): unité de temps éventuelle du parametre
%% ======================================================%====================
lastring=nom;
if strcmp( nom, 'CVpesee')==1
    lastring='Weighting CV';
end
if strcmp( nom, 'CVpipetee')==1
    lastring='Pipetting CV';
end
if strcmp( nom, 'CVdiluant')==1
    lastring='Diluting CV';
end

% Transformation des log10: mettre l'argument entre parenthèses
lastring=regexprep(lastring, 'log10(.*)', 'log10\($1\)');
%idem pour les ln
lastring=regexprep(lastring, 'ln(.*)', 'ln\($1\)');

% Rajouter l'unité de temps éventuelle du parametre
if (nargin >1) && isfield(type, nom)
    % le param depend du temps
    data=guidata(1);
    if isfield(data, 'uniteT_pourcalcul_libelle')
        % des donnees ont ete rentrées: mettre dans l'unite des donnees
        % eventuellement transformées
        letype=transfo_unite(type.(nom), type.(nom), ...
            data.Basemodeles.unite.(nom),...
            data.uniteT_pourcalcul_libelle);      

    else
        letype = type.(nom);
    end
    lastring= [lastring '  ' letype];
end

end
