/*=================================================================
 * Modele Rosso en C et double precision
 * Pour la
 * Simulation de strategie optimale, version C
 * Voir BaranyiRoberts pour les E/S
 * COMPILATION sous matlab par: 
 * mex  /home/abouvier/MONFILTREX/v2013-1.0/SRC/SIMULATION_STRATEGIE/C/CRosso.c

 *============================================================*/
#include <math.h>
#include "mex.h"
double exp( double arg );


  /* ============================================================== */      

void  CRossoDP(double *param,  double * temps,
        double *valmin, double *valmax, double *rep,
         int ntemps, int N, int Ncur)
{

double mumax=(double) param[Ncur];
double lambda=(double) param[N+Ncur];
double N0= (double) param[2*N+Ncur];
double Nmax=(double) param[3*N+Ncur];
 double e1,den, ti;
 int i, ind;

 for ( i=0; i< ntemps; i++) {
   ti=temps[i];
   if (ti <= lambda) {
     rep[N*i+Ncur]=N0;
   } else {
   e1= -mumax *  (ti-lambda);
   if (e1>100) {
     e1=100;
   }
  den= (1+((Nmax/N0)-1)*exp(e1));
  ind=N*i+Ncur;
  rep[ind]=Nmax/den;
 /* Ramener dans les bornes les réponses invalides */
    if (rep[ind] < (*valmin)) {
      rep[ind]=(double)(*valmin);
    }
    if (rep[ind] > (*valmax)) {
      rep[ind]=(double)(*valmax);
    }
   }
     
 } /* fin i */


}
/* ============================================================== */
void CRosso(double *param,  double *temps, 
        double *valmin, double *valmax,
        double *rep,
   int ntemps, int N)
{

    /* boucle sur l'appel à RossoDP */
    int u;
    for (u=0; u<N; u++) {
        CRossoDP( param, temps, valmin, valmax, rep, ntemps, N, u);
    }

}

/* ================================================== */
/* The gateway function:
INPUT
nlhs: le nombre de sorties (la fonction a pls sorties quand
 l'utilisateur affecte une structure à pls composants
 à son appel a CRosso)
plhs: les sorties
nrhs: le nombre d'arguments d'entrée
prhs: les arguments d'entrée
 */
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double *rep, *param, *temps, *valmin, *valmax;
  int N, ntemps;

  

/* The first input argument param is Nx4 */
  N = (int) mxGetM(prhs[0]);
 
 /* VERIF AU CAS OU: param must have 4 columns 
if(mxGetN(prhs[0])!=4) {
    mexErrMsgIdAndTxt("Rosso:notRowVector",
                      "Input param must have 4 columns.");
}
 */
  
/* create a pointer to the  input   */
param = mxGetPr(prhs[0]);

/* Second input argument: times is 1 x ntemps */
ntemps = (int) mxGetN(prhs[1]);

temps=mxGetPr(prhs[1]);


 /* Third input argument:valmin */
    valmin=(double *)mxGetPr(prhs[2]);
 /* Fourth input argument:valmax */
    valmax=(double *)mxGetPr(prhs[3]);
/* 5th input argument: result matrix */
    rep = (double *)mxGetPr(prhs[4]);


/* create the output matrix 
 plhs[0] = mxCreateDoubleMatrix((mwSize)N,(mwSize)ntemps,mxREAL);
rep = mxGetPr(plhs[0]);
*/

/* call the computational routine */
 CRosso( param, temps,valmin, valmax,  rep,(int)ntemps, (int)N);

} 
