function main_strategysim(obj,evnt)
%main_strategysim Pilot the task SIMULATION OF AN OPTIMAL SEQUENTIAL SEQUENTIAL SAMPLING
% INPUT
% 'obj' and 'evnt' are ignored, except in the non-interactive mode, i.e
% when a series of tests is run in non-interactive mode.
% In this case, 'evnt' is the name of a file which contains the results
% of a previous execution.
%% ======================================================
global input_error;
input_error=[];
% les fieldnames de cette structure seront les tags des panels où control_saisie a trouvé une erreur


%% creation de la figure principale
h=figure('units','normalized',...
    'color',[1 1 1],...
    'position',[.1 .1 .8 .8],...
    'numbertitle','off',...
    'menubar','none',...
    'resize','off',...
    'tag','interface',...
    'keypressfcn',@raccourci_clavier);

if nargin ==0
    % mode interactif
    set(h,    'CloseRequestFcn',@my_closereq, ...
    'userdata', {'simulation of an optimal sequential sampling', '1'});
else
    set(h,    'CloseRequestFcn',@batch_closereq);
end

% figure en plein ecran
maximize
% titre de la figure
% par defaut: Sobol
set(h, 'Name', ['FILTREX: SIMULATION OF AN OPTIMAL SEQUENTIAL SAMPLING' ...
    ' BY SOBOL-SALTELLI METHOD']);
% menus  en haut

% Pour centrer au-dessus du hpanel_control
for i=1:3
    uimenu(  'Label','      ');    
end
% choix du modele
edit = uimenu('Label','Dynamics');
uimenu(edit,'Label','Model equation',...
    'Accelerator','D',...
    'Callback',@dynamique_strat)
uimenu(edit,'Label','Fix/unfix parameters',...
    'tag','dynamique_tag',...
    'visible','off');
uimenu(edit,'Label','Set parameters to the maximal range', ...
    'tag', 'plagesmax_tag', ...
    'Callback',@plagesmax_mod, ...
    'visible','off');
uimenu(edit, 'Label', 'Reset parameters to default values', ...
       'tag', 'resetmod_tag', ...
       'Visible', 'off', ...
    'Callback',@reinit_mod_sim);
uimenu(edit,'Label','Help about model equations', ...
   'Separator','on',...
   'Callback',@help_dynamics);


% choix du fichier des observations (pour sivip uniquement)
uimenu('Label','Data',...
    'Interruptible','off',...
    'Visible', 'off',  ...
    'tag', 'fichier_tag', ...
    'Accelerator','O',...
    'Callback',@opensimulated);

% Reinitialisation
raz = uimenu('Label','Reset to default values');
uimenu(raz, 'Label', 'Simulation parameters', ...
    'Callback',@reinit_param_sim );
uimenu(raz, 'Label', 'Dynamics parameters', ...
       'tag', 'resetdparam_tag', ...
       'Visible', 'off', ...
    'Callback',@reinit_mod_sim);
uimenu(raz, 'Label', 'Filter parameters', ...
    'Callback',@reinit_filtre, ...
    'tag', 'reinit_filtre_tag', ...
    'Visible', 'off');
uimenu(raz, 'Label', 'CVs', ...
    'Callback',@reinit_CV_sivip, ...
    'tag', 'reinit_CV_sivip_tag', ...
    'Visible', 'off');
uimenu(raz, 'Label', 'All', ...
    'Accelerator','Z',...
    'Callback',@reinit_tout);

% sauvegarde/restauration
sauver=uimenu('Label','Save project/optimal times');
uimenu(sauver, 'Label','The entire project',...
    'Accelerator','S',...
    'Callback',@saveStrat);
uimenu(sauver, 'Label','Optimal times in a Matlab file (.mat)',...
    'Callback',@saveOptimaMat);
uimenu(sauver, 'Label','Optimal times in an Excel file',...
    'Callback',@saveOptimaFic);

uimenu('Label','Restore project',...
    'Separator','on',...
    'Accelerator','R',...
    'Callback',@restore_strategie);

% Infos
helpm=uimenu('Label','Help');
uimenu(helpm, 'Label','Pratical Tips',...
    'Callback',@filtrexStrategieopthelp,...
    'Accelerator','H');
uimenu(helpm, 'Label','Help about model equations', ...
   'Separator','on',...
   'Callback',@help_dynamics);

uimenu('Label','About',...
    'callback',@about);

%menus de sortie
uimenu('Label','Return to menu',...
    'Interruptible','off',...
    'userdata', {'' '2'}, ...
    'Callback',@my_closereq, ...
    'Separator','on');
uimenu('Label','Quit task',...
    'Interruptible','off',...
    'userdata', {'' '1'}, ...
    'Callback',@my_closereq, ...
    'Separator','on');
uimenu('Label','Quit FILTREX',...
    'Interruptible','off',...
    'Callback','delete(gcf)',...
    'Separator','on');
uimenu('Label','Quit Matlab',...
    'Interruptible','off',...
    'BusyAction','cancel',...
    'Callback','exit',...
    'Separator','on',...
    'Accelerator','Q');
%% fin des menus du haut




[data, hpanel_control]=creer_control();
% sauvegarde du panel de controle
data.hpanel_control= hpanel_control;


%% Panel des sorties
hpanel_work=creer_work();


%% sauvegarde des identificateurs des composantes graphiques
% dans la structure handles
handles=guihandles(1);
% concatenation des deux structures handles et data
data=catstruct(handles,data);

% sauvegarde du panel d'affichage des resultats
data.hpanel_work=hpanel_work;
% sauvegarde du panel de controle
data.hpanel_control= hpanel_control;


% mise à jour de la structure principale data
guidata(1,data);


% cas non interactif: charger un fichier de sauvegarde pour le faire
% réexecuter

if nargin>0
    restore_strategie(obj,evnt);
    % Execution si on a chargé un test
       
hgo= uicontrol('parent',hpanel_control,...
    'units','normalized',...
    'position',[ 0.92 0 0.08 0.05],...
    'FontUnits', 'normalized', ...
    'FontSize', 0.3, ...
    'interruptible','on',...
    'backgroundcolor','r',...
    'BusyAction','cancel',...
    'tag','estimation_tag',...
    'Style','pushbutton',...
    'String','GO',...
    'userdata',{1},...
    'callback',@STRATEGIEOPT);

STRATEGIEOPT(hgo,1);
end


end %% fin FILTRE
%% ======================================================
function hpanel_work=creer_work()
%creer_work creer le panel des sorties
%% ======================================================
hpanel_work=uipanel('FontSize',30,...
    'borderWidth',3,...
    'BackgroundColor',[1 1 1],...
    'Position',[.45 .05 0.5 .92]);

end % fin creer_work

%% ======================================================
function [data, hpanel_control]=creer_control() 
%creer_control creer le panel des entrées
%% ======================================================
bgcolor = [0.95 0.95 0.95 ];

% preparation du panel pour les entrées
hpanel_control=uipanel('FontSize',30,...
    'borderWidth',3,...
   'BackgroundColor',[1 1 1],...
    'Position',[.05 .05 0.4 .92]);


groupebutton2 = uibuttongroup('Parent',hpanel_control,...
    'backgroundcolor', bgcolor,...
    'Position',[0 .8 1 .2]);

% largeur des colonnes de texte
wcol1=0.15;

data.groupebutton23_tag = uibuttongroup('Parent',groupebutton2,...
    'backgroundcolor', bgcolor,...
    'Position',[0 .7 wcol1 .3], 'tag', 'groupebutton23_tag');

data.groupebutton24_tag = uibuttongroup('Parent',groupebutton2,...
    'Position',[wcol1 .7 (1-wcol1) .3], 'tag', 'groupebutton24_tag');


% Pour les parametres de simulation spécifiques aux méthodes
groupebuttonspec= uibuttongroup('Parent',groupebutton2,...
    'backgroundcolor', bgcolor, ...
    'Position',[0 0 wcol1 0.7]);
% le uicontrol doit etre legerement moins large que le uibuttongroup
% qui le contient pour qu'on voit les borderlines de ce dernier
%    'position',[0 0.4 wcol1-0.01 0.3],...
uicontrol('parent',groupebuttonspec,...
    'units','normalized',...
    'position',[0 0 1 0.6],...
    'foregroundcolor', 'k',...
    'backgroundcolor',bgcolor,...
    'style','text',...
    'string',{'SIMULATION',  'PARAMETERS'});
data.groupebuttonmeth_tag=uibuttongroup('Parent',groupebutton2,...
    'units','normalized',...
    'tag', 'groupebuttonmeth_tag', ...
    'position',[wcol1 0 1-wcol1 0.7],...
    'foregroundcolor', 'k',...
    'backgroundcolor', bgcolor);

%% les parametres du modele d'observations et du filtre pour sivip
% On rajoute un peu a la hauteur pour que les cadres joignent bien
data.groupesivip_tag=uibuttongroup('Parent',hpanel_control,...
    'Visible', 'off', ...
    'backgroundcolor', bgcolor,...
    'tag', 'groupesivip_tag', ...
    'Position',[0 .6 1 .205]);
hauteur=1;
%% les parametres du modele d'observations
% Un groupe pour encadrer le titre
groupeobsstr=uibuttongroup('Parent',data.groupesivip_tag,...
    'backgroundcolor',bgcolor,...
    'Position',[0 0 wcol1 1]);

uicontrol('parent',groupeobsstr, ...
    'tag', 'paraobs_tag', ...
    'backgroundcolor',bgcolor,...
    'units','normalized',...
    'style','text', ...
    'String', {'OBSERVATION', 'MODEL', 'PARAMETERS'}, ...
    'Position',[0 0 1 0.65]);

%largeur de 21s et 22s
% Les filter parameters commencent a 0.45
l21s=(0.45-wcol1)/2;
data.groupebutton21s_tag = uibuttongroup('Parent',data.groupesivip_tag,...
    'tag', 'groupebutton21s_tag', ...
    'Visible', 'off', ...
    'Position',[wcol1 0 l21s hauteur]);
uicontrol('parent',data.groupebutton21s_tag,...
    'units','normalized',...
    'backgroundcolor', bgcolor,...
    'Visible', 'off', ...
    'position',[0 0 1 1],...
    'style','text');
data.groupebutton22s_tag = uibuttongroup('Parent',data.groupesivip_tag,...
    'tag', 'groupebutton22s_tag', ...
    'Visible', 'off', ...
    'Position',[(wcol1+l21s) 0 l21s hauteur]);
uicontrol('parent',data.groupebutton22s_tag,...
    'units','normalized',...
    'backgroundcolor', bgcolor,...
    'position',[0 0 1 1],...
    'style','text');
%% les parametres du filtre
% un groupe pour faire un cadre autour du titre
groupefilterstr=uibuttongroup('Parent',data.groupesivip_tag,...
    'backgroundcolor',bgcolor,...
    'Position',[.45 0  wcol1 1]);

uicontrol('parent',groupefilterstr, ...
    'tag', 'parafilter_tag', ...
    'backgroundcolor',bgcolor,...
    'units','normalized',...
    'style','text', ...
    'String', {'FILTER', 'PARAMETERS'}, ...
    'Position',[0 0  1 0.6]);


l24s=l21s; % largeur des cases editables
l23s=1-2*(wcol1+l21s)-l24s;
data.groupebutton23s_tag = uibuttongroup('Parent',data.groupesivip_tag,...
    'tag', 'groupebutton23s_tag', ...
    'Visible', 'off', ...
    'backgroundcolor',bgcolor,...
    'Position',[2*(wcol1+l21s) 0 l23s hauteur]);

uicontrol('parent',data.groupebutton23s_tag,...
    'units','normalized',...
    'position',[0 0 1 1],...
    'Visible', 'off', ...
    'backgroundcolor',bgcolor,...
    'style','text');
data.groupebutton24s_tag = uibuttongroup('Parent',data.groupesivip_tag,...
    'tag', 'groupebutton24s_tag', ...
    'Visible', 'off', ...
    'backgroundcolor', bgcolor,...
    'Position',[2*(wcol1+l21s)+ l23s 0 l24s hauteur]);
uicontrol('parent',data.groupebutton24s_tag, ...
    'units','normalized',...
    'position',[0 0 1 1],...
    'backgroundcolor', bgcolor,...
    'style','text');

%% le reste des entrees methodes 1 (sobol) et 2 (tornsey)
data.groupebuttonreste_tag = uibuttongroup('Parent',hpanel_control,...
    'Position',[0 0 1 .75],...
    'BorderType', 'none', ...
    'units','normalized',...
    'fontsize',15,...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0], ...
    'tag','groupebuttonreste_tag');
%% le reste des entrees methode 3 (sivip)
data.groupebuttonrestes_tag = uibuttongroup('Parent',hpanel_control,...
    'Position',[0 0 1 .55],...
    'Visible', 'off', ...
    'BorderType', 'none', ...
    'units','normalized',...
    'fontsize',15,...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0], ...
    'tag','groupebuttonrestes_tag');

% les entrees des methodes 1 (sobol) et 2 (tornsey)
data.groupebutton3_tag = uibuttongroup('Parent',data.groupebuttonreste_tag,...
    'Position',[0 0 1 1],...
    'BorderType', 'none', ...
    'units','normalized',...
    'fontsize',15,...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0], ...
    'tag','groupebutton3_tag');
% les entrees de la methode sivip
data.groupebutton3sivip_tag = uibuttongroup('Parent',data.groupebuttonrestes_tag,...
    'Position',[0 0 1 1],...
    'BorderType', 'none', ...
    'units','normalized',...
    'fontsize',15,...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0], ...
    'tag','groupebutton3sivip_tag');

% Pour ecrire le nom du fichier quand restauration sobol ou tornsey
% ou toujours quand sivip
data.fichier_fic_tag=uibuttongroup('Parent',hpanel_control, ...
    'visible', 'on', ...
    'backgroundcolor', 'w', ...
    'BorderType', 'none', ...
    'tag','fichier_fic_tag',...
    'Position',[0 .75 1 .05]);

data.fichier_nofic_tag=uibuttongroup('Parent',hpanel_control, ...
    'backgroundcolor', 'w', ...
    'BorderType', 'none', ...
    'visible', 'on', ...
    'tag','fichier_nofic_tag',...
    'Position',[0 .75 1 .05]);

% Il y a 2 uicontrol avec 'NO DATA' car l'un est fixe, l'autre sera
% modifié 
data.fichier_type_tag=uicontrol('parent',data.fichier_fic_tag,...
    'units','normalized',...
    'fontsize',10,...
    'position',[0 0 1 1],...
    'backgroundcolor', bgcolor,...
    'style','edit',...
    'tag', 'fichier_type_tag', ...
    'visible', 'off', ...
    'string','NO DATA');
data.fichier_no_tag = uicontrol('parent',data.fichier_fic_tag,...
    'units','normalized',...
    'fontsize',10,...
    'position',[0 0 1 1],...
    'style','edit',...
    'tag','fichier_no_tag',...
    'backgroundcolor',bgcolor,...
    'visible', 'off', ...
    'string','NO DATA');
% Pour ecrire le nom du fichier de données
data.fichier_chemin_tag = uicontrol('parent',data.fichier_fic_tag,...
    'units','normalized',...
    'position',[0 0.5 1 0.5],...
    'FontSize', 10, ...
    'style', 'edit', ...
    'tag','fichier_chemin_tag',...
    'backgroundcolor',bgcolor,...
    'visible', 'off');
% Pour ecrire le nombre d'obs et repet des données
data.fichier_descr_tag=uicontrol('parent',data.fichier_fic_tag,...
    'units','normalized',...
    'position',[0 0 1 0.5],...
    'FontSize', 10, ...
    'style','edit',...
    'tag','fichier_descr_tag',...
    'backgroundcolor',bgcolor,...
    'visible', 'off');

% la case qui permet de faire le graphe des donnees lues
chart_line_icon=imread('SRC/IMG/chart_line.jpg', 'jpg');
data.plotdata_tag=uicontrol('parent',data.fichier_fic_tag,...
    'units','normalized',...
    'position',[0.94 0.2 0.025  .55],...
    'style','pushbutton', ...
    'tag','plotdata_tag', ...
    'visible', 'off', ...
    'enable', 'on', ...
    'cdata', chart_line_icon, ...
    'callback', @plot_obs, ...
    'ButtonDownFcn', @plot_obs);
%% ------------------------------------
% Cas non sivip: pour ecrire le modele et ses parametres
hteur=0.85;
lebas0=0.05;

% le nom du modele:
data.modele_tag=uicontrol('Parent',data.groupebutton3_tag,...
    'units','normalized',...
    'fontsize',15,...
    'position',[0.09 hteur+0.13 0.85 0.05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0], ...
    'tag','modele_tag');

data.groupebutton30_tag=uibuttongroup('Parent',data.groupebutton3_tag,...
    'Position',[.15 lebas0 .2 hteur],...
    'backgroundcolor',[1 1 1],...
    'BorderType', 'none', ...
    'tag','groupebutton30_tag');


data.min_tag=uicontrol('parent',data.groupebutton3_tag,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.37 hteur+lebas0 .12 .05],...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'style','text',...
    'string','MIN',...
    'tag','min_tag',...
    'visible','off');

data.groupebutton31_tag=uibuttongroup('Parent',data.groupebutton3_tag,...
    'Position',[.35 lebas0 .15 hteur],...
    'backgroundcolor',[1 1 1],...
    'BorderType', 'none', ...
    'tag','groupebutton31_tag');

data.max_tag=uicontrol('parent',data.groupebutton3_tag,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.5 hteur+lebas0 .12 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','MAX',...
    'tag','max_tag',...
    'visible','off');


data.groupebutton32_tag=uibuttongroup('Parent',data.groupebutton3_tag,...
    'BorderType', 'none', ...
    'Position',[.5 lebas0 .15 hteur],...
    'backgroundcolor',[1 1 1],...
    'tag','groupebutton32_tag');

data.groupebutton33_tag=uibuttongroup('Parent',data.groupebutton3_tag,...
    'BorderType', 'none', ...
    'Position',[.7 lebas0 .3 hteur],...
    'backgroundcolor',[1 1 1],...
    'tag','groupebutton33_tag');

%% -------------------------------------------------
%% Cas sivip: pour ecrire le modele et ses parametres
% le nom du modele:
data.modeles_tag=uicontrol('Parent',data.groupebutton3sivip_tag,...
    'units','normalized',...
    'fontsize',15,...
    'position',[0.09 0.88 0.85 0.07],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor',[0 0 0], ...
    'tag','modeles_tag');

% le nom du parametre
data.groupebutton30s_tag=uibuttongroup('Parent',data.groupebutton3sivip_tag,...
    'Position',[.15 0 .22 .75],...
    'backgroundcolor',[1 1 1],...
    'BorderType', 'none', ...
    'tag','groupebutton30s_tag');


data.mins_tag=uicontrol('parent',data.groupebutton3sivip_tag,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.37 .75 .12 .05],...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'style','text',...
    'string','MIN',...
    'tag','mins_tag',...
    'visible','off');
largeur=0.15;

data.groupebutton31s_tag=uibuttongroup('Parent',data.groupebutton3sivip_tag,...
    'Position',[.35 0 largeur .75],...
    'backgroundcolor',[1 1 1],...
    'BorderType', 'none', ...
    'tag','groupebutton31s_tag');

data.maxs_tag=uicontrol('parent',data.groupebutton3sivip_tag,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.5 .75 .12 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','MAX',...
    'tag','maxs_tag',...
    'visible','off');
data.groupebutton32s_tag=uibuttongroup('Parent',data.groupebutton3sivip_tag,...
    'BorderType', 'none', ...
    'Position',[.35+largeur 0 largeur .75],...
    'backgroundcolor',[1 1 1],...
    'tag','groupebutton32s_tag');

%le bruit
% dans cette version, il est non visible: il est fixé a la valeur par défaut
% On garde les uicontrol au cas ou on voudrait le remettre

data.bruits_tag=uicontrol('parent',data.groupebutton3sivip_tag,...
    'units','normalized',...
    'fontsize',10,...
    'position',[.65 .75 .15 .05],...
    'style','text',...
    'backgroundcolor',[1 1 1],...
    'foregroundcolor','k',...
    'string','NOISE TYPE',...
    'tag','bruits_tag',...
    'visible','off');

data.groupebutton33s_tag=uibuttongroup('Parent',data.groupebutton3sivip_tag,...
    'BorderType', 'none', ...
    'Position',[.35+2*largeur 0 largeur .75],...
    'backgroundcolor',[1 1 1],...
    'tag','groupebutton33s_tag');

%% ---------------------------
%% les uicontrol ignorés mais nécessaires pour pouvoir utiliser les programmes communs à Estimation
uicontrol('parent',groupebutton2,...
    'units','normalized',...
    'foregroundcolor',[.4 .5 .6],...
    'position',[0 .17 .4 .1],...
    'backgroundcolor',[1 1 1],...
    'style','checkbox',...
    'tag','cvinparam_tag',...
    'callback',@modifier_estimer_CVs,...
    'string','ESTIMATE CV', ...
    'visible', 'off', ...
    'Value', 0);
uicontrol('parent',groupebutton2,...
    'units','normalized',...
    'foregroundcolor',[.4 .5 .6],...
    'position',[0.2 .17 .5 .1],...
    'backgroundcolor',[1 1 1],...
    'style','checkbox',...
    'tag','etude_stab_tag',...
    'callback',@etude_stabilite,...
    'string','STABILITY STUDY', ...
    'visible', 'off', ...
    'Value', 0);

%% -----------------------------------------

data.hgo= uicontrol('parent',hpanel_control,...
    'units','normalized',...
    'position',[ 0.92 0 0.08 0.05],...
    'FontUnits', 'normalized', ...
    'FontSize', 0.3, ...
    'interruptible','on',...
    'backgroundcolor','r',...
    'BusyAction','cancel',...
    'tag','estimation_tag',...
    'Style','pushbutton',...
    'String','GO',...
    'userdata', 0, ...
    'BusyAction', 'cancel', ...
        'callback',@STRATEGIEOPT);

data=init_strategie_opt(data, bgcolor);
%  Init des variables de modele
data.modelepop={};
data.nomparamP={}; data.nomparamS={};

data.hpanel_control=hpanel_control;


end  % fin creer_control

%% ======================================================


function[data]= init_strategie_opt( data,  bgcolor)
%init_strategie_opt Initialisation du panel des entrees relatif aux
%parametres de simulation
% ajout  dans data
% INPUT
% Les panels des entrées
% La couleur des panels des entrées
%% ======================================================

data.Simul = init_Simul();

% calcul de la hauteur des cases des cadres pour la methode par defaut
% (1=sobol)
[ hautcasecommun, bgcolor]=taille_cadre(data.Simul, 1);
%% Bouton help pour le choix de la methode
help_icon = imread('SRC/IMG/help.jpg', 'jpg');

% construction des parametres de simulation communs aux methodes
i=1; % il n'y a plus que la methode en commun
var = data.Simul.nomparam0{i};
data.(var) = data.Simul.valparam0{i};
tag=[var,'_tag'];
uicontrol('parent', data.groupebutton23_tag,...
    'units','normalized',...
    'foregroundcolor',[.4 0 .2],...
    'backgroundcolor',bgcolor,...
    'position',[0 0.45  1 0.4 ],...
    'style','text',...
    'string',data.Simul.chaines0{i});

% le bouton d'aide
uicontrol('parent', data.groupebutton23_tag,...
    'units','normalized',...
    'style', 'pushbutton', ...
    'position',[0.45 0.1 0.1 0.32],...
    'cdata', help_icon, ...
    'enable', 'inactive', ...
    'backgroundcolor', 'w', ...
    'ButtonDownFcn', @help_method);

hd=uicontrol('parent', data.groupebutton24_tag,...
    'units','normalized',...
    'position',[0 1-hautcasecommun*i 1 hautcasecommun],...
    'backgroundcolor','w',...
    'tag',tag, ...
    'string', ' SOBOL-SALTELLI | D-OPTIMAL DESIGN | SIVIP ', ...
    'style','listbox', ...
    'Min', 1, 'Max',1, ...
    'callback',@maj_methode, ...
    'value', 1);


% construction des parametres de simulation de la methode par defaut
% (sobol)
data.methode=1;
data.nommethode='Sobol';

data= init_strategie_meth(data.methode, data,  bgcolor);
data.(tag) = hd; % matlab2013a

end % fonction init_strategie_opt
%% ======================================================

function raccourci_clavier(~,event)

%% ======================================================
if strcmpi(event.Key,'return')
    STRATEGIEOPT()
end
end
%% ======================================================
function [dataout,  indice_panel, err]= go_sobol(data, obj, evnt)
%go_sobol Lancer la méthode Sobol
%% ======================================================
%% initialisation des sorties
dataout=data;
indice_panel=0;
err=0;

%% autres intialisations
methodecur=1; %sobol


%% Récupération des parametres de simulation spécifiques à Sobol:
% graineAleaS, LHS, seuil, etc
lesvar = data.Simul.nomparamD{methodecur};
for i=1:length(lesvar)
    if strcmp(lesvar{i}, 'graineAleaS')
        %%  recuperation de la valeur de la graine aleatoire
        data.graineAleaS=get(data.graineAleaS_tag,'string');
    else
        lacase = get(data.([lesvar{i} '_tag']), 'String');
        data.(lesvar{i})= str2double(lacase);
        if isempty(data.(lesvar{i})) || isnan(data.(lesvar{i})) 
            errordlg(['Bad entry value: enter a numerical value for ' ...
data.Simul.chaines{methodecur}{i}])
            err=1;
            return
        end
    end
end


%% Verifier que le pas de temps < temps max
if data.stepsobol >= data.tempsmaxsobol
    errordlg([' TIME STEP ', num2str(data.stepsobol), ' should be less than the  maximal time ', ...
        num2str(data.tempsmaxsobol)]);
    err=1;
    return
end
 

%% recuperation des valeurs des plages des parametres du modele
try
    [data.binf, data.bsup, nf, nomparamP, nomparamS, nomorP, nomorS, err] =recup_param_strat(data);
    if err>0
        set(obj,'interruptible','on','userdata',0,'string','GO')
        Idle(1)
        errordlg(['Error number ' num2str(err), ' while getting model parameters ']);
        return
    end
catch
    set(obj,'interruptible','on','userdata',0,'string','GO')
    errordlg('Error while getting model parameters ');
    Idle(1)
    return
end
meth=1; % on genere le lhd en triant des pseudorandom integer values et non par sobolset
%% On y va
nomparam=[nomorP nomorS]; % ordre des colonnes des matrices créées
% recupérer l'unité de temps des param pour l'afficher
data= recup_temps(data, nomparam, data.Basemodeles.type);

[IST, errIST, optima, optimaP,  titregraphe, soustitre, indice_panel]= calcStrategieOptSobolDP( ...
    data.LHS, data.tempsmaxsobol,data.stepsobol,  nf,...
    data.graineAleaS, data.binf, data.bsup, ...
    data.modelepop,  nomparam, nomparamP, nomparamS,...
    data.uniteT_libelle, ...
    data.seuilsobol, meth, data.hpanel_work, obj, evnt);



%% Completion du data par ce qui est nécessaire a sauvegarde/restauration
% Mettre l'indice de la méthode
data.methode=methodecur;
data.nommethode='Sobol';
data.titregraphe= titregraphe;
data.soustitre=soustitre;
data.nomparamP=nomparamP;
data.nomparamS=nomparamS;
data.IST=IST;
data.optima=optima;
data.optimaP=optimaP;

dataout=data;
end % fin go_sobol



%% ======================================================
function [dataout, indice_panel, err]= go_tornsey(data, obj, evnt)
%go_tornsey Lancer la méthode Tornsey
% evnt=1 quand on fait passer des tests
%% ======================================================
%% initialisation des sorties
dataout=data;
indice_panel=0;


%% autres intialisations
methodecur=2;  %Tornsey

%% Récupération des parametres de simulation spécifiques à Tornsey:

lesvar = data.Simul.nomparamD{methodecur};
for i=1:length(lesvar)
     lacase = get(data.([lesvar{i} '_tag']), 'String');
        data.(lesvar{i})= str2double(lacase);
        if isempty(data.(lesvar{i})) || isnan(data.(lesvar{i}))
            errordlg(['Bad entry value: enter a numerical value for ' ...
data.Simul.chaines{methodecur}{i}])
            err=1;
            return
        end
end


%% recuperation des valeurs  des parametres du modele
try
    [data.binf, data.bsup, nf, nomparamP, nomparamS, nomorP, nomorS,  err] =recup_param_strat(data);
    if err>0
        set(obj,'interruptible','on','userdata',0,'string','GO')
        Idle(1)
        return
    end
catch
    set(obj,'interruptible','on','userdata',0,'string','GO')
    Idle(1)
    err=1;
    return
end
% pour Tornsey, tous les parametres sont fixés et dans nomparamS et binf=bsup=leur valeur
% Determiner les parametres constants
paramfixes=zeros(1, nf);
for i=1:length(nomparamS)
    tag=[nomparamS{i}, '_fix_tornsey'];
    if strcmp(get(data.(tag), 'Visible'), 'on')
        paramfixes(i)=1;
    end
end
% Creation du reseau, i.e des temps de calcul
t0=0;
pas=(data.tempsmaxtornsey-t0)/(data.nbtemps-1);
reseau=t0:pas:data.tempsmaxtornsey;

%% On verifie que tous les parametres ne sont pas constants
if sum(paramfixes) >= nf
    errordlg('No parameter is unfixed',     'Bad Input','modal')
end

%% On y va
% recupérer l'unité de temps des param pour l'afficher
z=[ nomparamS  nomparamP];
data= recup_temps(data, z, data.Basemodeles.type);
[ evoldet, dx, proba, iter,  optima,  titregraphe, soustitre, indice_panel, data]= ...
    calcStrategieOptTornsey(reseau, nf, paramfixes, data.binf, ...
    data.maxiter, data.eps, data.uniteT_libelle, ...
    data.seuiltornsey, data.modelepop, ...
 data, obj , evnt);

%% Maj de la structure data
handles=guihandles(1);
data=catstruct(handles,data);


%% Completion du data par ce qui est nécessaire a sauvegarde/restauration
% Mettre l'indice de la méthode
data.methode=methodecur;
data.nommethode='Tornsey';
data.iter=iter;
data.reseau=reseau;
data.dx=dx;
data.evoldet=evoldet(:, 2);
data.proba=proba;
data.nomparamP=nomparamP;
data.nomparamS=nomparamS;
data.titregraphe=titregraphe;
data.soustitre= soustitre;
data.optima=optima;
dataout=data;
end % fin go_tornsey





%% ======================================================
function STRATEGIEOPT(obj,evnt)
%STRATEGIEOPT Fonction principale de la simulation d'un jeu de données
% INPUT/OUTPUT
% La propriété userdata de obj = 1 quand l'exécution est en cours
% et 0 quand l'exécution est stoppée
% evnt=1 en mode non interactif (pour faire passer une batterie de tests)
%% ======================================================


% Verifier que les entrees sont correctes

if verif_input(obj)==1
    return
end

data=guidata(1);
% Effacer l'éventuel nom du fichier restauré
if strfind(get(data.fichier_type_tag, 'string'), 'RESTORE')
    set(data.fichier_fic_tag, 'visible', 'off');
    set(data.fichier_nofic_tag, 'visible', 'on');
end

data.methode = get(data.methode_tag, 'value');


% mettre le pointeur a l'etat occupe
Busy(1)
% changement de l'image du bouton d'estimation
if ~iscell(get(obj,'userdata'))
    if get(obj,'userdata')==1
        set(obj,'interruptible','off','userdata',0)
        return
    else
        set(obj,'interruptible','on','userdata',1,'string','STOP')
    end
end



% mise a jour des modifications graphiques
drawnow
% suppression des eventuels objets graphiques fils du panel d'affichage
delete(get(data.hpanel_work,'children'))


%% control de saisie
if ~isfield(data, 'modelepop') || isempty(data.modelepop)
    errordlg('Please, select the dynamics equation model', 'NO MODELE');
    set(obj,'interruptible','on','userdata',0,'string','GO')
    Idle(1)
    return
end





%% preparation de champ text pour la numerotation des panels
uicontrol('parent',data.hpanel_work,...
    'units','normalized',...
    'foregroundcolor','k',...
    'backgroundcolor',[1 1 1],...
    'position',[0 0  1 .02],...
    'tag','com_tab_tag',...
    'style','text');
%% modification de la couleur d'arriere-plan du panel d'affichage
set(data.hpanel_work,'backgroundcolor',[1 1 1])


%% On y va

switch data.methode
    case 1
        [data,  indice_panel, err]= go_sobol(data, obj, evnt);
    case 2
        [data,  indice_panel, err]= go_tornsey(data, obj, evnt);
    case 3
        [data,  indice_panel, err]= go_sivip( data, obj, evnt);
end


%% Ecrire le panel des optima
if err <= 0
    % pas d'erreur
    if data.methode ~= 3 && data.methode ~= 1 && ~isempty(data.optima)
        data.indice_panel=indice_panel;
        data=put_indices_panels(data, indice_panel, data.hpanel_work);
    end
end


if ~ishandle(obj) %interruption via quitter
    return
end



%% retablir le GO si le panel n'a pas été détruit par une interruption volontaire
try
    set(obj,'interruptible','on','userdata',0,'backgroundcolor','r','string','GO')
end


drawnow
Idle(1)
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)

end % fin STRATEGIEOPT
%% ======================================================
function reinit_CV_sivip(obj, evnt)
% reinit_CV_sivip reinitialisation des CVs (cas sivip)
data=guidata(gcf);
CVs=data.CVs;
for i=1:length(CVs.nomparamS)
    tag= [CVs.nomparamS{i} '_tag'];
    set(data.(tag), 'String', CVs.valparamS{i});
end
end

%% ======================================================
function maj_methode(obj, evnt)
%maj_methode Choix ou changement de la méthode
%% ======================================================
%% Annuler les erreurs précédentes
global input_error;
input_error=[];

data=guidata(gcf);
methode = get(data.methode_tag, 'value');
% maj de la methode dans la barre de titre
titre= 'FILTREX: SIMULATION OF AN OPTIMAL SEQUENTIAL SAMPLING';

if methode ==1 || methode ==2
    set(data.fichier_tag, 'Visible', 'off'); % pas de fichier d'observations
    data.tobs=[]; %pas d'observations
    if isfield(data, 'uniteT_tag')
        % on a fait sisvip avant
        set(data.uniteT_tag,'value',2); % unite=heure
    end
    if isfield(data, 'uniteT_libelle')
        data.uniteT_libelle='hour';
    end
    set(data.fichier_type_tag, 'Visible', 'off');
    set(data.fichier_chemin_tag, 'Visible', 'off');
    set(data.fichier_descr_tag, 'Visible', 'off');
    set(data.fichier_no_tag, 'Visible', 'off');
    set(data.fichier_fic_tag, 'Visible', 'off');
    set(data.fichier_nofic_tag, 'Visible', 'on');
    set(data.plotdata_tag, 'Visible', 'off');
    set(data.groupesivip_tag, 'Visible', 'off'); % pas d'observations
    set(data.groupebuttonreste_tag, 'Visible', 'on');
    set(data.groupebuttonrestes_tag, 'Visible', 'off')
    set(data.reinit_filtre_tag, 'Visible', 'off'); % pas de param de filtre
    set(data.reinit_CV_sivip_tag, 'Visible', 'off'); % pas de CV
end % fin  methode ==1 || methode ==2


switch methode
    case 1
        titre=[titre ' BY SOBOL-SALTELLI METHOD'];
        set(data.plagesmax_tag, 'Visible', 'on');
    case 2
        titre=[titre ' BY D-OPTIMAL DESIGN METHOD'];
        set(data.plagesmax_tag, 'Visible', 'off');
    case 3
        titre=[titre ' BY SIVIP METHOD'];
        set(data.plagesmax_tag, 'Visible', 'on');
        set(data.fichier_tag, 'Visible', 'on'); % un fichier d'observations
       set(data.fichier_type_tag, 'Visible', 'on', ...
            'String', 'DATA');
        set(data.fichier_no_tag, 'Visible', 'on');
               
        set(data.fichier_chemin_tag, 'Visible', 'off');
        set(data.fichier_descr_tag, 'Visible', 'off');
        set(data.plotdata_tag, 'Visible', 'off');
        set(data.groupesivip_tag, 'Visible', 'on'); % parametre des observations
        set(data.reinit_filtre_tag, 'Visible', 'on'); % reinit des param de filtre
        set(data.reinit_CV_sivip_tag, 'Visible', 'on'); % reinit des CV
end

set(data.interface, 'Name',  titre);



methodepred=methode; %initialisation de la méthode précédente


if isfield(data, 'maxiter_tag') && ishandle(data.maxiter_tag)
    % la methode précédente etait Tornsey
    methodepred=2;
end
if isfield(data, 'hmax_tag') && ishandle(data.hmax_tag)
    % la methode précédente etait sivip
    methodepred=3;
end

if isfield(data, 'LHS_tag') && ishandle(data.LHS_tag)
    % la methode précédente etait Sobol
    methodepred=1;
end

% Oter l'indication eventuelle de l'unite de temps des donnees
if isfield(data, 'uniteT_libelle')
    data=rmfield(data, 'uniteT_libelle');
end

if isfield(data, 'modelepop') && ~isempty(data.modelepop)
    % un modele a ete choisi.
    s=find(strcmpi(data.Basemodeles.nom,data.modelepop));
    nomparamH = data.Basemodeles.nomparamH{s}; %parametres scotchés
    % Changement de l'affichage du modele selon la méthode:
    % Pour Sobol et sivip, il faut des min et max, pour Tornsey, il faut une seule valeur
    % pour chaque parametre: on fait comme s'ils étaient fixés
    
    if methodepred ~=2 && methode==2
        % la methode précédente etait Sobol ou sivip et on veut maintenant Tornsey
        data.Basemodeles=init_Basemodeles();
        % on considère tous les paramètres comme fixés
        data.Basemodeles.nomparamS{s}=[data.Basemodeles.nomparamP{s} data.Basemodeles.nomparamS{s}];
        
        data.Basemodeles.nomparamP{s}={}; %plus d'actifs
        % pour que des parametres soient considérés comme constants
        % Modifier la liste des parametres du modele dans l'onglet qui permet de les fixer
        
        % On détruit le menu précédent
        
        delete(get(data.dynamique_tag,'children'));
        
        nomparamfixes=data.Basemodeles.nomparamS{s};
        %Maj de l'unite de temps des param (si auparavant c'etait sivip,
        % elle a pu avoir été modifiée)
        data= recup_temps(data, nomparamfixes, data.Basemodeles.type);
        
        for i=1:length(nomparamfixes)
            if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
                % parametre fixe qu'on peut defixer
                uimenu(data.dynamique_tag, ...
		       'Label', traduc_nom(nomparamfixes{i} ),...
                    'userdata', {nomparamfixes{i}, methode}, ...
                    'callback',@gestion_parametres,...
                    'checked','on');
            end
        end
        
        
    end
    
    if (methodepred==3 && methode==1)
        % la methode précédente etait sivip et on veut sobol
        data.Basemodeles=init_Basemodeles();
        %Maj de l'unite de temps des param (si auparavant c'etait sivip,
        % elle a pu avoir été modifiée)
        nomparam=[data.Basemodeles.nomparamP{s} data.Basemodeles.nomparamS{s}];
        data= recup_temps(data, nomparam, data.Basemodeles.type);
    end
    
    if (methodepred==2  && methode==1) || (methode==3)
        % la methode précédente etait Tornsey, et on veut maintenant Sobol
        % ou  bien on veut sivip
        
        data.Basemodeles=init_Basemodeles();
           
        % Modifier la liste des parametres du modele dans l'onglet qui permet de les fixer
        delete(get(data.dynamique_tag,'children'));
        % *** Le menu qui permet de défixer des parametres fixes: ***
        nomparamfixes=data.Basemodeles.nomparamS{s};
        for i=1:length(nomparamfixes)
            if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
                % parametre fixe qu'on peut defixer
                uimenu(data.dynamique_tag, ...
		       'Label', traduc_nom(nomparamfixes{i}),...
                    'userdata', {nomparamfixes{i},methode}, ...
                    'callback',@gestion_parametres,...
                    'checked','off');
            end
        end
        
        % *** Le menu qui permet de fixer des parametres actifs:***
        nomparamactifs=data.Basemodeles.nomparamP{s};
        for i=1:length(nomparamactifs)
            uimenu(data.dynamique_tag,...
                'Label',traduc_nom(nomparamactifs{i}),...
                'userdata', {nomparamactifs{i}, methode}, ...
                'callback',@gestion_parametres,...
                'checked','on');
        end
    end
    
    guidata(1,data);
    
    
    
    data=trace_modele_simulation(s, methode);
    set(data.dynamique_tag,'visible','on');
end


% Si on change de méthode, il faut changer l'affichage des parametres de la
% méthode
if methodepred ~=methode
    data=change_para_meth(methode,  data);
    
end
data.methode=methode;

% mise à jour de la structure principale data
guidata(1,data)
drawnow
Idle(1)
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)


end % fin maj_methode

%% ======================================================
function dynamique_strat(~, ~)
%dynamique_strat Choix de la dynamique du modele
% INPUT
% Arguments ignorés
%% ======================================================
global input_error;
data=guidata(gcf);
Basemodeles=init_Basemodeles();
data.Basemodeles=Basemodeles;
str=data.Basemodeles.nom;
[s,v] = listdlg('PromptString','Select model:',...
    'ListSize',[200 350],...
    'SelectionMode','single',...
    'ListString',str);
nomparamH = Basemodeles.nomparamH{s}; % parametres scotchés
guidata(1,data);
if v
    input_error=[];
    %% Trace du modèle avec les valeurs par défaut
    meth=get(data.methode_tag, 'value');

    switch   meth
        case 1
            % sobol
            % maj de l'unite de temps des parametres
            data= recup_temps(data, Basemodeles.nomparamP{s}, Basemodeles.type);
            data=trace_modele_simulation(s, meth);
            % pas de bruit dans sobol
            set(data.groupebutton33_tag, 'visible', 'off');
            
            delete(get(data.dynamique_tag,'children'))
            Basemodeles=data.Basemodeles;
            data.modelepop=Basemodeles.nom{s};
            % *** Le menu qui permet de défixer des parametres fixes: ***
            nomparamfixes=data.Basemodeles.nomparamS{s};
            for i=1:length(nomparamfixes)
                if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
                    % parametre fixe qu'on peut defixer
                    uimenu(data.dynamique_tag, ...
                        'Label', traduc_nom(nomparamfixes{i}),...
                        'callback',@gestion_parametres,...
                        'userdata', {nomparamfixes{i}, meth}, ...
                        'checked','off');
                end
            end
            
            % *** Le menu qui permet de fixer des parametres actifs:***
            nomparamactifs=data.Basemodeles.nomparamP{s};
            for i=1:length(nomparamactifs)
                uimenu(data.dynamique_tag,...
                    'Label', traduc_nom(nomparamactifs{i}),...
                    'userdata', {nomparamactifs{i}, meth}, ...
                    'callback',@gestion_parametres,...
                    'checked','on');
            end
            set(data.plagesmax_tag, 'Visible', 'on');
        case 2
            % methode Tornsey: tous les parametres se présentent comme des fixés
            data.Basemodeles.nomparamS{s}=[data.Basemodeles.nomparamP{s} data.Basemodeles.nomparamS{s}];
            data.Basemodeles.nomparamP{s}={};
            guidata(1,data);
             data= recup_temps(data, data.Basemodeles.nomparamS{s}, Basemodeles.type);
             data=trace_modele_simulation(s,meth);
            % pour que des parametres soient considérés comme constants
            delete(get(data.dynamique_tag,'children'))
            nomparamfixes=data.Basemodeles.nomparamS{s};
            for i=1:length(nomparamfixes)
                if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
                    % parametre fixe qu'on peut defixer
                    uimenu(data.dynamique_tag,...
                        'Label',traduc_nom(nomparamfixes{i}),...
                        'callback',@gestion_parametres,...
                        'userdata', {nomparamfixes{i}, meth}, ...
                        'checked','on');
                end
                
            end
            set(data.plagesmax_tag, 'Visible', 'off');
        case 3
            % sivip
            CVs=data.CVs;
            for c=1:length(CVs.nomparamS)
                var=[CVs.nomparamS{c},'_tag'];
                set(data.(var),'enable','on');
            end
            data=trace_modele_simulation(s, meth);
            delete(get(data.dynamique_tag,'children'))
            Basemodeles=data.Basemodeles;
            data.modelepop=Basemodeles.nom{s};
            % *** Le menu qui permet de défixer des parametres fixes: ***
            nomparamfixes=data.Basemodeles.nomparamS{s};
            for i=1:length(nomparamfixes)
                if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
                    % parametre fixe qu'on peut defixer
                    uimenu(data.dynamique_tag, ...
                        'Label',traduc_nom(nomparamfixes{i}),...
                        'userdata', { nomparamfixes{i}, meth},...
                        'callback',@gestion_parametres,...
                        'checked','off');
                end
            end
            
            % *** Le menu qui permet de fixer des parametres actifs:***
            nomparamactifs=data.Basemodeles.nomparamP{s};
            for i=1:length(nomparamactifs)
                uimenu(data.dynamique_tag,...
                    'Label',traduc_nom(nomparamactifs{i}),...
                    'callback',@gestion_parametres,...
                    'userdata', {nomparamactifs{i}, meth}, ...
                    'checked','on');
            end
            set(data.plagesmax_tag, 'Visible', 'on');
    end % fin switch
    
   % Buttons to reset model parameters
 set(data.resetmod_tag,  'Visible', 'on');
set(data.resetdparam_tag,  'Visible', 'on');
    
    set(data.dynamique_tag,'visible','on')
    
    
    data.modelepop=data.Basemodeles.nom{s};
    
end
end % fin dynamique_strat
%% ======================================================
%% ======================================================
function reinit_tout(obj,event)
%reinit_tout Réinitialisation aux valeurs par défaut toutes les entrées
try
    reinit_param_sim(obj,event);
end % fin try
try
    reinit_mod_sim(obj,event);
end % fin try
data=guidata(1);
methode=get(data.methode_tag, 'value');
if methode==3
    % sivip
    reinit_filtre(obj,event);
    reinit_CV_sivip(obj,event);
end
end % fin reinit_tout
%% ================================================================
function reinit_param_sim(obj,event)
%reinit_param_sim Réinitialisation aux valeurs par défaut les parametres de simulation
% de stratégie optimale
%% ======================================================
global input_error;

data=guidata(1);
methode=get(data.methode_tag, 'value');
if methode==3
    % sivip
    reinit_param_sivip(obj,event);
    return
end
Simul = init_Simul();

for i=1:length(Simul.valparamD{methode})
    var = data.Simul.nomparamD{methode}{i};
    tag=[var,'_tag'];
    vv=data.Simul.valparamD{methode}{i};
    if isnumeric(vv)
        set(data.(tag), 'value', vv);
    else
        set(data.(tag), 'string', vv);
    end
    if length(input_error)>0 && isfield(input_error, tag)
        input_error= rmfield(input_error, tag);
    end
end

end % fin reinit_param_sim
%% ================================================================
function restore_strategie(obj,event)
%restore_strategie Restaure des résultats sauvés par saveStrat
% INPUT
% si event est une chaine de caractères, elle contient le nom du fichier
% à restaurer. C'est le cas en mode non-interactif, où on restaure
% une précédente exécution pour la relancer, (pour comparer les
% résultats à ceux du fichier d'entrée, pour tester des modifs)
% Sinon, on est en mode interactif (cas usuel), et le nom du fichier à restaurer
% sera demandé à l'utilisateur
%% ==================================================================

fileName = num2str(event);

% on sauve le nom du fichier test a cause du 'clear all' qui suit:
setenv('FILTREXTEST', fileName);
clear all; % Vider le workspace 

%% %Nettoyer les eventuels résultats précédents affichés
 data=guidata(1);

  
%% Lecture du fichier de sauvegarde
fileName = getenv('FILTREXTEST');

if isempty(fileName) 
    [fileName, pathName] = uigetfile( ...
       [getenv('PROJECTDIR') '/STRATEGY_SIMULATION/*.mat'],  'Select a Matlab file');
    if isequal(fileName,0) || isequal(pathName,0)
        return;
    end
else
    pathName= [pwd '/'];
    setenv('FILTREXTEST', ''); %raz de la va d'environnement
end

%% Nettoyer les eventuelles entrées précédentes
if isfield(data, 'hpanel_control')
    delete(get(data.hpanel_control,'children'))
    
end
%Nettoyer les eventuels résultats précédents
if isfield(data, 'hpanel_work')
    delete(get(data.hpanel_work,'children'))
end

%% Lecture du fichier de sauvegarde  
chemin=fullfile(pathName, fileName);
drawnow
load(chemin);
datalu=data; % on garde ce qu'on a lu

%% Mise a jour des panels courants
data=creer_control(); 
data.hpanel_work=creer_work();
set(data.fichier_type_tag, 'Visible', 'off');



%% Trace du modele avec les valeurs par défaut:
s=find(strcmpi(datalu.Basemodeles.nom,datalu.modelepop));

data.modelepop=datalu.modelepop;
data.Basemodeles = datalu.Basemodeles;

guidata(1,data);
data=trace_modele_simulation(s, datalu.methode);


nomparam= datalu.nomparam;
if datalu.methode==1 || datalu.methode==2
    set(data.groupebutton33_tag, 'visible', 'off');% il n'y a pas de bruit sur les parametres
    % cacher les panels de la methode sivip
    set(data.groupesivip_tag, 'Visible', 'off');
    set(data.fichier_descr_tag,'String', '', 'Visible', 'off');
    set(data.fichier_no_tag,  'Visible', 'off');
    set(data.fichier_nofic_tag,  'Visible', 'off');
    set(data.plotdata_tag, 'Visible', 'off');
    set(data.groupebuttonrestes_tag, 'Visible', 'off');
    set(data.groupebuttonreste_tag, 'Visible', 'on');
    set(data.fichier_chemin_tag, 'string', ...
        [   '  RESTORED FILENAME : ',  fileName ], 'Visible', 'on');
end
%Rque: restore_sivip fera ce qu'il faut quant a la visibilite des panels de
%sivip


if datalu.methode==1 || datalu.methode==3
    % methode sobol ou sivip: il y a des plages de valeurs pour les parametres
    for i=1:length(nomparam)
        
        var=[nomparam{i},'min'];
        
        tag=[var,'_tag'];
        if datalu.(var) < -10000 || datalu.(var) > 1000
            % mettre en format exponentiel
            set(data.(tag),'string',num2str(datalu.(var), '%8.2e'),'backgroundcolor','w');
        else
            set(data.(tag),'string',num2str(datalu.(var)),'backgroundcolor','w');
        end
        
        var=[nomparam{i},'max'];
        tag=[var,'_tag'];
        if datalu.(var) < -10000 || datalu.(var) > 1000
            set(data.(tag),'string',num2str(datalu.(var), '%8.2e'),'backgroundcolor','w');
        else
            set(data.(tag),'string',num2str(datalu.(var)),'backgroundcolor','w');
        end
        
        
    end
end

% Les parametres fixes:
nomparamS={};
if isfield(datalu, 'nomparamS') && length(datalu.nomparamS)>0
    nomparamS=datalu.nomparamS;
    for i=1:length(nomparamS)
        var=nomparamS{i};
        tag=[var,'_tag'];
        if datalu.(var) < -10000 || datalu.(var) > 1000
            set(data.(tag),'string',num2str(datalu.(var), '%8.2e'),'backgroundcolor','w');
        else
            set(data.(tag),'string',num2str(datalu.(var)),'backgroundcolor','w');
        end
        
    end
end

%% Maj de la barre du haut
try
    set(data.interface, 'Name', datalu.titre);
end

%% Maj des résultats
%% modification de la couleur d'arriere-plan du panel d'affichage
set(data.hpanel_work,'backgroundcolor',[1 1 1])

data.methode=datalu.methode;
    
   % Buttons to reset model parameters
if isfield(data, 'resetmod_tag') 
 set(data.resetmod_tag,  'Visible', 'on');
set(data.resetdparam_tag,  'Visible', 'on');
end


switch data.methode
    case 1
        [data, indice_panel]=restore_sobol(datalu, data);
       set(data.plagesmax_tag, 'Visible', 'on');
    case 2
        [data, indice_panel]=restore_tornsey(datalu, data);
       set(data.plagesmax_tag, 'Visible', 'off');
    case 3
        data=restore_sivip(datalu, data, fileName);
       set(data.plagesmax_tag, 'Visible', 'on');
    otherwise
        errordlg('Method not recognized');
        return
        
end

if data.methode ~= 3
    % petit decalage pour qu'on voit le bord du cadre
    set(data.fichier_fic_tag, 'Position', [0 0.751 1 0.05])
    
    
    %% Ecrire le panel des optima
    if ~isempty(datalu.optima)
        handles=guidata(1);
        data=catstruct(handles,data);
        data.indice_panel=indice_panel;
        % il n'y a qu'un panel: pas de numérotation
        
    end
    
    %% Affichage:
    handles=guihandles(1);
    ndata=catstruct(data,handles);
    guidata(1, ndata)
end

end % fin restore_strategie
%% ========================================================================
function [data, indice_panel]=restore_sobol(datalu, data)
%restore_sobol: restauration des resultats specifiques a sobol


%% Maj des  entrees spécifiques a la méthode
methode=1;
data.methode=methode;
data.Simul= datalu.Simul;
% Affichage des panels des  entrees spécifiques a la méthode
data=change_para_meth(methode,  data);

% mise à jour de la structure principale data
guidata(1,data)
drawnow
Idle(1)
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)
data=guidata(1);
set(data.interface, 'Name', 'FILTREX: SIMULATION OF AN OPTIMAL SAMPLING BY SOBOL-SALTELLI METHOD');


% mettre les valeurs lues dans le panel
for i=1: length(data.Simul.nomparamD{methode})
    tag = [data.Simul.nomparamD{methode}{i}, '_tag'];
    try
        set(data.(tag), 'String', datalu.(data.Simul.nomparamD{methode}{i}));
    end % fin try
end
    
set(data.methode_tag, 'value', datalu.methode);

%% Maj des resultats
data.modelepop=datalu.modelepop;
data.optima=datalu.optima;
hpanel_work=data.hpanel_work;


indice_panel=1;
tag=['panel' num2str(indice_panel) '_tag'];
hp2=uipanel('parent',hpanel_work,...
    'BorderType', 'none', ...
    'tag', tag, ...
    'BackgroundColor',[1 1 1],...
    'Position',[0 0.12 1 0.88]);

couleur={'k', 'r','g','b','k', 'm', 'c', 'k'};
h=subplot(1,1,1, 'parent',hp2);
x=0:datalu.stepsobol:max(datalu.optima);
nf = size(datalu.IST,2);
temps=0:datalu.stepsobol:datalu.tempsmaxsobol;

for p=1:nf
    plot(h, x, datalu.IST(:,p),  couleur{p})
    xlim([min(x) max(x)])
    hold on
    optima=datalu.optimaP(:,p);
    optima=optima(optima~=0);
    indices=find(ismember(temps, optima));
    plot(h, optima ,datalu.IST(indices,p) , ['s' couleur{p}]);
    grid
end


ylab='TSI (%)';
xlab='time';

annotGraphe(datalu.optima, datalu.nomparamP, datalu.titregraphe, ...
    xlab, ylab, h, data.hpanel_work);
% Mettre dans une structure 'filtrexplot' situé dans 'base'
% ce qui est nécessaire aux graphiques de façon à pouvoir
% les retracer si clic gauche dessus
sauve_hp('filtrexplot', 1,  'temps',  x, ...
    'optimaP', datalu.optimaP, 'optima', datalu.optima, ...
    'nomparam', datalu.nomparamP, ...
    'titregraphe', datalu.titregraphe, 'IST', datalu.IST, ...
    'couleur', couleur);

set(gca,'buttondownfcn',@dessin_simul_sobol);
%% *** Le menu qui permet de fixer/défixer des parametres
% On détruit le menu précédent
delete(get(data.dynamique_tag,'children'));
% *** Le menu qui permet de défixer des parametres fixes: ***
nomparamfixes=datalu.nomparamS;
for i=1:length(nomparamfixes)
    uimenu(data.dynamique_tag, ...
        'Label', traduc_nom(nomparamfixes{i}),...
        'userdata', {nomparamfixes{i}, methode}, ...
        'callback',@gestion_parametres,...
        'checked','off');
end

% *** Le menu qui permet de fixer des parametres actifs:***
nomparamactifs=datalu.nomparamP;
for i=1:length(nomparamactifs)
    uimenu(data.dynamique_tag, ...
        'Label',traduc_nom(nomparamactifs{i}),...
        'callback',@gestion_parametres,...
        'userdata', {nomparamactifs{i},methode }, ...
        'checked','on');
end
set(data.dynamique_tag,'visible','on');

end % fin restore_sobol
% ========================================================
function [data indice_panel]=restore_tornsey(datalu, data)
%restore_tornsey: restauration des resultats specifiques a tornsey


%% Maj des  entrees spécifiques a la méthode
methode=2;
data.methode=methode;
data.Simul= datalu.Simul;
% Affichage des panels des  entrees spécifiques a la méthode
data=change_para_meth(methode, data);

% mise à jour de la structure principale data
guidata(1,data)
drawnow
Idle(1)
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)
data=guidata(1);
set(data.interface, 'Name', 'FILTREX: SIMULATION OF AN OPTIMAL SAMPLING BY D-OPTIMAL DESIGN METHOD');

% mettre les valeurs lues dans le panel
for i=1:length(data.Simul.nomparamD{methode})
    tag = [data.Simul.nomparamD{methode}{i}, '_tag'];
    % le try pour compatibilite avec version < 27/8/2013 ou les noms
    % des parametres
    % qui pretent a confusion n'avaient pas le suffixe qui permet de les distinguer
    try
        set(data.(tag), 'String', datalu.(data.Simul.nomparamD{methode}{i}));
    catch
        
        nomstock= strrep(data.Simul.nomparamD{methode}{i}, 'tornsey', '');
        valstock=datalu.(nomstock);
        set(data.(tag), 'String', valstock);
    end % fin catch
    
end
set(data.methode_tag, 'value', datalu.methode);

%% Mettre la marque des parametres fixes et le
% menu qui permet de fixer/défixer des parametres
% On détruit le menu précédent
delete(get(data.dynamique_tag,'children'));

for i=1:length(data.nomparamS)
    if isfield(datalu, [data.nomparamS{i} '_fix_tornsey_in'])
        set(data.([data.nomparamS{i} '_fix_tornsey']), 'visible', 'on');
        % le menu qui permet de défixer un parametre
        uimenu(data.dynamique_tag, ...
            'Label', traduc_nom(data.nomparamS{i}),...
            'userdata', { data.nomparamS{i},methode},...
            'callback',@gestion_parametres,...
            'checked','off');
    else
        % le menu qui permet de fixer un parametre
        uimenu(data.dynamique_tag, ...
            'Label', traduc_nom(data.nomparamS{i}),...
            'userdata', { data.nomparamS{i},methode }, ...
            'callback',@gestion_parametres,...
            'checked','on');
    end
end
set(data.dynamique_tag,'visible','on');

%% Maj des resultats
data.modelepop=datalu.modelepop;
data.iter=datalu.iter;
data.reseau=datalu.reseau;
data.dx=datalu.dx;
data.optima=datalu.optima;
data.titregraphe=datalu.titregraphe;
data.nf=datalu.nf;
hpanel_work=data.hpanel_work;
indice_panel=0;

% on teste la présence du champ pour compatibilité entre versions
if isfield(datalu, 'evoldet')
    data.evoldet=datalu.evoldet;
    data.proba=datalu.proba;
    
    %1ier plot
    indice_panel=indice_panel+1;
    tag=['panel' num2str(indice_panel) '_tag'];
    hp1=uipanel('parent',hpanel_work,...
        'tag',tag,...
        'BorderType', 'none', ...
        'BackgroundColor',[1 1 1],...
        'Position',[0 0 1 1]);
    dessin1_simul_tornsey( hp1, data);
else
    data.evoldet=[];
    data.proba=[];
end

%2ieme plot
indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_tag'];
hp2=uipanel('parent',hpanel_work,...
    'tag',tag,...
    'BackgroundColor',[1 1 1],...
    'BorderType', 'none', ...
    'Position',[0 0 1 1]);
dessin_simul_tornsey( hp2, data);

%% La numérotation des panels
if indice_panel >1
    data=put_indices_panels(data, indice_panel, data.hpanel_work);
end

%% maj de l'affichage pour pouvoir retrancher des panels
handles=guihandles;
ndata=catstruct(data,handles);
guidata(gcf,ndata)


% Mettre dans une structure 'filtrexplot' situé dans 'base'
% ce qui est nécessaire aux graphiques de façon à pouvoir
% les retracer si clic gauche dessus
sauve_hp('filtrexplot', 1,  'reseau', data.reseau, ...
    'dx', data.dx,  'optima', data.optima, ...
    'nf', data.nf, ...
    'modelepop', data.modelepop, 'proba', data.proba, ...
    'iter', data.iter, 'evoldet', data.evoldet, ...
    'titregraphe', data.titregraphe);


set(gca,'buttondownfcn',@dessin_simul_tornsey);


%% concatenation des deux structures handles et data
handles=guihandles(1);
data=catstruct(handles,data);

end % fin restore_tornsey
