function [tist, tistcalcul, IST, PIST, Q2cumY1, explY1c, indice_panel, data] =calculer_sivip(i, ti, tist, tistcalcul, ...
    fetat, Xt, vobs_or, sivipargu,  indice_panel, ...
    pourcentbruitetat,   nombre_particules, ...
    nomparam, nomparamS, paramS, data, evnt)
%calculer_sivip Calculer les IST
% INPUT
% i: indice du temps de calcul
% ti: temps de calcul
% INPUT/OUTPUT
% tist: vecteur des temps optimaux
% tistcalcul: vecteur des temps ou il faut calculer les sivip
% (idem que tist si ce n'est qu'il ne contient pas les temps
% trop proches du précédent)
% evnt=1 si passage de test, vide sinon
% OUTPUT
% IST: les Indices de sensibilité totaux (np X nbre de temps qui suivent vobs_or(i))
% PIST: idem en pourcentage
% Q2cumY1: les Q2 cumulés (hmax X nbre de temps qui suivent vobs_or(i))
% explY1c: les taux d'explication de Y (hmax X nbre de temps qui suivent vobs_or(i))
%% ======================================================
% Initialisations
% cacher les graphes tant qu'on n'est pas a la derniere iteration de
% filtre_particulaire
visible='Off';

%% Calculer le modele avec les valeurs courantes des parametres pour
% tous les temps de calcul qui suivent ti

% La réponse au temps ti a deja ete calculée dans Xt(end,:)
sivipargu.Yrep(:, 1)= Xt(end,:);
if i < length(vobs_or)
    lestempssuiv= vobs_or( (i+1):end);
    
    for ii=1:length(lestempssuiv)
        tii=lestempssuiv(ii);
        Xt = fetat(Xt,tii,pourcentbruitetat, ...
            nomparam, nomparamS, paramS);
        sivipargu.Yrep(:, ii+1) = Xt(end, :);
    end
    
    ntemps = length(lestempssuiv)+1; % nbre de temps de réponses
else
    % si on est au dernier temps de calcul, il n'y a qu'une réponse: celle au dernier temps
    % qui a deja ete calculee dans Xt(end,:)
    ntemps=1;
end

%% Enlever de Xt la ligne qui contient la réponse
% A VOIR: s'arranger pour que le C accepte Xt avec sa ligne
% supplémentaire qui contient la réponse, plutot que de recopier dans
% Xtrav
Xtrav = Xt(1:sivipargu.np,:);


%% Appel au C
[IST PIST Q2Y1 Q2cumY1 explY1c]= calcISTsivip(sivipargu.np, nombre_particules, ntemps, sivipargu.degre, ...
    sivipargu.hmax, sivipargu.nmono, Xtrav,  sivipargu.Yrep, sivipargu.indic, ...
    sivipargu.Poly,sivipargu.E, sivipargu.F,...
    sivipargu.TT, sivipargu.WW, sivipargu.uh,sivipargu.PP,sivipargu.CC, sivipargu.wh, ...
    sivipargu.sivip, sivipargu.tsivip, sivipargu.vip, sivipargu.coryt, sivipargu.redonk);

% IST est une matrice np X ntemps contenant les IST sivip en absolu
% PIST est une matrice np X ntemps contenant les IST sivip en %
% Q2Y1, Q2cumY1,explY1c : les Q2, Q2cumulés, taux d'explication de Y, matrices hmax X ntemps
% On regarde si l'utilisateur n'a pas demand� une interruption

if isempty(evnt)
    if ~get(data.estimation_tag,'userdata')
        return
    end
end

%% calculer tistcalcul: temps qui correspond au 1ier plus grand optimum qui suit ti,
% si ti n'est pas le dernier temps de calcul
% ce sera un temps optimum

if ti<vobs_or(end)
    % Calculer le 1ier optima de chacun des np IST
    optima= zeros(sivipargu.np,1);
    yoptima=optima;
    % eliminer les optima < seuil, sauf pour le 1ier optima qui suit le
    % 1ier temps
    if i==1
        seuil=0;
    else
        seuil=sivipargu.seuil;
    end
    for unp=1:sivipargu.np
        [optima(unp), yoptima(unp)] = calcOptima(lestempssuiv, PIST(unp,2:end), 'Sivip', PIST(unp,1),...
            seuil, sivipargu.np) ;
    end
    
    %  Version avant le 20/5/2013 Prendre le plus grand
    %  [yretenu, iretenu] = max(yoptima);
    %    tpsopt=optima(iretenu);
    
    % Prendre le  temps optimum le plus proche parmi les np
    [tpsopt, iretenu]= min(optima);
    yretenu=yoptima(iretenu);
    
    
    %% Trace graphique des IST en %
    % Version où la valeur 1 correspond a tous les graphes
    %      if ( ((tist(end)== ti) && get(data.graphiques_tag, 'value') == 2) || ...
    %              get(data.graphiques_tag, 'value') == 1)
    if  (tist(end)== ti) && (get(data.graphiques_tag, 'value') == 1)
        [indice_panel, data] =graphe_sivip( tistcalcul, vobs_or, ...
            i, PIST, Q2cumY1, explY1c, sivipargu.np, nomparam, ...
            sivipargu.hmax, ...
            tpsopt, yretenu, iretenu, ...
            data.uniteT_libelle, ...
            'EVOLUTION OF THE TOTAL SENSITIVITY INDEX (%)', ...
            visible, ...
            indice_panel, data);
    end
    
    %% Stockage dans data pour pouvoir restaurer les graphiques
    data.tpsopt(end+1)= tpsopt;
    data.yretenu(end+1)= yretenu;
    data.iretenu(end+1)=iretenu;
    
    %% Stockage de l'optima suivant
    % on ne retient l'optima suivant dans le tableau final que s'il n'est
    % pas trop proche du précédent. Exception: le 1ier optima qui suit 0
    pourcentdiff=((tpsopt - tist(end))/lestempssuiv(end))*100;
    if tist(end) >0 &&  pourcentdiff < sivipargu.diffmax
        disp([' The time ' num2str(tpsopt) ' is too close (', ...
            num2str(pourcentdiff) '% < ' num2str(sivipargu.diffmax) ...
            '%) to the preceeding one: ' ...
            num2str(tist(end)) ' it is ignored']);
    else
        
        tist(end+1)=tpsopt;
    end
    
    
    
    %% Stockage du point de calcul
    tistcalcul(end+1)=tpsopt;
    
end % fin ti<vobs_or(end)

% Maj de la structure data
handles=guihandles(1);
data=catstruct(handles,data);

%% FIN CALCUL SIVIP
end % fin calculer_sivip
%%=======================================================

