function [indice_panel, data] =graphe_sivip( tistcalcul, vobs, ...
    ideb, PIST, Q2cumY1, explY1c, np, nomparam, ...
    hmax, ...
    tpsopt, yretenu, iretenu, ...
    uniteT_libelle, titre, visible, ...
    indice_panel, data)
%graphe_sivip Trace graphique des PIST
% INPUT
% tistcalcul: vecteur des temps de calcul des PIST  avant le temps courant
% vobs: temps de calcul
% ideb: 1ier temps
% PIST: les indices sivip (np X ntemps) en %
% Q2cumY1: les Q2 cumules (hmax X ntemps)
% explY1c: taux d'explication du tableau Y (hmax X ntemps)
% np: nombre de parametres
% nomparam: noms des parametres
% tpsopt: temps ou il y a le prochain optimum
% yretenu: valeur du  prochain  optimum ou vecteur de longueur 0
% iretenu: indice du parametre correspondant au prochain  optimum
%     ou vecteur de longueur 0
% visible: visibilite du graphe ('on' ou 'off')
% INPUT/OUTPUT
% indice_panel: indice du panel courant ou -1 si tracé dans une figure
% matlab
% data
%% ======================================================

%% Initialisations

couleur={'k', 'r','g','b', 'm', 'c', 'y'};
if np>length(couleur) || hmax>length(couleur)
    errordlg(['Internal error graphe_sivip: pas assez de couleurs' ...
        'Il y a ' num2str(np) ' indices et ' num2str(hmax) ' composantes ' ...
        ' mais que ' num2str(length(couleur)) ' couleurs'])
    
    return
end
legende=nomparam;
for i= 1:length(legende)
    legende(i)=traduc_nom(legende(i));
end

legende(end+1)={'Next optimal time'};

%% On  crée une nouvelle page

if indice_panel >= 0
    indice_panel=indice_panel+1;
    
    tag=['panel' num2str(indice_panel) '_tag'];
    
    hp=uipanel('parent',data.hpanel_work,...
        'tag',tag,...
        'BorderType', 'none', ...
        'BackgroundColor',[1 1 1],...
        'Visible', visible, ...
        'TitlePosition', 'centertop', ...
        'Position',[0 .02 1 0.98]);
else
    hp=figure('Name', titre );
end

subplot(3,1,1, 'parent',hp)

% se positionner dans le subplot adéquat sur la page


% OPTION if Q2 cumulated: subplot(3,1, 1)
subplot(2,1,1)

trace_ist_sivip(vobs, ideb, PIST,  tpsopt, np, uniteT_libelle, couleur);



if ~isempty(yretenu)
    % Marquer sur le graphe le 1ier  optima: c'est le point a
    % partir duquel on calculera les PIST la prochaine fois
    plot(tpsopt, yretenu, ['s' couleur{iretenu}]);
end

if indice_panel >=0
    % pas de legande quand on clique sur un graphe car elle est trop grosse
    % dans les figures matlab
    legend(legende, 'Location', 'Best', 'FontSize', 8, 'units','normalized');
    
    %% Pour pouvoir ouvrir une fenetre graphique matlab quand on clique sur un graphe
    set(gca,'buttondownfcn',@dessin_sivip);
end

%% OPTION if Q2 cumulated: 
% OPTION subplot(3,1, 2)


% OPTION legende={};
% OPTION if indice_panel >=0
% OPTION     for unp=1:hmax
% OPTION         legende{unp}=['Component ' num2str(unp)];
% OPTION     end
% OPTION end
% OPTION borne=100; % les Q2cum sont en %
% OPTION  trace_sivip(vobs, ideb, Q2cumY1, tpsopt, hmax, borne,  couleur, legende, uniteT_libelle, 'Q2 cumulated (%)');

%% Pour pouvoir ouvrir une fenetre graphique matlab quand on clique sur un graphe
% OPTION  if indice_panel >=0
% OPTION      set(gca,'buttondownfcn',@dessin_sivip);
% OPTION  end

%% Trace des explY1c
% OPTION if Q2 cumulated: subplot(3,1,3)
subplot(2,1,2);

legende={};
trace_sivip(vobs, ideb, explY1c, tpsopt, hmax, 100,  couleur, legende, uniteT_libelle, 'Y explanation level (%)');
if indice_panel >=0
    set(gca,'buttondownfcn',@dessin_sivip);
    titre='TOTAL SENSIVITY INDEX EVOLUTION';
    hptitre= uipanel('parent',hp,...
        'BackgroundColor',[1 1 1],...
        'BorderType', 'none', ...
        'Position', [0 0.965 1 0.035]);
    
    hax= axes('Position', [0 0 1 1],'parent',hptitre, 'Visible', 'off');
    text(0.5, 0.08, titre, 'FontSize',12,'HorizontalAlignment','center', 'Parent', hax)
end
end %% fin graphe_sivip
%% ======================================================

function dessin_sivip(obj, evt )
%dessin_sivip Trace graphique des PIST courants dans une figure matlab

%% ======================================================

%% Initialisations
data=guidata(1);
deltaT= str2num(get(data.deltaT_tag, 'String'));
np=length(data.nomparam);

deltaT= str2num(get(data.deltaT_tag, 'String'));
vobs=data.vobs;
np=length(data.nomparam);
indice_panel=-1; % on fait les tracés dans une figure matlab
hmax=size(data.Q2cumY1{1},1);
for ideb=1:(length(data.tistcalcul)-1)
    iobs=find(vobs == data.tistcalcul(ideb));
    graphe_sivip( data.tistcalcul(1:ideb), vobs, ...
        iobs, data.PIST{ideb}, data.Q2cumY1{ideb}, data.explY1c{ideb},np, data.nomparam, ...
        hmax, ...
        data.tpsopt(ideb), data.yretenu(ideb), data.iretenu(ideb), ...
        data.uniteT_libelle, ...
        'EVOLUTION OF THE TOTAL SENSITIVITY INDEX', ...
        'On', ...
        indice_panel, data);
    
end % fin ideb

end %% fin dessin_sivip


%% =========================================================
function trace_ist_sivip(vobs, ideb, PIST, tpsopt, np, uniteT_libelle,  couleur)
% Trace graphique des PIST
% INPUT
%  vobs: vecteur des temps
%  ideb: indice dans vobs du temps de démarrage des courbes
%  np: nombre de parametres
%  PIST: tableau (np, nombre de temps) des IST en %
%  nomparam: (np) noms des parametres
%% =========================================================


% c'est un trace de pourcentage, aller jusqu'a 100
borne=100;

axis([vobs(1) vobs(end) 0 borne])

for unp=1:np
    line(vobs(ideb: end), PIST(unp,:), 'Color', couleur{unp})
    hold on
end
% une fleche là où on commence, sauf pour le point 0
% Rque: on ne met pas une annotation 'arrow' car il faut alors exprimer les coordonnées
% en portion de la taille totale de la figure, y compris les marges
if ideb >1
    x=[vobs(ideb), vobs(ideb)];
    y=[max(max(PIST)), 0];
    l1=line(x,y, 'LineStyle', '--');
    l2=line(x, [0 0], 'Marker', 'v');
    % l'oter de la légende
    hAnnotation=get(l1, 'Annotation');
    leg=get(hAnnotation, 'LegendInformation');
    set(leg, 'IconDisplayStyle', 'off');
    hAnnotation=get(l2, 'Annotation');
    leg=get(hAnnotation, 'LegendInformation');
    set(leg, 'IconDisplayStyle', 'off');
end

lelabel=['time (' ...
    uniteT_libelle, ...
    '). (Total sensivity index is calculated from the optimal time '  num2str(vobs(ideb))];
if tpsopt < vobs(end)
    lelabel=[lelabel '. Next optimal time: ' num2str(tpsopt)];
end
lelabel=[lelabel '.)'];
xlabel(lelabel);
ylabel('TSI (%)');
end % fin trace_ist_sivip
%% =========================================================


%% =========================================================
function trace_sivip(vobs, ideb, QQ, tpsopt, hmax, borne,  couleur, legende, uniteT_libelle, quoi)
% Trace graphique de QQ
% Pour avoir la meme echelle sur tous les graphes, on borne les ordonnées
% INPUT
%  vobs: vecteur des temps
%  ideb: indice dans vobs du temps de démarrage des courbes
%  hmax: nombre de courbes
% borne: borne sup. sur l'axe des y
% couleur: structure contenant la couleur des courbes (>= hmax)
% legende: structure eventuelle contenant la légende de chaque courbe (hmax)
% quoi: texte expliquant ce qu'on trace, pour le label des y
%  QQ: tableau (hmax, nombre de temps)
%% =========================================================


%Les QQ sont tjrs <=borne?
% on verifie
% if any(any(QQ>borne))
%     hm=msgbox('QQ>borne');
%     waitfor(hm)
% end


axis([vobs(1) vobs(end) 0 borne])

for unp=1:hmax
    line(vobs(ideb: end), QQ(unp,:), 'Color', couleur{unp})
    hold on
end

if ~isempty(legende)
    legend(legende, 'Location', 'Best', 'FontSize', 8, 'units','normalized');
end
xlabel([ 'time (' uniteT_libelle, ')'])

%xlabel(['time (the ' quoi, ' are calculated from the optimal time '  num2str(vobs(ideb)) ...
%    ')']);
ylabel(quoi);
end % fin trace_sivip


