function[data]= init_strategie_meth(meth, data,    bgcolor)
%init_strategie_meth Initialisation du panel d'entrée specifique à la methode meth
%INPUT
% meth: 1 si Sobol, 2 si Tornsey, 3 SIVIP
%% ======================================================
ndata=guidata(1) ;
%% Bouton help
help_icon = imread('SRC/IMG/help.jpg', 'jpg');

if meth ==3
    % Sivip
    % Oter l'apparition d'un eventuel model sobol ou tornsey precedent car
    % elle empiète sur les cadres sivip
    if ~isempty(ndata)
        set(ndata.groupebutton3_tag, 'Visible', 'off');
        set(ndata.groupebutton3sivip_tag, 'Visible', 'on');
        % deplacer le cadre qui indique l'eventuel fichier lu/restaure
        pos=[0 0.55 1 0.06];
        set(ndata.fichier_fic_tag, 'Position', pos, ...
            'Visible', 'on');
         set(ndata.fichier_no_tag, 'Visible', 'on');
        set(ndata.fichier_nofic_tag, 'Position', pos)
        set(ndata.fichier_chemin_tag,'Position', [0 0.5 1 0.5])
        % cacher les panels des autres methodes
        set(ndata.groupebuttonreste_tag, 'Visible', 'off')
        % le panel sivip
        set(ndata.groupebuttonrestes_tag, 'Visible', 'on')
    end
    set(data.groupebutton21s_tag, 'Visible', 'on');
    set(data.groupebutton22s_tag, 'Visible', 'on');
    set(data.groupebutton23s_tag, 'Visible', 'on');
    set(data.groupebutton24s_tag, 'Visible', 'on');
    
    data = init_estimation_sivip(data, bgcolor);
    data.Simul = init_Simul();
    data=init_param_sivip(data, data.groupebuttonmeth_tag,  bgcolor);
else
    set(data.groupebutton3sivip_tag, 'Visible', 'off');
    set(data.groupebutton3_tag, 'Visible', 'on');
    
    % deplacer le cadre qui indique l'eventuel fichier lu/restaure
    
    set(data.fichier_fic_tag,  'Position', [0 0.75 1 0.05])
    set(data.fichier_nofic_tag, 'Position', [0 0.75 1 0.05])
    % cacher le panel sivip
    set(data.groupebuttonrestes_tag, 'Visible', 'off')
    
    % le panel correspondant
    set(data.groupebuttonreste_tag, 'Visible', 'on')
    
    
    set(data.groupebutton21s_tag, 'Visible', 'off');
    set(data.groupebutton22s_tag, 'Visible', 'off');
    set(data.groupebutton23s_tag, 'Visible', 'off');
    set(data.groupebutton24s_tag, 'Visible', 'off');
    data.Simul = init_Simul();
    % L'ordre de presentation des parametres est different de celui
    % qu'ils ont dans data.Simul. ipres est leur indice sur le panel
    ipres=data.Simul.ipres{meth};
    
    % On positionne 3 parametres sur la gauche
    nbp=3;
    % largeur et hauteur des cases
    hauteur=1/nbp;
    largeur1=0.35; % case de texte
    largeur2=0.15; % case de valeur

    for i=1:3
        ii=find(ipres==i);
        var = data.Simul.nomparamD{meth}{ii};
        data.(var) = data.Simul.valparamD{meth}{ii};
        tag=[var,'_tag'] ;
        bas=1-hauteur*i;
               
                
%        if ~isempty(strfind(data.Simul.chaines{meth}{ii}, 'MAXIMAL TIME')) ...
%                 && meth==2
%             % icone d'aide
%             uicontrol('parent',data.groupebuttonmeth_tag,...
%                 'units','normalized',...
%                 'fontsize',8,...
%                 'foregroundcolor',[.4 0 .2],...
%                 'backgroundcolor',bgcolor,...
%                 'position',[0.2 bas+0.05 0.02 0.18],...
%                 'cdata', help_icon, ...
%                 'enable', 'inactive', ...
%                 'ButtonDownFcn', @help_maxtime);
%         end

    
               

    uicontrol('parent',data.groupebuttonmeth_tag,...
        'units','normalized',...
        'fontsize',9,...
        'foregroundcolor',[.4 0 .2],...
        'backgroundcolor',bgcolor,...
       'position',[0 bas  largeur1 hauteur ],...
        'style','text',...
        'HorizontalAlignment', 'center', ...
        'string',{'', [ data.Simul.chaines{meth}{ii}, '  ']});



        hd=uicontrol('parent',data.groupebuttonmeth_tag,...
            'units','normalized',...
            'position',[largeur1 bas largeur2 hauteur],...
            'backgroundcolor','w',...
            'tag',tag, ...
            'callback',@control_saisie, ...
     'userdata', {data.Simul.DF{meth}{ii}, data.Simul.chaines{meth}{ii}}, ...
            'interruptible','off',...
            'style','edit');
        set(hd,'string',eval(['data.',var]))
        data.(tag) =hd; % matlab2013a
    end

if meth==2
    % icone d'aide pour D-optimal
    uicontrol('parent',data.groupebuttonmeth_tag,...
        'units','normalized',...
        'fontsize',8,...
        'foregroundcolor',[.4 0 .2],...
        'backgroundcolor',bgcolor,...
        'position',[0.28 0.4 0.018 0.15],...
        'cdata', help_icon, ...
        'enable', 'inactive', ...
        'ButtonDownFcn', @help_Tornseyplateau);
end

if meth==1
    % icone d'aide pour Sobol
    uicontrol('parent',data.groupebuttonmeth_tag,...
        'units','normalized',...
        'fontsize',8,...
        'foregroundcolor',[.4 0 .2],...
        'backgroundcolor',bgcolor,...
        'position',[0.28 0.4 0.018 0.15],...
        'cdata', help_icon, ...
        'enable', 'inactive', ...
        'ButtonDownFcn', @help_Soboltps);
end

    
    % Mettre les derniers parametres sur la droite

    for i=4:length(data.Simul.chaines{meth})
        icase=i-3;
        ii=find(ipres==i);
        var = data.Simul.nomparamD{meth}{ii};
        data.(var) = data.Simul.valparamD{meth}{ii};
        tag=[var,'_tag'] ;
        uicontrol('parent',data.groupebuttonmeth_tag,...
            'units','normalized',...
            'fontsize',9,...
            'foregroundcolor',[.4 0 .2],...
            'backgroundcolor',bgcolor,...
            'position',[largeur1+largeur2 1-hauteur*icase  largeur1 hauteur ],...
            'style','text',...
            'HorizontalAlignment', 'center', ...
            'string',{'',[ data.Simul.chaines{meth}{ii}, '  ']});
        
        if strfind(data.Simul.chaines{meth}{ii}, 'SEED')
            control_pgmme= @control_saisie_an;
        else
            control_pgmme= @control_saisie;
        end
        
        hd=uicontrol('parent',data.groupebuttonmeth_tag,...
            'units','normalized',...
            'position', [2*largeur1+largeur2 1-hauteur*icase largeur2 hauteur],...
            'backgroundcolor', 'w',...
            'tag',tag, ...
            'callback',control_pgmme, ...
		     'userdata', {data.Simul.DF{meth}{ii}, data.Simul.chaines{meth}{ii}},...
            'interruptible','off',...
            'style','edit');
        set(hd,'string',eval(['data.',var]))
        data.(tag) =hd; % matlab2013a
    end
    
end
end % fin init_strategie_meth

%% =================================================
function[data]= init_param_sivip(data, groupebutton_sivip_argu,  bgcolor)
%init_param_sivip Initialisation du panel des entrees relatif aux
%parametres de simulation
% ajout  dans data
% INPUT
% Les panels des entrées
% La couleur des panels des entrées
%% ======================================================
meth=3; % indice de la methode

nbp=3; % nombre de cases sur la gauche
% largeur et hauteur des cases
hauteur=1/nbp;

%degre du polynome
icase=1;
uicontrol('parent',groupebutton_sivip_argu,...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0 0.5 .10 hauteur],...
    'backgroundcolor',bgcolor,...
    'style','text',...
    'fontsize', 8, ...
    'HorizontalAlignment', 'right', ...
    'string',[data.Simul.chaines{meth}{icase},'  ']);

var = data.Simul.nomparamD{meth}{icase};
tag=[var,'_tag'] ;

uicontrol('parent',groupebutton_sivip_argu,...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0.12 0.5 0.08 hauteur],...
    'backgroundcolor','w',...
    'style','popupmenu',...
    'tag', tag,...
    'Min', 1, 'Max',1, ...
    'HorizontalAlignment', 'right', ...
    'value', data.Simul.valparamD{meth}{icase}, ...
     'Callback',@maj_typepoly, ...
    'string','2|3|4' );

icase=icase+1;
%le type du polynome
uicontrol('parent',groupebutton_sivip_argu,...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0 0.05 .10 hauteur],...
    'backgroundcolor',bgcolor,...
    'style','text',...
    'fontsize', 8, ...
    'HorizontalAlignment', 'right', ...
    'string',[data.Simul.chaines{meth}{icase},'  ']);

% Bouton d'aide pour le type de poly
help_icon = imread('SRC/IMG/help.jpg', 'jpg');
uicontrol('parent',groupebutton_sivip_argu,...
            'units', 'normalized', ...
            'style', 'pushbutton', ...
            'position',[0.032 0.11 0.018 0.13],...
            'enable', 'on', ...
            'backgroundcolor', 'w', ...
            'cdata', help_icon, ...
            'callBack', @help_polytype, ...
            'ButtonDownFcn', @help_polytype);
        
        
var = data.Simul.nomparamD{meth}{icase};
tag=[var,'_tag'] ;

uicontrol('parent',groupebutton_sivip_argu,...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0.12 0.05 0.16 hauteur],...
    'backgroundcolor','w',...
    'style','popupmenu',...
    'tag', tag,...
    'Min', 1, 'Max',1, ...
    'HorizontalAlignment', 'right', ...
    'value', data.Simul.valparamD{meth}{icase}, ...
    'string','full|without squares|without interactions' );

% le type quand le degre est 3
tag=[var,'3_tag'];
uicontrol('parent',groupebutton_sivip_argu,...
'Visible', 'off', ...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0.12 0.05 0.16 hauteur],...
    'backgroundcolor','w',...
    'style','popupmenu',...
    'tag', tag,...
    'Min', 1, 'Max',1, ...
    'HorizontalAlignment', 'right', ...
    'value', data.Simul.valparamD{meth}{icase}, ...
    'string','full|without 2 input interactions|without 3 input interactions|without interactions' );

% le type quand le degre est 4
tag=[var,'4_tag'];
uicontrol('parent',groupebutton_sivip_argu,...
'Visible', 'off', ...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0.12 0.05 0.16 hauteur],...
    'backgroundcolor','w',...
    'style','popupmenu',...
    'tag', tag,...
    'Min', 1, 'Max',1, ...
    'HorizontalAlignment', 'right', ...
    'value', data.Simul.valparamD{meth}{icase}, ...
    'string','full|without 2 input interactions|without 3 input interactions|without 4 input interactions|without interactions' );


%% Les autres parametres dans des cases au centre:
% Minimum entre 2 temps optima: 'diffmax_tag'
% Nombre de composantes: 'hmax_tag'
% Seuil seuil_tag
for i=1:3
    lebas= max(1-hauteur*i , 0);
    
    uicontrol('parent',groupebutton_sivip_argu,...
        'units','normalized',...
        'position',[0.28 lebas 0.3 hauteur],...
        'foregroundcolor','k',...
        'backgroundcolor',bgcolor,...
        'style','text',...
        'fontsize', 8, ...
        'HorizontalAlignment', 'right', ...
        'string',{'',[data.Simul.chaines{meth}{icase+i},'  ']});
    var = data.Simul.nomparamD{meth}{icase+i};
    tag=[var,'_tag'] ;
    
    uicontrol('parent',groupebutton_sivip_argu,...
        'units','normalized',...
        'foregroundcolor','k',...
        'position',[0.59 1-hauteur*i .1 hauteur],...
        'backgroundcolor','w', ...
        'style','edit',...
        'tag',tag,...
        'userdata', {data.Simul.DF{meth}{icase+i}, data.Simul.chaines{meth}{icase+i}}, ...
        'callback',@control_saisie, ...
        'String', data.Simul.valparamD{meth}{icase+i});
end


icase=6;

%  le nombre de graphiques à droite
uicontrol('parent',groupebutton_sivip_argu,...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0.7 0.18 .1 hauteur],...
    'backgroundcolor',bgcolor,...
    'style','text',...
    'HorizontalAlignment', 'right', ...
    'fontsize', 8, ...
    'string',[data.Simul.chaines{meth}{icase},'  ']);

var = data.Simul.nomparamD{meth}{icase};
tag=[var,'_tag'] ;

uicontrol('parent',groupebutton_sivip_argu,...
    'units','normalized',...
    'foregroundcolor','k',...
    'position',[0.81 0.22 0.08 hauteur],...
    'backgroundcolor','w',...
    'style','popupmenu',...
    'tag', tag,...
    'Min', 1, 'Max',1, ...
    'value', data.Simul.valparamD{meth}{icase}, ...
    'string','yes|no' );


end % fin init_param_sivip
%% ======================================================

