%% ======================================================
function  data=restore_sivip(datalu, data, fileName)
%restore_sivip  Restaure une structure précédemment sauvegardée
% Restaure la structure qui avait été stockée
% dans un fichier de sauvegarde matlab par le calcul
% de strategie optimale par la methode sivip

%% ======================================================
methode=3;
data.methode=methode;
data.Simul= datalu.Simul;
% Affichage des panels des  entrees spécifiques a la méthode
data=change_para_meth(methode,  data);
set(data.groupesivip_tag, 'visible', 'on');
set(data.fichier_chemin_tag, 'visible', 'on');
set(data.fichier_descr_tag, 'visible', 'on');
set(data.groupebuttonreste_tag, 'visible', 'off');
set(data.groupebuttonrestes_tag, 'visible', 'on');
set(data.modeles_tag, 'visible', 'on');

set(data.methode_tag, 'value', 3);

% mise à jour de la structure principale data
guidata(1,data)
drawnow
Idle(1)
handles=guihandles(1);
ndata=catstruct(data,handles);
guidata(gcf,ndata)
data=guidata(1);
set(data.interface, 'Name', 'FILTREX: SIMULATION OF AN OPTIMAL SAMPLING BY SIVIP METHOD');



%% Restauration du cadre qui concerne les observations
for i=1:length(data.CVs.nomparamS)
    var=data.CVs.nomparamS{i};
    tag=[var,'_tag'];
    % Quand les CVs sont a estimer, pas de valeur dans le panel du haut
    % sauf s'ils sont fixés
    try
        set(data.(tag), 'string', eval(['datalu.',var, '_in']),'backgroundcolor','w');
    end
end
% Restauration du  pas de temps des observations
try
    set(data.uniteT_tag,'value', datalu.uniteT_in);
catch
    set(data.uniteT_tag,'value', 2); %heures par defaut
end
% Restauration de l'unite de temps
try
    data.uniteT_pourcalcul=datalu.uniteT_pourcalcul_in;
catch
    data.uniteT_pourcalcul= 2; %heures par defaut
end
try
    data.uniteT_pourcalcul_libelle=datalu.uniteT_pourcalcul_libelle_in;
catch
    data.uniteT_pourcalcul_libelle='hour'; %heures par defaut
end
try
    data.uniteT_libelle=datalu.uniteT_libelle;
catch
    data.uniteT_libelle='hour'; %heures par defaut
end
try
    data.tobsfactT = datalu.tobsfactT;
end
try
    data=afficher_uniteT(data);
end

proposition = datalu.pas_tag_in;
set(data.pas_tag, 'string', proposition);
try
    if ( str2double(proposition) ~=1)
        set(data.deltaT_tag,'string',datalu.deltaT_in,  'enable', 'on');
    else
        set(data.deltaT_tag, 'string', '1', 'enable', 'off');
    end
end




%% Restauration du cadre qui concerne le filtre
for i=1:length(data.Filtre.nomparamS)
    var=data.Filtre.nomparamS{i};
    varin=[var, '_in'];
    if isfield(datalu, varin)
        data.(var)=datalu.(varin);
    else
        data.(var)=data.Filtre.valparamS{i}; %valeur par defaut
    end
    tag=[var,'_tag'];
    
    style=get(data.(tag),'style');
    if strcmpi(style, 'listbox')
        set(data.(tag),'value', data.(var),'backgroundcolor','w');
    else
        set(data.(tag),'string',data.(var),'backgroundcolor','w');
    end
end



%% Restauration du cadre qui concerne les parametres du sivip
for i=1:length(data.Simul.nomparamD{3})
    tag= [data.Simul.nomparamD{3}{i} '_tag'];
    
    style= get(data.(tag), 'style');
    
    if strcmpi(style, 'popupmenu')||strcmpi(style, 'listbox')
        type='Value';
    else
        type='String';
    end
    try
        set(data.(tag), type, eval(['datalu.sivip.', tag, '_in ']));
    end
end

%% Restaurer le choix du type de polynomes selon le degrè
maj_typepoly(); % les argu sont ignorés

degre= get(data.degre_tag, 'Value') ;

switch degre
    case 1
        % degre =2
        set(data.polytype_tag, 'Value', datalu.sivip.polytype_tag_in);
    case 2
        % degre =3
        set(data.polytype3_tag, 'Value', datalu.sivip.polytype_tag_in);
    case 3
        % degre =4
        set(data.polytype4_tag, 'Value', datalu.sivip.polytype_tag_in);
end



%% Restauration des autres valeurs utiles:
data.releveobs=datalu.releveobs;
data.tobs=datalu.tobs;
data.yobs=datalu.yobs;
data.nbrepet=datalu.nbrepet;
data.Nbestime=datalu.Nbestime;
data.logNbestime=datalu.logNbestime;
data.paramobs=datalu.paramobs;
data.soustitre=datalu.soustitre;
% fichier_nom a été intoduit en oct 2014: c'est le nom du fichier des data
if isfield(datalu, 'fichier_nom')
    set(data.fichier_chemin_tag, 'string', ...
        [  datalu.fichier_nom, '  RESTORED FILENAME : ',  fileName ], 'Visible', 'on');
else
       set(data.fichier_chemin_tag, 'string', ...
        ['  RESTORED FILENAME : ',  fileName ], 'Visible', 'on');
end 
    
set(data.fichier_descr_tag, 'visible', 'on', ...
     'String', datalu.fichier_descr);
%% Rendre visible l'onglet Data du haut
set(data.fichier_tag, 'visible', 'on');

%% rajouter la possibilite du plot des donnees
if isfield(data, 'plotdata_tag')
    set(data.plotdata_tag, 'Visible', 'on');
    set(data.plotdata_tag, 'visible', 'on');
    set(data.plotdata_tag, 'userdata', {data.tobs, data.logNbestime, fileName});
end

try
    %% Restauration du cadre qui concerne le modèle
    % D'abord, tracer le cadre avec les val par defaut:
    restore_dynamique(data,datalu);       
    data=guidata(1);
    
    % Modification des val par defaut par celles lues sur le fichier:
    s=find(strcmpi(datalu.Basemodeles.nom,datalu.modelepop));
    
    %% Restauration de la valeur des paramètres fixes:
    nomparamfixes=datalu.Basemodeles.nomparamS{s};
    if ~isempty(nomparamfixes)
        for i=1:length(nomparamfixes)
            var=nomparamfixes{i};
            tag=[nomparamfixes{i},'_tag'];
            lin=[var,'_in'] ;
            set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w');
            if any(strcmpi(nomparamfixes{i}, datalu.CVs.nomparamS))
                % le parametre est un CV
                set(data.([nomparamfixes{i},'_fixtag']), 'string',eval(['datalu.',lin]));
            end
        end
    end % length(nomparamfixes)>0
    
    %% Restauration de la valeur des paramètres à estimer:
    nomparamactifs=datalu.Basemodeles.nomparamP{s};

    %cocher si les CV sont estimés
    % En fait, les CVs ne peuvent pas etre estimés avec sivip
    if (datalu.cvinparam_in==1)
        set(data.cvinparam_tag, 'value', 1);
    end
    if ~isempty(nomparamactifs) 
        for i=1:length(nomparamactifs)
            var=[nomparamactifs{i},'min'];
            tag=[var,'_tag'];
            lin=[var,'_in'] ;
            set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w');
   
            var=[nomparamactifs{i},'max'];
            tag=[var,'_tag'];
            lin=[var,'_in'] ;
            set(data.(tag),'string',eval(['datalu.',lin]),'backgroundcolor','w')
            
            var=[nomparamactifs{i},'_bruit'];
            tag=[var,'_tag'] ;
            lin=[var,'_in'] ;
            set(data.(tag),'value',eval(['datalu.',lin]),'backgroundcolor','w');
            
        end
        
    end %if paramactifs
end % try

%%  Restauration du panel des plots et résultats
indice_panel=0;
data.hpanel_work=uipanel('FontSize',30,...
    'borderWidth',3,...
    'BackgroundColor',[1 1 1],...
    'Position',[.45 .05 0.5 .92]);
nbparam=length(datalu.nomparam);


try
    %% Graphes des IST
    % mettre dans data ce qui est necessaire au clic sur le graphe
    data.PIST=datalu.PIST;
    data.Q2cumY1=datalu.Q2cumY1;
    data.explY1c=datalu.explY1c;
    hmax=size(datalu.Q2cumY1{1},1); % nombre de composantes
    data.optima= datalu.optima;
    data.tistcalcul= datalu.tistcalcul;
    data.tpsopt = datalu.tpsopt;
    data.yretenu=datalu.yretenu;
    data.iretenu=datalu.iretenu;
    
    if length(data.tistcalcul) >=2
        %% barre de progression car ca peut etre long
        ssize=get(0,'screensize');
        jPb = javax.swing.JProgressBar;
        jPb.setIndeterminate(false);
        hPb= javacomponent(jPb,[2*ssize(3)/4 4*ssize(4)/9 ssize(3)/3 ssize(4)/9],gcf);
        set(hPb,'Visible', 1);
        refresh
        drawnow
        netapes=length(data.tistcalcul)-1;
        
        data.vobs=datalu.vobs;
        data.vobs_or=datalu.vobs_or;
        
        for ideb=1:netapes
            iobs=find(data.vobs_or == datalu.tistcalcul(ideb));
            
            set(hPb,'Value', (ideb)*100/netapes);
            % Version où la valeur 1 correspond a tous les graphes
            %        if ( get(data.graphiques_tag, 'value')==1 || ...
            %                ( get(data.graphiques_tag, 'value')==2 && ...
            %                ~isempty(find(datalu.optima==data.vobs_or(iobs)))))


            if      ( get(data.graphiques_tag, 'value')==1) && ...
                    ~isempty(find(datalu.optima==data.vobs_or(iobs)))
                               
                [indice_panel, data] =graphe_sivip( datalu.tistcalcul(1:ideb), data.vobs_or, ...
                    iobs, datalu.PIST{ideb},  datalu.Q2cumY1{ideb}, datalu.explY1c{ideb},...
                    nbparam,datalu.nomparam, hmax, ...
                    datalu.tpsopt(ideb), datalu.yretenu(ideb), datalu.iretenu(ideb), ...
						    datalu.uniteT_libelle, ...
                    'EVOLUTION OF THE TOTAL SENSITIVITY INDEX (%)', ...
                    'On', ...
                    indice_panel, data);
            end
  
        end % fin ideb
        
        
        set(hPb,'Visible',0);
        delete(hPb);
        
    end % fin length(datalu.tistcalcul) >=2
    
end %fin try

try
    %%  Restauration des temps optimaux
    % On garde le no du panel pour se positionner dessus en fin de
    % restauration
    indice_panel_tps=indice_panel;
    if  length(datalu.optima) >=1
        %       handles=guidata(1);
        % data=catstruct(handles,data);
        data.optima=datalu.optima;
        
        [indice_panel, data]=ecrire_optima(data,  indice_panel,  data.soustitre, data.hpanel_work);
        
    end % fin length(datalu.optima)
    
    
end % fin try

%% Restauration du plot de l'evolution des parametres estimes
if isfield(datalu,  'paramfin')
    % il y a des résultats: paramfin= valeurs estimées des parametres
    
    [data, indice_panel]= restore_panel_plot(data, indice_panel, datalu.filtrexplot);
    
end %fin restauration des resultats



%% La numérotation des panels
data=put_indices_panels(data, indice_panel, data.hpanel_work);

%% maj de l'affichage pour pouvoir retrancher des panels
handles=guihandles;
ndata=catstruct(data,handles);
guidata(gcf,ndata)
% Se remettre sur la  page des résultats si elle existe
try
    nbp=indice_panel - indice_panel_tps -1;
    for i=1:nbp
        retrancher_tab();
    end
end % fin try

end % restore_sivip
%% ======================================================
function  restore_dynamique(data, datalu)
%restore_dynamique Restauration du panel d'affichage du modèle :
% Trace le 'panel' d'affichage des paramètres du modèle
% avec leurs valeurs min et max, ou bien celles fixées, et leurs bruits.
% Les valeurs affichées sont celles par défaut.
% Construit aussi le menu qui permet de (dé)fixer des paramètres.
% INPUT
% data: le handle courant
% datalu: la structure qui contient les valeurs préalablement
% sauvegardées  sur un fichier
% APPELÉ PAR
%  la fonction  'restore_sivip
%% ======================================================
% *** Restauration des valeurs par défaut ***
% Basemodeles.init.<nomparam>{1 et 2} contient les val par
% défaut des bornes des parametres a estimer
% Basemodeles.valparamS.<nomparam> contient les val par
% défaut des param fixés et les bruits par défaut sont
% dans Basemodeles.initbruit.<nomparam>

data.Basemodeles=datalu.Basemodeles;
s=find(strcmpi(datalu.Basemodeles.nom,datalu.modelepop));
nomparamH = datalu.Basemodeles.nomparamH{s}; %parametres scotchés
% *** Le menu qui permet de fixer/défixer des parametres
% On détruit le menu précédent
delete(get(data.dynamique_tag,'children'));
% *** Le menu qui permet de défixer des parametres fixes: ***
nomparamfixes=datalu.Basemodeles.nomparamS{s};
for i=1:length(nomparamfixes)
    if isempty(find(strcmpi(nomparamH, nomparamfixes{i})))
        uimenu(data.dynamique_tag, ...
            'Label', traduc_nom(nomparamfixes{i}),...
            'userdata', {nomparamfixes{i}, 3}, ...
            'callback',@gestion_parametres,...
            'checked','off');
    end
end

% *** Le menu qui permet de fixer des parametres actifs:***
nomparamactifs=datalu.Basemodeles.nomparamP{s};
for i=1:length(nomparamactifs)
    uimenu(data.dynamique_tag, ...
        'Label', traduc_nom(nomparamactifs{i}),...
        'userdata', {nomparamactifs{i}, 3}, ...
        'callback',@gestion_parametres,...
        'checked','on');
end
set(data.dynamique_tag,'visible','on');

% L'affichage des paramètres du modele avec leurs valeurs par défaut:
data.modelepop=datalu.modelepop;
guidata(1,data);
trace_modele_simulation(s,3); %trace avec les valeurs par défaut

end % fin restore_dynamique
%% =================================================
function [data,indice_panel]=restore_panel_plot(data, indice_panel, ...
    filtrexplot)
%restore_panel_plot Restauration du panel des plots contenus dans une sauvegarde
%% ======================================================
nbparammodel= length(filtrexplot.nomparam);

nbobs = length(data.tobs);

indice_panel=indice_panel+1;
tag=['panel' num2str(indice_panel) '_tag'];
data=plot_evolution_para(tag, data, ...
    nbparammodel, filtrexplot.nomparam, ...
    filtrexplot.abscisses, ...
    filtrexplot.Moyenne, ...
    filtrexplot.ICInf,  filtrexplot.ICSup, ...
    filtrexplot.nbparticules);



end  % fin restore_panel_plot
%% =================================================
