function fileSave= saveStrat(obj, event)
%saveStrat Save input/output in task SIMULATION OF AN OPTIMAL SEQUENTIAL SEQUENTIAL SAMPLING
% INPUT
% event contains the name of a backup file in the case 
  % of an non interactive execution (series of tests)
%% ================================================================

% Note: this file is not in private directory because
% it is called by GO in case of tests noninteractive execution
%% ================================================================
fileSave='';

data=guidata(1);


if ~isfield(data, 'optima') || isempty(data.optima)
    errordlg('No execution has been done: it is not possible to save anything');
    return
end



% sauvegarde du titre du haut
data.titre= get(data.interface, 'Name');

methode=get(data.methode_tag, 'value');
if methode==3
    fileSave = save_sivip(obj, event);
else
    
    
    % Quand il y a des parametres fixes, ils sont placés a la fin:
    % recupérer l'ordre origine, car binf et bsup suivent l'ordre origine
    s=find(strcmpi(data.Basemodeles.nom,data.modelepop));
    bor=init_Basemodeles();
    nomorP=bor.nomparamP{s} ;
    nomorS=bor.nomparamS{s};
    data.nf=length(data.nomparamS);
    if isfield(data, 'binf')
        for i=1:length(data.nomparamP)
            indice = find(strcmpi(nomorP, data.nomparamP{i}));
            data.([data.nomparamP{i} 'max'])=data.bsup(indice);
            data.([data.nomparamP{i} 'min'])=data.binf(indice);
        end
    end
    for i=1:length(data.nomparamS)
        indice = find(strcmpi(nomorP, data.nomparamS{i}));
        if isempty(indice)
            indice = find(strcmpi(nomorS, data.nomparamS{i}));
            indice=length(nomorP)+indice;
        end
        if isfield(data, 'binf')
            data.(data.nomparamS{i})=data.binf(indice);
        end
        % Sauvegarder les parametres constants de la methode Tornsey
        letag=[data.nomparamS{i} '_fix_tornsey'];
        lesauve= [data.nomparamS{i} '_fix_tornsey_in'];
        if strcmpi(get(data.(letag), 'Visible'),  'on')
            data.(lesauve) =1;
        end
    end
    
    %% construire le nom du fichier par défaut
    switch methode
        case 1
            nommethode= 'SobolS';
        case 2
            nommethode= 'D-Opt';
        otherwise
            errordlg('Method unrecognized');
            return
    end
    
    %% Sauvegarde sur fichier
% event contient le nom d'un fichier restauré quand il s'agit
% d'une exécution de test non-interactive
% En interactif, pas d'event
if isempty(event)
    % mode interactif
%Version 2.0    uisave('data', [getenv('PROJECTDIR')  '/STRATEGY_SIMULATION/' nommethode '.' ...
%Version 2.0         strrep(data.modelepop,' ', '') '.'   date '.mat']);
    uisave('data', [getenv('PROJECTDIR')  '/STRATEGY_SIMULATION/' nommethode  ...
        datestr(now, 'yyyymmdd') data.shortmodel '.mat']);
else
    % mode batch
    [~,n,~]=fileparts(event);
    fileSave = ['../RUNTESTS/RESULTTESTS/' n, '.test.' date '.mat'];
    save( fileSave, 'data');
end

    
end
end % fin saveStrat
%% =======================================================

function   fileSave= save_sivip(obj,event)
%save_sivip Sauvegarde des parametres d'entree du calcul des sivip
% appelle sauver_modele_sivip pour le reste
% event contient le nom d'un fichier restauré quand il s'agit
% d'une exécution de test non-interactive
%% ======================================================
fileSave='';
data=guidata(1);
sivip={};
% sauvegarde du titre du haut
data.titre= get(data.interface, 'Name');
%% sauvegarde des entrees de simulation de strategie dans
% des composants de suffixe _in
% les tags box
methode=3;
for i=1:length(data.Simul.nomparamD{methode})
    letag= [(data.Simul.nomparamD{methode}{i}), '_tag'];
    style= get(data.(letag), 'style');
    
    
    letagin= [letag '_in'];
    if strcmpi(style, 'popupmenu')
        type='Value'; % les tags box
    else
        type ='String';
    end
    
    sivip.(letagin)= get(data.(letag), type);
    
end % fin i
switch(sivip.degre_tag_in)
    case 2
        sivip.polytype_tag_in = get(data.polytype3_tag, 'value');
    case 3
        sivip.polytype_tag_in = get(data.polytype4_tag, 'value');
end % fin switch

data.sivip=sivip;

% les unites de temps
data.uniteT_pourcalcul_libelle_in = data.uniteT_pourcalcul_libelle;
data.uniteT_pourcalcul_in=data.uniteT_pourcalcul;
data.uniteT_in=get(data.uniteT_tag, 'value');

try
    % sauvegarder le nom du fichier des données
    fc= get(data.fichier_chemin_tag,'string');
    data.fichier_nom= regexprep(fc, 'RESTORE.*', ''); 
end

% mise à jour de la structure principale data
guidata(1,data);
set(obj, 'userdata', 2);
fileSave = sauver_modele_sivip(obj,event);

end % fin save_sivip



%% ================================================================

function fileSave = sauver_modele_sivip(obj,event)
%sauver_modele_sivip Sauvegarde du ou des modèles dans la methode sivip
% event contient le nom d'un fichier restauré quand il s'agit
% d'une exécution de test non-interactive
%% ======================================================
fileSave ='';
data=guidata(1);

impsave = 'it is not possible to save anything'; % message d'erreur

% On rajoute à data, dans des composants de suffixe _in,
%  tout ce qu'on ne peut pas rétablir à partir de ce
% que contient data
%% Sauvegarder les CV s'ils ne sont pas à estimer
% dans le cas général, les CVs sont dans data.([var,'_tag'])
% mais s'ils sont à estimer, ils sont traités comme les autres
% parametres, d'où le try
try
    for i=1:length(data.CVs.nomparamS)
        var=data.CVs.nomparamS{i};
        lin=[var,'_in'];
        vv=get(data.([var,'_tag']),'string');
        if iscell(vv)
            vv=vv{1};
        end
        data.(lin)=eval(vv);
    end
end

% Sauvegarde des autres valeurs qui sont sous forme string:
nomvar={'nbparticules', 'deltaT', 'pas_tag', 'bruitX', 'F_noyau', 'F_perturbation', 'iclevel'};


for i=1:length(nomvar)
    nomd=[nomvar{i} '_in'];
    if strcmp(nomvar{i}, 'pas_tag' )
        nomtag=nomvar{i};
    else
        nomtag=[nomvar{i} '_tag'];
    end
    try
        style=get(data.(nomtag), 'style');
        if strcmpi(style, 'listbox')
            type='Value';
            data.(nomd)=get(data.(nomtag), type);
        else
            type='String';
            vv=get(data.(nomtag), type);
            if iscell(vv)
                vv=vv{1};
            end
            data.(nomd)=eval(vv);
        end
    catch
        errordlg(['Input are not complete: ' ...
            nomtag, ' missing. ', ...
            impsave] );
        %         return
    end
end

%% Le descriptif du fichier des données
try
    data.fichier_descr=get(data.fichier_descr_tag,'string');
end

%% stockage de la valeur de la graine aleatoire
try
    vv=get(data.graineAlea_tag,'string');
    if iscell(vv)
        vv=vv{1};
    end
    data.graineAlea_in=eval(vv);
catch
    data.graineAlea_in='CLOCK';
end



%% sauvegarde du modele
if ~isfield(data, 'modelepop') || isempty(data.modelepop)
    errordlg(['No dynamics equation model has been selected: ' impsave]);
    return
end
  [data, nomparamactifs]=sauver_mod(data, '');


%% stockage des résultats de l'étude de stabilité éventuellement
try
    valfonction={'min','max','mean','std','tinv'};
    taille=length(valfonction);
    nbactifs = length(nomparamactifs);
    data.stab_res=zeros(nbactifs, taille+1);
    data.stab_nombre_dynamique= get(data.stab_edit_tag, 'string');
    data.level_stab=get(data.level_stab_edit_tag, 'value');

    for i=1:taille
        var_tag=['data.stab_gourpebutton' num2str(i+1) '_tag'];
        eval(['child = allchild(' var_tag ');']);
        for j=1:nbactifs
            a=get(child(j), 'string');
            b=cell2mat(a);
            instr='';
            for k=1:length(b)
                instr=[instr b(k)];
            end
            eval(['z=' instr ';']);
            % les paramètres sont rangés en ordre inverse des fils
            % le fils 1 de stab_gourpebutton2 correspond au min du dernier
            % paramètre
            l=nbactifs-j+1;
            if (i~=5)
                data.stab_res(l,i)= z;
            else
                data.stab_res(l,5:6)=z;
            end
        end %fin j
    end %fin i
catch
    data.stab_nombre_dynamique= 0;
end % fin du try


%% Sauvegarde des plots (il y en a tjrs car pas d'etude de stabilite)
    data.filtrexplot = evalin('base', 'filtrexplot');

% event contient le nom d'un fichier restauré quand il s'agit
% d'une exécution de test non-interactive
% En interactif, pas d'event
if isempty(event)
    % mode interactif
    %VERSION 2.0 uisave('data', [getenv('PROJECTDIR')  '/STRATEGY_SIMULATION/SIVIP.',  data.modelepop '.' date '.mat']);
    % Extraire le nom du fichier des données
    [~,n,~]= fileparts(regexprep(data.fichier_nom, '.*DATA.*:', ''));
    n=strrep(n, ' ','');
    uisave('data', [getenv('PROJECTDIR')  '/STRATEGY_SIMULATION/Sivip'   datestr(now, 'yyyymmdd') data.shortmodel ...
        '_' n '.mat']);
else
% mode batch (cas de l'estimation seulement)
    [~,n,~]=fileparts(event);
    fileSave = ['RESULTTESTS/' n, '.test.' date '.mat'];
    disp(['Creation of file: ', fileSave]);
    save( fileSave, 'data');
end

end %fin sauver_modele_sivip


%% =============================================
  function [data, nomparamactifs]=sauver_mod(data, strnmod)
% sauver_mod
% Sauvegarde du modele strnmod
%% =============================================
  % strnmod='' si un seul modèle, '1' ou '2' s'il y en a 2



  lemodele = ['modelepop' strnmod]; 
  s=find(strcmpi(data.Basemodeles.nom,data.(lemodele)));
% si les CV sont a estimer
data.cvinparam_in = get(data.cvinparam_tag, 'value');
nomCVs=data.CVs.nomparamS;

% Sauvegarde des parametres du modele à estimer
% dans data.<nomparam>max_1(ou _mod2)_in
% idem les min
% Sauvegarde du bruit des parametres dans <nomparam>bruit1(ou 2)_in
nomparamactifs=data.Basemodeles.nomparamP{s};

for i=1:length(nomparamactifs)
     if strcmp(strnmod, '') 
          cv=1;
     else
        if any(strcmpi(nomparamactifs{i}, nomCVs))
        % le parametre est un CV a estimer
        cv=1;
        else
         cv=0;
         end
      end
      if  cv==1
        tagout=[nomparamactifs{i} 'max_in'] ;
        tagin=[nomparamactifs{i} 'max_tag'];
    else
        tagout=[nomparamactifs{i} 'max' strnmod '_in'] ;
        tagin=[nomparamactifs{i} 'max_mod' strnmod '_tag'];
    end
    % Pour tenir compte des empilements des interfaces d'entree
    vv=get(data.(tagin),'string');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
    
    if cv==1
        tagout=[nomparamactifs{i} 'min_in'] ;
        tagin=[nomparamactifs{i} 'min_tag'];
    else
        tagout=[nomparamactifs{i} 'min' strnmod '_in'] ;
        tagin=[nomparamactifs{i} 'min_mod' strnmod '_tag'];
    end
    vv=get(data.(tagin),'string');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
    
    if cv==1
        tagout=[nomparamactifs{i} '_bruit_in'] ;
        tagin=[nomparamactifs{i} '_bruit_tag'];
    else
        tagout=[nomparamactifs{i} '_bruit' strnmod '_in'] ;
        tagin=[nomparamactifs{i} '_bruit_mod' strnmod '_tag'];
    end
    vv=get(data.(tagin),'value');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
end
    
% Sauvegarde des parametres du modele fixes dans <nomparam>(ou 2)_in
nomparamfixes=data.Basemodeles.nomparamS{s};
for i=1:length(nomparamfixes)

     if strcmp(strnmod, '') 
          cv=1;
     else
        if any(strcmpi(nomparamfixes{i}, nomCVs))
        % le parametre est un CV fixe
        cv=1;
        else
         cv=0;
         end
      end



    if cv==1
        tagout=[nomparamfixes{i} '_in'];
        tagin=[nomparamfixes{i}  '_tag'];
    else
        tagout=[nomparamfixes{i} strnmod '_in'];
        tagin=[nomparamfixes{i}  '_mod' strnmod  '_tag'];
    end
    vv=get(data.(tagin),'string');
    if iscell(vv)
        vv=vv{1};
    end
    data.(tagout) = vv;
end

%% stockage de l'indice du modèle
end % fin sauver_mod
%% ================================================================


