function [Xtp1, dXt]=LnRosso(Xt,t,pourcentbruit, ...
    nomparam, nomparamS, paramS)
%LnRosso Compute Rosso  model in  version neperian log
% INPUT
% See BaranyiRoberts.m
% OUTPUT
% Xtp1(end, :) model output = ln(Nt)
% dXt: vector (number of particles)
%     derivatives of the model with respect to time.
%% ============================================================
%% Affectation des  parametres a estimer
lenp=length(nomparam);
for i=1:lenp
    var=Xt(i,:);
    eval([nomparam{i},'=var;'])
    clear var
end
clear lenp
lens=length(nomparamS);
vect=ones(1,size(Xt,2));
for i=1:lens
    var=nomparamS{i};
    eval([var,'=paramS.(var).*vect;'])
    clear var
end
clear vect lens

Xtp1=Xt;


bexp=100; % borne admissible des exponentielles
%AB, 20/02/2013 if (t<=lambda) signifie que t doit etre <= a tous les
%lambda
if t<=mean(lambda)
    Xtp1(end,:)=lnN0;
    dXt= zeros(1, size(Xtp1,2));
else
    % Protéger les argu des exponentielles
    e1 = -mumax.*(t-lambda);
    e1(e1 < -bexp)= -bexp;
    exp1= exp(e1);
    A= exp(lnNmax -lnN0)-1;
    den= A.*exp1;
Xtp1(end,:)=lnNmax - log(1+den);
    % Calcul de derivee de loge(Nt) par rapport au temps dans dXt
    dXt = (den .* mumax) ./ (1+den);
end

%% Bruiter loge(Nt)
if pourcentbruit>0
    pbruit=pourcentbruit/100;
    Xtp1(end,:)= normrnd(Xtp1(end, :), pbruit);
    % =Xtp1(end,:)+(normrnd(0,1) .* pbruit .* (Xtp1(end,:)/2.0));    clear pbruit
end


    
